/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;

public class SynchronizedExp
extends Expression {
    Expression object;
    Expression body;

    public SynchronizedExp(Expression expression, Expression expression2) {
        this.object = expression;
        this.body = expression2;
    }

    public Object eval(Environment environment) throws Throwable {
        Object object2;
        Object object3 = object2 = this.object.eval(environment);
        synchronized (object3) {
            Object object4 = this.body.eval(environment);
            return object4;
        }
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        this.object.compile(compilation, Target.pushObject);
        codeAttr.emitDup(1);
        Scope scope = codeAttr.pushScope();
        Variable variable = scope.addVariable(codeAttr, Type.pointer_type, null);
        codeAttr.emitStore(variable);
        codeAttr.emitMonitorEnter();
        codeAttr.emitTryStart(false, target instanceof IgnoreTarget || target instanceof ConsumerTarget ? null : target.getType());
        this.body.compileWithPosition(compilation, target);
        codeAttr.emitLoad(variable);
        codeAttr.emitMonitorExit();
        codeAttr.emitTryEnd();
        codeAttr.emitCatchStart(null);
        codeAttr.emitLoad(variable);
        codeAttr.emitMonitorExit();
        codeAttr.emitThrow();
        codeAttr.emitCatchEnd();
        codeAttr.emitTryCatchEnd();
        codeAttr.popScope();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkSynchronizedExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.object = this.object.walk(expWalker);
        if (expWalker.exitValue == null) {
            this.body = this.body.walk(expWalker);
        }
    }

    public void print(OutPort outPort) {
        outPort.print("(Synchronized ");
        this.object.print(outPort);
        outPort.print(" ");
        this.body.print(outPort);
        outPort.print(")");
    }
}

