/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.Parser;

public abstract class ScopeExp
extends Expression {
    Declaration decls;
    Declaration last;
    Scope scope = new Scope();
    public ScopeExp outer;

    public final Declaration firstDecl() {
        return this.decls;
    }

    public void add(Declaration declaration) {
        if (this.last == null) {
            this.decls = declaration;
        } else {
            this.last.next = declaration;
        }
        this.last = declaration;
        declaration.context = this;
    }

    public void add(Declaration declaration, Declaration declaration2) {
        if (declaration == null) {
            declaration2.next = this.decls;
            this.decls = declaration2;
        } else {
            declaration2.next = declaration.next;
            declaration.next = declaration2;
        }
        if (this.last == declaration) {
            this.last = declaration2;
        }
        declaration2.context = this;
    }

    public void remove(Declaration declaration) {
        Declaration declaration2 = null;
        Declaration declaration3 = this.firstDecl();
        while (declaration3 != null) {
            if (declaration3 == declaration) {
                this.remove(declaration2, declaration);
                return;
            }
            declaration2 = declaration;
            declaration3 = declaration3.nextDecl();
        }
    }

    public void remove(Declaration declaration, Declaration declaration2) {
        if (declaration == null) {
            this.decls = declaration2.next;
        } else {
            declaration.next = declaration2.next;
        }
        if (this.last == declaration2) {
            this.last = declaration;
        }
    }

    public LambdaExp currentLambda() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof LambdaExp) {
                return (LambdaExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public ModuleExp currentModule() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof ModuleExp) {
                return (ModuleExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public Declaration lookup(String string) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration.name == string) {
                return declaration;
            }
            declaration = declaration.nextDecl();
        }
        return null;
    }

    public Declaration lookup(String string, Interpreter interpreter, int n) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration.name == string && (interpreter.getNamespaceOf(declaration) & n) != 0) {
                return declaration;
            }
            declaration = declaration.nextDecl();
        }
        return null;
    }

    public Declaration getNoDefine(String string) {
        Declaration declaration = this.lookup(string);
        if (declaration == null) {
            declaration = this.addDeclaration(string);
            declaration.setFlag(512);
        }
        return declaration;
    }

    public Declaration getDefine(String string, char c, Parser parser) {
        Declaration declaration = this.lookup(string);
        if (declaration == null) {
            declaration = this.addDeclaration(string);
        } else if (declaration.getFlag(512)) {
            declaration.setFlag(false, 512);
        } else if (declaration.getFlag(65536)) {
            declaration.setFlag(false, 65536);
        } else {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("duplicate definition for '");
            stringBuffer.append(string);
            int n = declaration.getLine();
            if (n <= 0) {
                stringBuffer.append('\'');
            } else {
                stringBuffer.append("' (overrides ");
                String string2 = declaration.getFile();
                if (string2 == null || string2.equals(parser.getFile())) {
                    stringBuffer.append("line ");
                } else {
                    stringBuffer.append(string2);
                    stringBuffer.append(':');
                }
                stringBuffer.append(n);
                int n2 = declaration.getColumn();
                if (n2 > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(n2);
                }
                stringBuffer.append(')');
            }
            parser.error(c, stringBuffer.toString());
            declaration = this.addDeclaration(string);
        }
        return declaration;
    }

    public final Declaration addDeclaration(String string) {
        Declaration declaration = new Declaration(string);
        this.addDeclaration(declaration);
        return declaration;
    }

    public final Declaration addDeclaration(String string, Type type) {
        Declaration declaration = new Declaration(string);
        this.addDeclaration(declaration);
        declaration.setType(type);
        return declaration;
    }

    public final void addDeclaration(Declaration declaration) {
        this.add(declaration);
    }

    public int countDecls() {
        int n = 0;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            ++n;
            declaration = declaration.nextDecl();
        }
        return n;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkScopeExp(this);
    }
}

