/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.Keyword;
import gnu.expr.ModuleExp;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.lists.LList;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.util.Vector;

public class LambdaExp
extends ScopeExp {
    public String name;
    public Expression body;
    public int min_args;
    public int max_args;
    Vector applyMethods;
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    static int counter;
    int id = ++counter;
    Declaration capturedVars;
    Variable heapFrame;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation;
    public ApplyExp returnContinuation;
    Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    public static final int SEQUENCE_RESULT = 1024;
    protected static final int NEXT_AVAIL_FLAG = 2048;
    public static String fileFunctionName;
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Variable thisVariable;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    Initializer initChain;
    Procedure thisValue;
    Object[] properties;
    protected Type returnType;

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public final void setInlineOnly(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public final void setNeedsStaticLink(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final void setImportsLexVars(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setImportsLexVars() {
        int n = this.flags;
        this.flags |= 8;
        if ((n & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink() {
        int n = this.flags;
        this.flags |= 0x10;
        if ((n & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    void setCallersNeedStaticLink() {
        LambdaExp lambdaExp = this.outerLambda();
        ApplyExp applyExp = this.nameDecl.firstCall;
        while (applyExp != null) {
            LambdaExp lambdaExp2 = applyExp.context;
            while (lambdaExp2 != lambdaExp) {
                lambdaExp2.setNeedsStaticLink();
                lambdaExp2 = lambdaExp2.outerLambda();
            }
            applyExp = applyExp.nextCall;
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final void setClassMethod(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public final boolean isClassGenerated() {
        return !this.getInlineOnly() && (this.isModuleBody() || this instanceof ClassExp);
    }

    public final boolean isHandlingTailCalls() {
        return this.isModuleBody() && !((ModuleExp)this).isStatic() || Compilation.usingTailCalls && !this.isModuleBody() && !this.isClassMethod();
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    public ClassType getCompiledClassType(Compilation compilation) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompiledClassType");
        }
        return this.type;
    }

    public Type getType() {
        return this.type;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    int getSelectorValue(Compilation compilation) {
        if (this.selectorValue == 0) {
            this.selectorValue = ++compilation.maxSelectorValue;
        }
        return this.selectorValue;
    }

    public final Method getMethod(int n) {
        if (this.primMethods == null || this.max_args >= 0 && n > this.max_args) {
            return null;
        }
        int n2 = n - this.min_args;
        if (n2 < 0) {
            return null;
        }
        int n3 = this.primMethods.length;
        return this.primMethods[n2 < n3 ? n2 : n3 - 1];
    }

    public final Method getMainMethod() {
        Method[] methodArray = this.primMethods;
        return methodArray == null ? null : methodArray[methodArray.length - 1];
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methodArray = this.primMethods;
        if (this.max_args >= 0 && methodArray.length > this.max_args - this.min_args) {
            return null;
        }
        Type[] typeArray = methodArray[methodArray.length - 1].getParameterTypes();
        return typeArray[typeArray.length - 1];
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp scopeExp = this;
        while ((scopeExp = scopeExp.outer) != null) {
            ScopeExp scopeExp2;
            if (!(scopeExp instanceof LambdaExp) || ((LambdaExp)(scopeExp2 = scopeExp)).getInlineOnly()) continue;
            return scopeExp2;
        }
        return null;
    }

    public LambdaExp getCaller() {
        return this.returnContinuation.context;
    }

    public Variable declareThis(ClassType classType) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.scope.addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
            this.thisVariable.setArtificial(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(classType);
        }
        return this.thisVariable;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable variable;
            LambdaExp lambdaExp = this.outerLambda();
            if (lambdaExp instanceof ClassExp) {
                lambdaExp = lambdaExp.outerLambda();
            }
            Variable variable2 = variable = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
            if (this.isClassMethod()) {
                this.closureEnv = this.declareThis(this.type);
            } else if (lambdaExp.heapFrame == null && !lambdaExp.getNeedsStaticLink() && !(lambdaExp instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method method = this.getMainMethod();
                if (!method.getStaticFlag()) {
                    this.closureEnv = this.declareThis(method.getDeclaringClass());
                } else {
                    Type type = method.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", type);
                    this.scope.addVariableAfter(null, this.closureEnv);
                    this.closureEnv.setArtificial(true);
                    this.closureEnv.setParameter(true);
                }
            } else {
                LambdaExp lambdaExp2;
                LambdaExp lambdaExp3 = lambdaExp2 = this.getInlineOnly() ? this.getCaller() : null;
                if (lambdaExp == lambdaExp2) {
                    this.closureEnv = variable;
                } else if (lambdaExp2 != null && lambdaExp == lambdaExp2.outerLambdaNotInline()) {
                    this.closureEnv = lambdaExp2.closureEnv;
                } else {
                    this.closureEnv = new Variable("closureEnv", variable.getType());
                    this.scope.addVariable(this.closureEnv);
                    this.closureEnv.setArtificial(true);
                }
            }
        }
        return this.closureEnv;
    }

    public LambdaExp() {
    }

    public LambdaExp(int n) {
        this.min_args = n;
        this.max_args = n;
    }

    public LambdaExp(Expression expression) {
        this.body = expression;
    }

    public void loadHeapFrame(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        LambdaExp lambdaExp = compilation.curLambda;
        while (lambdaExp != this && lambdaExp.getInlineOnly()) {
            lambdaExp = lambdaExp.returnContinuation.context;
        }
        if (this == lambdaExp) {
            if (this.heapFrame == null) {
                codeAttr.emitPushThis();
            } else {
                codeAttr.emitLoad(this.heapFrame);
            }
        } else {
            codeAttr.emitLoad(lambdaExp.closureEnv);
            LambdaExp lambdaExp2 = lambdaExp.outerLambda();
            while (lambdaExp2 != this) {
                if (lambdaExp2.staticLinkField != null) {
                    codeAttr.emitGetField(lambdaExp2.staticLinkField);
                }
                lambdaExp2 = lambdaExp2.outerLambda();
            }
        }
    }

    Declaration getArg(int n) {
        Declaration declaration = this.firstDecl();
        while (true) {
            if (declaration == null) {
                throw new Error("internal error - getArg");
            }
            if (n == 0) {
                return declaration;
            }
            --n;
            declaration = declaration.nextDecl();
        }
    }

    public void compileEnd(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (!this.getInlineOnly()) {
            if (compilation.method.reachableHere() && (!Compilation.usingTailCalls || this.isModuleBody() || this.isClassMethod() || this.isHandlingTailCalls())) {
                codeAttr.emitReturn();
            }
            codeAttr.popScope();
        }
        if (!Compilation.fewerClasses) {
            codeAttr.popScope();
        }
        if (this.applyMethods != null && this.applyMethods.size() > 0) {
            Method method = compilation.method;
            ClassType classType = compilation.curClass;
            compilation.curClass = this.getHeapFrameType();
            compilation.generateApplyMethods(this);
            compilation.method = method;
            compilation.curClass = classType;
        }
        if (this.heapFrame != null) {
            compilation.generateConstructor((ClassType)this.heapFrame.getType(), this);
        }
    }

    Field allocFieldFor(Compilation compilation) {
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        String string = this.getName();
        String string2 = string == null ? "lambda" : Compilation.mangleName(string);
        int n = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            if (this.nameDecl.getFlag(2048)) {
                n |= 8;
                if (!((ModuleExp)this.nameDecl.context).isStatic()) {
                    n &= 0xFFFFFFEF;
                }
            }
            if (!this.nameDecl.isPrivate()) {
                n |= 1;
            }
        } else {
            string2 = string2 + "$Fn" + ++compilation.localFieldIndex;
            if (!this.getNeedsClosureEnv()) {
                n = (n | 8) & 0xFFFFFFEF;
            }
        }
        ClassType classType = LambdaExp.getHeapLambda(this.outer).getHeapFrameType();
        ClassType classType2 = Compilation.getMethodProcType(classType);
        Field field = classType.addField(string2, classType2, n);
        if (this.nameDecl != null) {
            this.nameDecl.field = field;
        }
        return field;
    }

    final void addApplyMethod(LambdaExp lambdaExp) {
        if (this.applyMethods == null) {
            this.applyMethods = new Vector();
        }
        this.applyMethods.addElement(lambdaExp);
    }

    public Field compileSetField(Compilation compilation) {
        if (Compilation.usingCPStyle()) {
            this.compile(compilation, Type.pointer_type);
        } else {
            this.compileAsMethod(compilation);
            LambdaExp.getHeapLambda(this.outer).addApplyMethod(this);
        }
        return new ProcInitializer((LambdaExp)this, (Compilation)compilation).field;
    }

    public void compile(Compilation compilation, Target target) {
        ClassType classType;
        if (target instanceof IgnoreTarget && this.getInlineOnly()) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        if (Compilation.usingCPStyle()) {
            ClassType classType2;
            Label label = new Label(codeAttr);
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.type = lambdaExp.type;
            this.closureEnv = lambdaExp.closureEnv;
            SwitchState switchState = compilation.fswitch;
            int n = compilation.fswitch.getMaxValue() + 1;
            codeAttr.emitGoto(label);
            Type[] typeArray = codeAttr.saveStackTypeState(true);
            switchState.addCase(n, codeAttr);
            this.allocParameters(compilation);
            this.enterFunction(compilation);
            this.compileBody(compilation);
            this.compileEnd(compilation);
            compilation.curLambda = lambdaExp;
            label.define(codeAttr);
            codeAttr.restoreStackTypeState(typeArray);
            classType = classType2 = compilation.curClass;
        } else {
            LambdaExp lambdaExp = this.outerLambda();
            classType = Compilation.typeModuleMethod;
            if ((this.flags & 0x100) != 0) {
                this.compileAsMethod(compilation);
                ProcInitializer.emitLoadModuleMethod(this, compilation);
            } else {
                Field field = this.compileSetField(compilation);
                if (field.getStaticFlag()) {
                    codeAttr.emitGetStatic(field);
                } else {
                    LambdaExp lambdaExp2 = compilation.curLambda;
                    Variable variable = lambdaExp2.heapFrame != null ? lambdaExp2.heapFrame : lambdaExp2.closureEnv;
                    codeAttr.emitLoad(variable);
                    codeAttr.emitGetField(field);
                }
            }
        }
        target.compileFromStack(compilation, classType);
    }

    public ClassType getHeapFrameType() {
        if (this instanceof ModuleExp || this instanceof ClassExp) {
            return (ClassType)this.getType();
        }
        return (ClassType)this.heapFrame.getType();
    }

    public static LambdaExp getHeapLambda(ScopeExp scopeExp) {
        ScopeExp scopeExp2 = scopeExp;
        while (scopeExp2 != null) {
            if (scopeExp2 instanceof ModuleExp || scopeExp2 instanceof ClassExp || scopeExp2 instanceof LambdaExp && ((LambdaExp)scopeExp2).heapFrame != null) {
                return (LambdaExp)scopeExp2;
            }
            scopeExp2 = scopeExp2.outer;
        }
        return null;
    }

    void addMethodFor(Compilation compilation, ObjectType objectType) {
        LambdaExp lambdaExp = LambdaExp.getHeapLambda(this.outer);
        ClassType classType = lambdaExp.getHeapFrameType();
        this.addMethodFor(classType, compilation, objectType);
    }

    void addMethodFor(ClassType classType, Compilation compilation, ObjectType objectType) {
        int n;
        boolean bl;
        Object object2;
        String string = this.getName();
        LambdaExp lambdaExp = this.outerLambda();
        int n2 = this.keywords == null ? 0 : this.keywords.length;
        int n3 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        int n4 = (this.flags & 0x200) != 0 || Compilation.usingTailCalls ? 0 : n3;
        boolean bl2 = this.max_args < 0 || this.min_args + n4 < this.max_args;
        this.primMethods = new Method[n4 + 1];
        boolean bl3 = false;
        if (this.isClassMethod()) {
            if (lambdaExp instanceof ClassExp) {
                object2 = (ClassExp)lambdaExp;
                boolean bl4 = bl = ((ClassExp)object2).isMakingClassPair() && objectType != null;
                if (this == ((ClassExp)object2).initMethod) {
                    bl3 = true;
                }
            } else {
                bl = false;
            }
        } else {
            bl = this.thisVariable != null || objectType == classType ? false : (this.nameDecl == null ? true : (this.nameDecl.getFlag(4096) ? false : (this.nameDecl.getFlag(2048) ? true : (this.nameDecl.context instanceof ModuleExp ? ((ModuleExp)(object2 = (ModuleExp)this.nameDecl.context)).getSuperType() == null && ((ModuleExp)object2).getInterfaces() == null : true))));
        }
        object2 = new StringBuffer(60);
        if (!lambdaExp.isModuleBody() && !(lambdaExp instanceof ClassExp) || string == null) {
            ((StringBuffer)object2).append("lambda");
            ((StringBuffer)object2).append(++compilation.method_counter);
        }
        if (string != null) {
            ((StringBuffer)object2).append(Compilation.mangleName(string));
        }
        if (this.getFlag(1024)) {
            ((StringBuffer)object2).append("$C");
        }
        if (Compilation.usingTailCalls && !bl3 && !this.isClassMethod()) {
            ((StringBuffer)object2).append("$T");
        }
        int n5 = (bl ? 8 : 0) + (this.nameDecl != null && !this.nameDecl.isPrivate() ? 1 : 0);
        if (bl3) {
            n5 = (n5 & 0xFFFFFFFA) + 2;
        }
        if (classType.isInterface()) {
            n5 |= 0x400;
        }
        if (!bl) {
            this.closureEnv = this.declareThis(classType);
        }
        PrimType primType = this.getFlag(1024) || Compilation.usingTailCalls && !this.isClassMethod() ? Type.void_type : this.getReturnType().getImplementationType();
        int n6 = n = objectType != null && objectType != classType ? 1 : 0;
        if (Compilation.usingTailCalls && !bl3 && !this.isClassMethod()) {
            Type[] typeArray = new Type[1 + n];
            if (n > 0) {
                typeArray[0] = objectType;
            }
            typeArray[n] = Compilation.typeCallContext;
            this.primMethods[0] = classType.addMethod(((StringBuffer)object2).toString(), typeArray, primType, n5);
            this.argsArray = new Variable("argsArray", Compilation.objArrayType);
            return;
        }
        int n7 = 0;
        while (n7 <= n4) {
            int n8;
            int n9 = n8 = this.min_args + n7;
            if (n7 == n4 && bl2) {
                ++n9;
            }
            Type[] typeArray = new Type[n + n9];
            if (n > 0) {
                typeArray[0] = objectType;
            }
            Declaration declaration = this.firstDecl();
            int n10 = 0;
            while (n10 < n8) {
                typeArray[n + n10++] = declaration.getType().getImplementationType();
                declaration = declaration.nextDecl();
            }
            if (n8 < n9) {
                ((StringBuffer)object2).append("$V");
                string = ((StringBuffer)object2).toString();
                Type type = declaration.getType();
                String string2 = type.getName();
                if (n2 > 0 || n4 < n3 || !"gnu.lists.LList".equals(string2) && !"java.lang.Object[]".equals(string2)) {
                    type = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                }
                this.firstArgsArrayArg = declaration;
                typeArray[typeArray.length - 1] = type;
            }
            boolean bl5 = lambdaExp instanceof ClassExp || lambdaExp instanceof ModuleExp && ((ModuleExp)lambdaExp).getFlag(16384);
            string = ((StringBuffer)object2).toString();
            int n11 = 0;
            int n12 = ((StringBuffer)object2).length();
            block2: while (true) {
                ClassType classType2 = classType;
                while (classType2 != null) {
                    if (classType2.getDeclaredMethod(string, typeArray) != null) {
                        ((StringBuffer)object2).setLength(n12);
                        ((StringBuffer)object2).append('$');
                        ((StringBuffer)object2).append(++n11);
                        string = ((StringBuffer)object2).toString();
                        continue block2;
                    }
                    if (bl5) break block2;
                    classType2 = classType2.getSuperclass();
                }
                break;
            }
            this.primMethods[n7] = classType.addMethod(string, typeArray, primType, n5);
            ++n7;
        }
    }

    public void allocChildClasses(Compilation compilation) {
        Object object2;
        Object object3;
        Object object4;
        if (this instanceof ModuleExp) {
            ((ModuleExp)this).allocFields(compilation);
        } else {
            object4 = this.getMainMethod();
            Declaration declaration = this.firstDecl();
            if (this.isHandlingTailCalls()) {
                this.firstArgsArrayArg = declaration;
                if (!Compilation.usingTailCalls) {
                    this.scope.addVariable(null, Compilation.typeCallContext, "$ctx");
                }
            }
            while (true) {
                if (declaration == this.firstArgsArrayArg && this.argsArray != null) {
                    this.scope.addVariable(this.argsArray);
                    this.argsArray.setParameter(true);
                    this.argsArray.setArtificial(true);
                }
                if (declaration == null) break;
                object3 = declaration.var;
                if (declaration.isSimple() && !declaration.isIndirectBinding()) {
                    object3 = declaration.allocateVariable(null);
                } else {
                    object2 = Compilation.mangleName(declaration.getName()).intern();
                    declaration.var = this.scope.addVariable(null, declaration.getType(), (String)object2);
                    object3 = declaration.var;
                    ((Variable)object3).setArtificial(true);
                    ((Variable)object3).setParameter(true);
                }
                declaration = declaration.nextDecl();
            }
        }
        this.declareClosureEnv();
        if (Compilation.usingCPStyle() && compilation.curClass == compilation.mainClass) {
            return;
        }
        this.allocFrame(compilation);
        object4 = this.firstChild;
        while (object4 != null) {
            if (((LambdaExp)object4).isClassGenerated()) {
                if (((LambdaExp)object4).min_args != ((LambdaExp)object4).max_args || ((LambdaExp)object4).min_args > 4 || ((LambdaExp)object4).isHandlingTailCalls()) {
                    ((LambdaExp)object4).argsArray = new Variable("argsArray", Compilation.objArrayType);
                    ((LambdaExp)object4).firstArgsArrayArg = ((ScopeExp)object4).firstDecl();
                }
            } else if (!((LambdaExp)object4).getInlineOnly()) {
                if (!((LambdaExp)object4).getNeedsClosureEnv()) {
                    object3 = null;
                } else if (this instanceof ClassExp) {
                    object3 = this.getCompiledClassType(compilation);
                } else if ("$finit$".equals(this.getName())) {
                    object3 = this.outerLambda().getCompiledClassType(compilation);
                } else {
                    object2 = this;
                    while (((LambdaExp)object2).heapFrame == null) {
                        object2 = ((LambdaExp)object2).outerLambda();
                    }
                    object3 = (ClassType)((LambdaExp)object2).heapFrame.getType();
                }
                ((LambdaExp)object4).addMethodFor(compilation, (ObjectType)object3);
            }
            object4 = ((LambdaExp)object4).nextSibling;
        }
    }

    public void allocFrame(Compilation compilation) {
        if (this.heapFrame != null) {
            ClassType classType;
            if (this instanceof ModuleExp || this instanceof ClassExp) {
                classType = this.getCompiledClassType(compilation);
            } else {
                classType = new ClassType(compilation.generateClassName("frame"));
                if (Compilation.usingTailCalls) {
                    classType.setSuper(Type.pointer_type);
                } else {
                    classType.setSuper(Compilation.typeModuleBody);
                }
                compilation.addClass(classType);
            }
            this.heapFrame.setType(classType);
            if (!Compilation.usingTailCalls) {
                this.type = classType;
            }
        }
    }

    void allocParameters(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        int n = 0;
        int n2 = 0;
        if (this.isHandlingTailCalls() && !this.isModuleBody() && !Compilation.usingCPStyle()) {
            compilation.callStackContext = new Variable("$ctx", Compilation.typeCallContext);
            this.scope.addVariableAfter(this.thisVariable, compilation.callStackContext);
            compilation.callStackContext.setParameter(true);
            compilation.callStackContext.setArtificial(true);
        }
        codeAttr.locals.enterScope(this.scope);
        if (this.argsArray != null && this.isHandlingTailCalls()) {
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitInvoke(Compilation.typeCallContext.getDeclaredMethod("getArgs", 0));
            codeAttr.emitStore(this.argsArray);
        }
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            Variable variable = declaration.var;
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && !this.isHandlingTailCalls()) {
                codeAttr.emitLoad(this.argsArray);
                codeAttr.emitPushInt(n2);
                codeAttr.emitArrayLoad(Type.pointer_type);
                declaration.getType().emitCoerceFromObject(codeAttr);
                codeAttr.emitStore(declaration.getVariable());
            }
            ++n2;
            ++n;
            declaration = declaration.nextDecl();
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(codeAttr);
        }
    }

    void enterFunction(Compilation compilation) {
        int n;
        int n2;
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        this.scope.setStartPC(codeAttr.getPC());
        if (this.closureEnv != null && !this.closureEnv.isParameter() && !Compilation.usingCPStyle()) {
            if (this.getInlineOnly()) {
                this.outerLambda().loadHeapFrame(compilation);
            } else {
                codeAttr.emitPushThis();
                object2 = this.closureEnvField;
                if (object2 == null) {
                    object2 = this.outerLambda().closureEnvField;
                }
                codeAttr.emitGetField((Field)object2);
            }
            codeAttr.emitStore(this.closureEnv);
        }
        if (this.heapFrame != null && !Compilation.usingCPStyle()) {
            Object object3;
            object2 = (ClassType)this.heapFrame.getType();
            Declaration declaration = this.capturedVars;
            while (declaration != null) {
                if (declaration.field == null) {
                    Object object4;
                    object3 = Compilation.mangleName(declaration.getName());
                    String string = object3;
                    n2 = 0;
                    while ((object4 = ((ClassType)object2).getField(string)) != null) {
                        string = (String)object3 + '_' + ++n2;
                    }
                    object4 = declaration.getType();
                    declaration.field = ((ClassType)object2).addField(string, declaration.getType());
                }
                declaration = declaration.nextCapturedVar;
            }
            if (this.closureEnv != null && this.heapFrame != null) {
                this.staticLinkField = ((ClassType)object2).addField("staticLink", this.closureEnv.getType());
            }
            if (!(this instanceof ModuleExp) && !(this instanceof ClassExp)) {
                codeAttr.emitNew((ClassType)object2);
                codeAttr.emitDup((Type)object2);
                object3 = Compilation.getConstructor((ClassType)object2, this);
                codeAttr.emitInvokeSpecial((Method)object3);
                if (this.staticLinkField != null) {
                    codeAttr.emitDup(this.heapFrame.getType());
                    codeAttr.emitLoad(this.closureEnv);
                    codeAttr.emitPutField(this.staticLinkField);
                }
                codeAttr.emitStore(this.heapFrame);
            }
        }
        object2 = this.argsArray;
        if (this.min_args == this.max_args && !Compilation.fewerClasses && this.primMethods == null && !this.isHandlingTailCalls()) {
            object2 = null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = this.keywords == null ? 0 : this.keywords.length;
        int n6 = n = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        if (this instanceof ModuleExp) {
            return;
        }
        int n7 = -1;
        int n8 = 0;
        Method method = this.getMainMethod();
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration == this.firstArgsArrayArg && object2 != null) {
                if (this.primMethods != null && !Compilation.usingTailCalls) {
                    n7 = n3;
                    n8 = n7 - this.min_args;
                } else {
                    n7 = 0;
                    n8 = 0;
                }
            }
            if (n7 >= 0 || !declaration.isSimple() || declaration.isIndirectBinding()) {
                Type type;
                Type type2 = declaration.getType();
                Type type3 = type = method == null || n7 >= 0 ? Type.pointer_type : type2;
                if (!declaration.isSimple()) {
                    declaration.loadOwningObject(compilation);
                }
                if (n7 < 0) {
                    codeAttr.emitLoad(declaration.getVariable());
                } else if (n3 < this.min_args) {
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                } else if (n3 < this.min_args + n) {
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitArrayLength();
                    codeAttr.emitIfIntLt();
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                    codeAttr.emitElse();
                    this.defaultArgs[n8 + n4++].compile(compilation, type2);
                    codeAttr.emitFi();
                } else if (this.max_args < 0 && n3 == this.min_args + n) {
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitInvokeStatic(Compilation.makeListMethod);
                    type = Compilation.scmListType;
                } else {
                    Type[] typeArray;
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(this.min_args + n - n7);
                    compilation.compileConstant(this.keywords[n5++]);
                    Expression expression = this.defaultArgs[n8 + n4++];
                    if (expression instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type, Type.pointer_type};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        expression.compile(compilation, type2);
                        codeAttr.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        codeAttr.emitInvokeStatic(searchForKeywordMethod3);
                        codeAttr.emitDup(1);
                        compilation.compileConstant(Special.dfault);
                        codeAttr.emitIfEq();
                        codeAttr.emitPop(1);
                        expression.compile(compilation, type2);
                        codeAttr.emitFi();
                    }
                }
                if (type2 != type) {
                    CheckedTarget.emitCheckedCoerce(compilation, this, n3, type2);
                }
                if (declaration.isIndirectBinding()) {
                    declaration.pushIndirectBinding(compilation);
                }
                if (declaration.isSimple()) {
                    codeAttr.emitStore(declaration.getVariable());
                } else {
                    codeAttr.emitPutField(declaration.field);
                }
            }
            ++n3;
            declaration = declaration.nextDecl();
        }
    }

    void compileChildMethods(Compilation compilation) {
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            if (!(lambdaExp.getCanRead() || lambdaExp.getInlineOnly() || lambdaExp.isHandlingTailCalls())) {
                lambdaExp.compileAsMethod(compilation);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
    }

    void compileAsMethod(Compilation compilation) {
        int n;
        if ((this.flags & 0x80) != 0) {
            return;
        }
        this.flags |= 0x80;
        Method method = compilation.method;
        LambdaExp lambdaExp = compilation.curLambda;
        Variable variable = compilation.callStackContext;
        compilation.curLambda = this;
        Method method2 = this.primMethods[0];
        boolean bl = method2.getStaticFlag();
        int n2 = this.primMethods.length - 1;
        Type type = this.restArgType();
        int[] nArray = null;
        if (n2 > 0) {
            nArray = new int[this.min_args + n2];
            n = 0;
            Declaration declaration = this.firstDecl();
            while (n < this.min_args + n2) {
                nArray[n++] = declaration.flags;
                declaration = declaration.nextDecl();
            }
        }
        n = 0;
        while (n <= n2) {
            compilation.method = this.primMethods[n];
            if (n < n2) {
                Object object2;
                compilation.method.init_param_slots();
                CodeAttr codeAttr = compilation.getCode();
                int n3 = n + 1;
                while (n3 < n2 && this.defaultArgs[n3] instanceof QuoteExp) {
                    ++n3;
                }
                boolean bl2 = !bl;
                boolean bl3 = n3 == n2 && type != null;
                Variable variable2 = codeAttr.getArg(0);
                if (!bl) {
                    codeAttr.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = variable2;
                    }
                    variable2 = codeAttr.getArg(1);
                }
                Declaration declaration = this.firstDecl();
                int n4 = 0;
                while (n4 < this.min_args + n) {
                    declaration.flags |= 0x40;
                    declaration.var = variable2;
                    codeAttr.emitLoad(variable2);
                    variable2 = variable2.nextVar();
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                int n5 = n;
                while (n5 < n3) {
                    object2 = StackTarget.getInstance(declaration.getType());
                    this.defaultArgs[n5].compile(compilation, (Target)object2);
                    ++n5;
                    declaration = declaration.nextDecl();
                }
                if (bl3) {
                    String string = type.getName();
                    if ("gnu.lists.LList".equals(string)) {
                        object2 = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(string)) {
                        object2 = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type");
                    }
                    ((Expression)object2).compile(compilation, type);
                }
                if (bl) {
                    codeAttr.emitInvokeStatic(this.primMethods[n3]);
                } else {
                    codeAttr.emitInvokeVirtual(this.primMethods[n3]);
                }
                codeAttr.emitReturn();
                this.closureEnv = null;
            } else {
                if (nArray != null) {
                    int n6 = 0;
                    Declaration declaration = this.firstDecl();
                    while (n6 < this.min_args + n2) {
                        declaration.flags = nArray[n6++];
                        declaration.var = null;
                        declaration = declaration.nextDecl();
                    }
                }
                compilation.method.initCode();
                this.allocChildClasses(compilation);
                this.allocParameters(compilation);
                this.enterFunction(compilation);
                this.compileBody(compilation);
                this.compileEnd(compilation);
            }
            ++n;
        }
        this.compileChildMethods(compilation);
        compilation.method = method;
        compilation.curLambda = lambdaExp;
        compilation.callStackContext = variable;
    }

    public void compileBody(Compilation compilation) {
        Target target;
        if (this.isHandlingTailCalls()) {
            CodeAttr codeAttr = compilation.getCode();
            Variable variable = compilation.callStackContext;
            codeAttr.emitLoad(variable);
            codeAttr.emitGetField(Compilation.typeCallContext.getDeclaredField("consumer"));
            Scope scope = codeAttr.getCurrentScope();
            Variable variable2 = scope.addVariable(codeAttr, Compilation.typeConsumer, "$result");
            codeAttr.emitStore(variable2);
            target = new ConsumerTarget(variable2);
        } else {
            target = Target.pushValue(compilation.method.getReturnType());
        }
        this.body.compileWithPosition(compilation, target);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLambdaExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.walkChildrenOnly(expWalker);
        this.walkProperties(expWalker);
    }

    protected final void walkChildrenOnly(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            expWalker.walkDefaultArgs(this);
            if (expWalker.exitValue == null && this.body != null) {
                this.body = this.body.walk(expWalker);
            }
            Object var4_3 = null;
            expWalker.currentLambda = lambdaExp;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            expWalker.currentLambda = lambdaExp;
            throw throwable;
        }
    }

    protected final void walkProperties(ExpWalker expWalker) {
        if (this.properties != null) {
            int n = this.properties.length;
            int n2 = 1;
            while (n2 < n) {
                Object object2 = this.properties[n2];
                if (object2 instanceof Expression) {
                    this.properties[n2] = ((Expression)this.properties[n2]).walk(expWalker);
                }
                n2 += 2;
            }
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Lambda/", ")", 2);
        if (this.name != null) {
            outPort.print(this.name);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        outPort.print('(');
        Special special = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.keywords == null ? 0 : this.keywords.length;
        int n4 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n3;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            Special special2 = n < this.min_args ? null : (n < this.min_args + n4 ? Special.optional : (this.max_args < 0 && n == this.min_args + n4 ? Special.rest : Special.key));
            if (n > 0) {
                outPort.writeSpaceFill();
            }
            if (special2 != special) {
                outPort.print(special2);
                outPort.writeSpaceFill();
            }
            Expression expression = null;
            if (special2 == Special.optional || special2 == Special.key) {
                expression = this.defaultArgs[n2++];
            }
            if (expression != null) {
                outPort.print('(');
            }
            outPort.print(declaration.getName());
            if (expression != null && expression != QuoteExp.falseExp) {
                outPort.print(' ');
                expression.print(outPort);
                outPort.print(')');
            }
            ++n;
            special = special2;
            declaration = declaration.nextDecl();
        }
        outPort.print(')');
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    protected final String getExpClassName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        String string = this.getExpClassName() + ':' + this.name + '/' + this.id + '/';
        int n = this.getLine();
        if (n <= 0 && this.body != null) {
            n = this.body.getLine();
        }
        if (n > 0) {
            string = string + "l:" + n;
        }
        return string;
    }

    public Object getProperty(Object object2, Object object3) {
        if (this.properties != null) {
            int n = this.properties.length;
            while ((n -= 2) >= 0) {
                if (this.properties[n] != object2) continue;
                return this.properties[n + 1];
            }
        }
        return object3;
    }

    public synchronized void setProperty(Object object2, Object object3) {
        this.properties = Procedure.setProperty(this.properties, object2, object3);
    }

    public final Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.pointer_type;
            this.returnType = this.body.getType();
        }
        return this.returnType;
    }

    public final void setReturnType(Type type) {
        this.returnType = type;
    }

    static {
        unknownContinuation = new ApplyExp((Expression)null, null);
        fileFunctionName = "atFileLevel";
    }
}

