/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class BlockExp
extends Expression {
    Declaration label;
    Expression body;
    Expression exitBody;
    Target subTarget;
    Label exitLabel;

    public void setBody(Expression expression) {
        this.body = expression;
    }

    public void setBody(Expression expression, Expression expression2) {
        this.body = expression;
        this.exitBody = expression2;
    }

    public void compile(Compilation compilation, Target target) {
        Target target2 = target instanceof IgnoreTarget || target == Target.pushObject ? target : new StackTarget(this.getType());
        CodeAttr codeAttr = compilation.getCode();
        this.exitLabel = new Label(codeAttr);
        this.subTarget = this.exitBody == null ? target2 : Target.Ignore;
        this.body.compileWithPosition(compilation, target2);
        if (this.exitBody != null) {
            Label label = new Label(codeAttr);
            codeAttr.emitGoto(label);
            this.exitLabel.define(codeAttr);
            this.exitBody.compileWithPosition(compilation, target2);
            label.define(codeAttr);
        } else {
            this.exitLabel.define(codeAttr);
        }
        if (target2 != target) {
            target.compileFromStack(compilation, target2.getType());
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkBlockExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.body = this.body.walk(expWalker);
        if (expWalker.exitValue == null && this.exitBody != null) {
            this.exitBody = this.exitBody.walk(expWalker);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Block", ")", 2);
        if (this.label != null) {
            outPort.print(this.label.getName());
        }
        outPort.writeSpaceLinear();
        this.body.print(outPort);
        if (this.exitBody != null) {
            outPort.writeSpaceLinear();
            outPort.print("else ");
            this.exitBody.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

