/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.commonlisp.lang.Symbol;
import gnu.lists.FVector;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;
import kawa.lang.Syntax;

public class SymbolTable
extends Environment
implements Externalizable {
    static final Hashtable packageTable = new Hashtable(20);

    public static SymbolTable make(String string) {
        SymbolTable symbolTable = (SymbolTable)packageTable.get(string);
        if (symbolTable == null) {
            symbolTable = new SymbolTable();
            symbolTable.setName(string);
            packageTable.put(string, symbolTable);
        }
        return symbolTable;
    }

    public void registerPackage(String string) {
        packageTable.put(string, this);
    }

    public void registerPackage() {
        String string = this.getName();
        if (string != null) {
            packageTable.put(string, this);
        }
    }

    public void unregisterPackage() {
        String string = this.getName();
        if (string != null) {
            packageTable.remove(string);
        }
    }

    public void rename(String string) {
        this.unregisterPackage();
        this.setName(string);
        this.registerPackage();
    }

    public Object getFunction(String string) {
        return Symbol.getFunctionBinding(this, string);
    }

    public void putFunction(String string, Object object2) {
        Symbol.setFunctionBinding(this, string, object2);
    }

    public Binding define(String string, Object object2) {
        Binding binding = this.getBinding(string);
        if (object2 instanceof Procedure || object2 instanceof Syntax) {
            binding.setFunctionValue(object2);
        } else {
            binding.set(object2);
        }
        return binding;
    }

    public static Environment asEnvironment(Object object2) {
        FVector fVector;
        if (object2 instanceof FVector && !((object2 = (fVector = (FVector)object2).get(0)) instanceof Environment)) {
            object2 = new SymbolTable(fVector.size());
            fVector.set(0, object2);
        }
        return (Environment)object2;
    }

    public SymbolTable() {
    }

    public SymbolTable(int n) {
        super(n);
    }

    public SymbolTable(Environment environment) {
        super(environment);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
    }

    public Object readResolve() throws ObjectStreamException {
        String string = this.getName();
        if (string == null) {
            return this;
        }
        SymbolTable symbolTable = (SymbolTable)packageTable.get(string);
        if (symbolTable != null) {
            return symbolTable;
        }
        this.registerPackage(string);
        return this;
    }
}

