/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import java.awt.Point;
import warbot.demo.Memoire;
import warbot.demo.Tache;
import warbot.kernel.Brain;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class HalBrain
extends Brain {
    static final int GPS = 0;
    static final int newRef = 1;
    static final int accept = 2;
    static final int cap = 3;
    static final int peureux = 4;
    static final int mefiant = 5;
    static final int assaultOK = 6;
    static final int assault = 7;
    static final int fusion = 8;
    static final int fusionOK = 9;
    static final int augment = 10;
    static final int newSquad = 11;
    static final int SOS = 12;
    static final int depart = 13;
    static final int baseUnderAttack = 14;
    static final int ref_detruit = 15;
    static final int garde = 16;
    static final int vigileOK = 17;
    static final int gardeOK = 18;
    protected Memoire mem;
    protected Tache[] mesTaches;

    private void trouille() {
        this.broadcast(this.mem.monSquad, "lieutenant", "" + 4);
    }

    private void askFu() {
        this.broadcast(this.mem.monGroupe, "soldat", "" + 8, this.mem.monSquad, "" + this.mem.squadSize);
    }

    private void mefionsNous() {
        this.broadcast(this.mem.monSquad, "lieutenant", "" + 5);
    }

    protected Memoire getMem() {
        return this.mem;
    }

    protected void choix(int[] methodesChoisies) {
        int i = methodesChoisies.length - 1;
        while (i >= 0) {
            switch (methodesChoisies[i]) {
                case 0: {
                    this.explore();
                    break;
                }
                case 1: {
                    this.attaque();
                    break;
                }
                case 2: {
                    this.allerBase();
                    break;
                }
                case 3: {
                    this.fuite();
                    break;
                }
                case 4: {
                    this.askFu();
                    break;
                }
                case 5: {
                    this.fuOK();
                    break;
                }
                case 6: {
                    this.noFu();
                    break;
                }
                case 7: {
                    this.GPS();
                    break;
                }
                case 8: {
                    this.mefionsNous();
                    break;
                }
                case 9: {
                    this.trouille();
                    break;
                }
                case 10: {
                    this.sos();
                    break;
                }
                case 11: {
                    this.fuiteL();
                    break;
                }
                case 12: {
                    this.restoreHope();
                    break;
                }
                case 13: {
                    this.patrouille();
                    break;
                }
                case 14: {
                    this.alerte();
                    break;
                }
            }
            --i;
        }
    }

    protected void fuiteL() {
        Percept t = this.target();
        this.setHeading(this.towards(this.mem.laSortieX(), this.mem.laSortieY()));
        if (t == null) {
            this.move();
        } else if (this.mem.waitForRocket == 0) {
            this.mem.launchDone();
            this.launchRocket(this.towards(t.getX(), t.getY()));
        } else {
            this.move();
        }
    }

    protected void unionFaitLaForce() {
        if (this.mem.squadSize < 3) {
            this.mem.setEtat("mefiant");
        } else {
            this.mem.setEtat("courageux");
        }
    }

    public void activate() {
    }

    private int Xabsolut(int x) {
        return x + this.mem.getCoordX();
    }

    private void sos() {
        this.broadcast(this.mem.monGroupe, "soldat", "" + 12, "" + this.Xabsolut((int)this.mem.ennemi().getX()), "" + this.Yabsolut((int)this.mem.ennemi().getY()));
    }

    protected void allerA(int x, int y) {
        this.setHeading(this.towards((double)x - (double)this.mem.getCoordX(), (double)y - (double)this.mem.getCoordY()));
        this.move();
    }

    protected Tache getTache(int i) {
        return this.mesTaches[i];
    }

    protected void allerBase() {
        Point p = this.mem.posBase();
        if (Math.abs(this.mem.getCoordX() - p.x) < 40 && Math.abs(this.mem.getCoordY() - p.y) < 40) {
            this.mem.oubliBase();
            this.randomHeading();
            this.move();
        } else {
            this.allerA(p.x, p.y);
        }
    }

    public int cibleDegage(Percept p) {
        double cible = this.towards(p.getX(), p.getY());
        int i = 0;
        while (i < this.mem.nbAmis()) {
            int sens;
            Percept ami = this.mem.getAmi(i);
            double ang = this.towards(ami.getX(), ami.getY()) - cible;
            if (ang > 0.0) {
                if (ang <= 180.0) {
                    sens = -1;
                } else {
                    sens = 1;
                    ang = 360.0 - ang;
                }
            } else if ((ang = Math.abs(ang)) < 180.0) {
                sens = 1;
            } else {
                sens = -1;
                ang = 360.0 - ang;
            }
            if (ang < 50.0 && Math.sin(Math.PI * ang / 180.0) * this.distanceTo(ami) < 7.0 && this.distanceTo(ami) < this.distanceTo(p)) {
                return sens;
            }
            ++i;
        }
        return 0;
    }

    protected int plan() {
        int l = this.mesTaches.length;
        int i = l - 1;
        while (i >= 0) {
            if (this.getTache(i).applicable(this.mem)) {
                this.mem.newTache(this.getTache(i).nom());
                return i;
            }
            --i;
        }
        return 0;
    }

    public Percept target() {
        int sens = 0;
        if (this.mem.mechant()) {
            Percept e = null;
            int Emin = 100000;
            Percept p = null;
            int i = 0;
            while (i < this.mem.nbLaunchers()) {
                p = this.mem.getLauncher(i);
                if (p.getEnergy() < Emin && (sens = this.cibleDegage(p)) == 0) {
                    e = p;
                    Emin = e.getEnergy();
                }
                ++i;
            }
            if (e == null) {
                this.setHeading(this.towards(p.getX(), p.getY()) + (double)(sens * 90));
            }
            if (!this.isMoving()) {
                this.setHeading(this.towards(p.getX(), p.getY()));
            }
            return e;
        }
        if (this.mem.baseVisible()) {
            Percept P = this.mem.getBase();
            sens = this.cibleDegage(P);
            if (sens == 0) {
                return P;
            }
            this.setHeading(this.towards(P.getX(), P.getY()) + (double)(sens * 90));
            return null;
        }
        return this.mem.getDetector(0);
    }

    protected void explore() {
        this.move();
    }

    public void doIt() {
        this.updatePer();
        this.updateMess();
        this.choix(this.getTache(this.plan()).effectuer(this.mem));
    }

    protected void updateMess() {
        WarbotMessage m = null;
        boolean dejaVu = false;
        while ((m = this.readMessage()) != null) {
            int act = Integer.parseInt(m.getAct());
            this.checkMess(act, m);
        }
    }

    public void checkMess(int act, WarbotMessage m) {
        switch (act) {
            case 0: {
                this.mem.setCoordX((int)m.getFromX());
                this.mem.setCoordY((int)m.getFromY());
                break;
            }
            case 1: {
                this.mem.miseAjour(-1 * Integer.parseInt(m.getArg1()), -1 * Integer.parseInt(m.getArg2()));
                break;
            }
            case 2: {
                this.mem.messAccept.addElement(m);
                break;
            }
        }
    }

    private void noFu() {
        this.mem.messAskFu.removeAllElements();
    }

    private void fuOK() {
        int i = 0;
        while (i < this.mem.messAskFu.size()) {
            WarbotMessage m = (WarbotMessage)this.mem.messAskFu.elementAt(i);
            this.send(m.getSender(), "" + 9, this.mem.monSquad, "" + this.mem.squadSize);
            ++i;
        }
    }

    protected void jeMcasse() {
        if (!this.mem.monNom.equals(this.mem.monSquad)) {
            this.broadcast(this.mem.monSquad, "lieutenant", "" + 13, this.mem.monNom);
            this.createGroup(false, this.mem.monNom, null, null);
            this.requestRole(this.mem.monNom, "lieutenant", null);
            this.leaveGroup(this.mem.monSquad);
            this.mem.monSquad = this.mem.monNom;
            this.mem.squadSize = 1;
            this.mem.setEtat("peureux");
            this.randomHeading();
            this.mem.voisin = 0;
        }
    }

    protected void alerte() {
        this.broadcast(this.mem.monGroupe, "soldat", "" + 14);
        this.mem.deadLine = 2;
    }

    protected void patrouille() {
        this.println("______________patrouille");
        this.println("maison " + this.mem.getMaison().toString());
        double dist = Math.sqrt(Math.pow(Math.abs(this.mem.getCoordX() - this.mem.getMaison().x), 2.0) + Math.pow(Math.abs(this.mem.getCoordY() - this.mem.getMaison().y), 2.0));
        if (dist > 350.0) {
            this.setHeading(this.towards(this.mem.getMaison().x - this.mem.getCoordX(), this.mem.getMaison().y - this.mem.getCoordY()) + (Math.random() * 160.0 - 80.0));
        }
    }

    private void giveMarket(int x, int y, boolean b) {
        double dmin = 100000.0;
        double d = 0.0;
        int j = 0;
        WarbotMessage lebon = null;
        int i = 0;
        while (i < this.mem.messAccept.size()) {
            WarbotMessage w = (WarbotMessage)this.mem.messAccept.elementAt(i);
            d = Math.sqrt(Math.pow(w.getFromX(), 2.0) + Math.pow(w.getFromY(), 2.0));
            if (d < dmin) {
                dmin = d;
                lebon = w;
                j = i;
            }
            ++i;
        }
        this.send(lebon.getSender(), "" + 6, "" + this.Xabsolut(x), "" + this.Yabsolut(y));
        if (b && lebon.getArg1().equals("peureux")) {
            this.mem.messAccept.removeElementAt(j);
            if (this.mem.messAccept.size() > 0) {
                this.giveMarket(x, y, false);
            }
        }
        this.mem.messAccept.removeAllElements();
    }

    protected void updatePer() {
        this.mem.injured = this.getEnergyLevel() < this.mem.energy;
        this.mem.energy = this.getEnergyLevel();
        this.mem.clearMemory();
        if (!this.isMoving()) {
            this.randomHeading();
        }
        Percept[] detectedEntities = this.getPercepts();
        int i = 0;
        while (i < detectedEntities.length) {
            Percept e = detectedEntities[i];
            if (e.getPerceptType().equals("RocketLauncher") || e.getPerceptType().equals("Explorer")) {
                if (!e.getTeam().equals(this.getTeam())) {
                    this.mem.ajouteEnnemi(e);
                } else {
                    this.mem.ajouteAmi(e);
                }
            } else if (e.getPerceptType().equals("Home") && !e.getTeam().equals(this.getTeam())) {
                if (this.mem.baseSave()) {
                    this.mem.oubliBase();
                }
                this.mem.setBase(e);
                if (!(this.mem.maTache().startsWith("assault") || this.mem.getCoordX() == 0 && this.mem.getCoordY() == 0)) {
                    this.mem.deadLine = 2;
                    this.broadcast(this.mem.monGroupe, "soldat", "" + 7, this.mem.monSquad);
                }
            }
            ++i;
        }
        if (this.mem.getMaison().x != -1 && this.mem.getMaison().x != -1 && this.mem.getEtat().equals("peureux")) {
            this.mem.setMaison(new Point(-1, -1));
            this.broadcast(this.mem.monGroupe, "concierge", "" + 13, this.mem.monNom);
        }
        if (this.mem.deadLine == 0 && this.mem.messAccept.size() > 0) {
            if (this.mem.monNom.startsWith("HalH")) {
                if (this.mem.ennemi() == null) {
                    this.mem.messAccept.removeAllElements();
                } else {
                    this.giveMarket((int)this.mem.ennemi().getX(), (int)this.mem.ennemi().getY(), true);
                }
            } else {
                this.giveMarket((int)this.mem.getBase().getX(), (int)this.mem.getBase().getY(), false);
            }
        }
    }

    private void GPS() {
        String[] mesRoles = this.getRoles(this.mem.monGroupe);
        int i = 0;
        while (i < mesRoles.length) {
            if (mesRoles[i].equals("referentiel")) {
                this.broadcast(this.mem.monGroupe, "soldat", "" + 0);
                this.broadcast(this.mem.monGroupe, "eclaireur", "" + 0);
                this.broadcast(this.mem.monGroupe, "concierge", "" + 0);
            }
            ++i;
        }
    }

    protected void attaque() {
        Percept t = this.target();
        if (t == null) {
            this.move();
        } else if (this.mem.waitForRocket == 0) {
            this.mem.launchDone();
            this.launchRocket(this.towards(t.getX(), t.getY()));
        } else if (this.distanceTo(t) > 50.0) {
            this.setHeading(this.towards(t.getX(), t.getY()));
            this.move();
        }
    }

    protected void fuite() {
        Percept p = this.mem.ennemi();
        if (this.distanceTo(p) < 90.0) {
            Percept[] ps = this.getPercepts();
            double en = this.towards(p.getX(), p.getY());
            double agauche = 0.0;
            double adroite = 0.0;
            int i = 0;
            while (i < ps.length) {
                double angle = this.towards(ps[i].getX(), ps[i].getY());
                if ((angle = (angle - en + 360.0) % 360.0) >= 0.0 && angle < 180.0) {
                    adroite += 90.0 - Math.abs(angle - 90.0);
                } else {
                    agauche += 90.0 - Math.abs(angle - 180.0 - 90.0);
                }
                ++i;
            }
            en = agauche > adroite ? (en += 90.0) : (en -= 90.0);
            this.setHeading(en);
        }
        this.move();
    }

    private int Yabsolut(int y) {
        return y + this.mem.getCoordY();
    }

    private void restoreHope() {
        if (Math.abs(this.mem.getCoordX() - this.mem.posSOSX) < 50 && Math.abs(this.mem.getCoordY() - this.mem.posSOSY) < 50) {
            this.mem.posSOSX = 0;
            this.mem.posSOSY = 0;
            this.move();
        } else {
            this.allerA(this.mem.posSOSX, this.mem.posSOSY);
        }
    }
}

