/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.awt.Color;
import java.awt.Graphics;
import warbot.kernel.AbstractViewer;
import warbot.kernel.AwtGridCanvas;
import warbot.kernel.BasicBody;
import warbot.kernel.Rocket;

public final class DebugViewer
extends AbstractViewer {
    int width = 500;
    int height = 500;

    DebugViewer(String string) {
        super(string);
    }

    public void initGUI() {
        this.onScreen = new AwtGridCanvas(this.width, this.height, this);
        this.setGUIObject(this.onScreen);
    }

    void paintEntities(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, this.width, 0);
        graphics.drawLine(this.width, 0, this.width, this.height);
        graphics.drawLine(this.width, this.height, 0, this.height);
        graphics.drawLine(0, this.height, 0, 0);
        this.entities = this.world.getAllEntities();
        if (this.entities != null) {
            graphics.setColor(Color.red);
            for (int i = 0; i < this.entities.length; ++i) {
                if (this.entities[i] instanceof BasicBody) {
                    graphics.setColor(Color.red);
                    graphics.drawOval(this.entities[i].xcor() - this.entities[i].getRadius(), this.entities[i].ycor() - this.entities[i].getRadius(), this.entities[i].getRadius() * 2, this.entities[i].getRadius() * 2);
                    graphics.drawLine(this.entities[i].xcor(), this.entities[i].ycor(), this.entities[i].xcor(), this.entities[i].ycor());
                    continue;
                }
                if (this.entities[i] instanceof Rocket) {
                    graphics.setColor(Color.black);
                    graphics.drawOval(this.entities[i].xcor() - this.entities[i].getRadius(), this.entities[i].ycor() - this.entities[i].getRadius(), this.entities[i].getRadius() * 2, this.entities[i].getRadius() * 2);
                    continue;
                }
                graphics.setColor(Color.blue);
                graphics.drawOval(this.entities[i].xcor() - this.entities[i].getRadius(), this.entities[i].ycor() - this.entities[i].getRadius(), this.entities[i].getRadius() * 2, this.entities[i].getRadius() * 2);
            }
        }
    }

    public void observe() {
        this.checkMail();
        if (this.show) {
            if (this.swing) {
                this.onScreen.repaint();
            } else {
                ((AwtGridCanvas)this.onScreen).display();
            }
        }
    }
}

