/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.AWTEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import madkit.kernel.AGRTrio;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AbstractMadkitBooter;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.ConnectionMessage;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelAgent;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.MessageException;
import madkit.kernel.Mirror;
import madkit.kernel.Mobile;
import madkit.kernel.NetworkRequest;
import madkit.kernel.Organization;
import madkit.kernel.PrivateMessage;
import madkit.kernel.StringMessage;
import madkit.kernel.SynchroMessage;
import madkit.kernel.siteAgentGUI;

final class SiteAgent
extends Agent {
    public static final String PUBLIC = "public";
    public static final String COMMUNITIES = "communities";
    public static final String SITE = "site";
    private AgentAddress myCommunicator = null;
    private Map organizations;
    private Organization communities;
    private KernelAgent kernelAgent;
    private Collection distantKernels;
    private siteAgentGUI gui;

    SiteAgent(Map map, KernelAgent kernelAgent) {
        this.organizations = map;
        this.communities = (Organization)map.get(COMMUNITIES);
        this.kernelAgent = kernelAgent;
        this.distantKernels = new HashSet();
    }

    public void initGUI() {
        this.gui = new siteAgentGUI(this);
        this.setGUIObject(this.gui);
    }

    public final void activate() {
        this.createCommunity(PUBLIC);
        this.createGroup(false, "communications", null, null);
        this.createGroup(false, "system", null, null);
        this.requestRole("system", SITE, null);
        this.requestRole("communications", SITE, null);
        this.kernelAgent.localOrg = (Organization)this.organizations.get(PUBLIC);
        this.getCurrentKernel().launchAgent(this.kernelAgent, "KernelAgent", this.getCurrentKernel(), false);
        this.setName("SITE:" + this.getAddress().getKernel().getHost());
    }

    public final void live() {
        try {
            while (true) {
                Message message;
                if ((message = this.waitNextMessage()) instanceof SynchroMessage) {
                    this.handleSynchroMessage((SynchroMessage)message);
                    continue;
                }
                if (message instanceof ConnectionMessage) {
                    this.handleConnectionMessage((ConnectionMessage)message);
                    continue;
                }
                if (message instanceof NetworkRequest) {
                    this.handleNetworkRequest((NetworkRequest)message);
                    continue;
                }
                if (message instanceof StringMessage) {
                    this.handleMessage((StringMessage)message);
                    continue;
                }
                this.debug("receive an unknown message type :" + message);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in SiteAgent: " + exception);
            return;
        }
    }

    protected void handleMessage(StringMessage stringMessage) {
        String string = stringMessage.getString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("$url")) {
            AbstractAgent abstractAgent;
            string2 = stringTokenizer.nextToken();
            AgentAddress agentAddress = this.getAgentWithRole("system", "browser");
            if (agentAddress == null && (agentAddress = (abstractAgent = AbstractMadkitBooter.getBooter().makeJavaAgent(this, "agents.system.WebBrowserAgent", true)).getAddress()) == null) {
                System.err.println("Error: cannot create WebBrowserAgent upon reception of a $url request");
            }
            this.sendMessage(agentAddress, new StringMessage("$goto " + string2));
        } else if (string2.equalsIgnoreCase("$message")) {
            try {
                AbstractAgent abstractAgent;
                String string3 = string.substring("$message".length() + 1, string.length());
                AgentAddress agentAddress = this.getAgentWithRole("system", "pager");
                if (agentAddress == null && (agentAddress = (abstractAgent = AbstractMadkitBooter.getBooter().makeJavaAgent(this, "madkit.system.Pager", true)).getAddress()) == null) {
                    System.err.println("Error: cannot create a Pager upon reception of a $message request");
                }
                this.sendMessage(agentAddress, new StringMessage("$display Received a remote message from " + stringMessage.getSender() + ": \n" + string3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void end() {
        System.err.println("SITE AGENT KILLED !!!!!!!!!!!!!");
        System.err.println("UNSTABLE SYSTEM ....");
    }

    final void handleSynchroMessage(SynchroMessage synchroMessage) {
        if (this.connectedWith(synchroMessage.community)) {
            if (!this.organizations.containsKey(synchroMessage.community)) {
                this.kernelAgent.callHooks(11, synchroMessage.community);
                this.organizations.put(synchroMessage.community, new Organization());
            }
            Organization organization = (Organization)this.organizations.get(synchroMessage.community);
            switch (synchroMessage.code) {
                case 4: {
                    organization.createGroup(synchroMessage.initiator, true, synchroMessage.groupName, synchroMessage.newGroup.getDescription(), synchroMessage.newGroup.getGroupIdentifier());
                    this.kernelAgent.callHooks(4, new AGRTrio(synchroMessage.initiator, synchroMessage.community, synchroMessage.groupName, null));
                    break;
                }
                case 6: {
                    organization.requestRole(synchroMessage.initiator, synchroMessage.groupName, synchroMessage.roleName, synchroMessage.memberCard);
                    this.kernelAgent.callHooks(6, new AGRTrio(synchroMessage.initiator, synchroMessage.community, synchroMessage.groupName, synchroMessage.roleName));
                    break;
                }
                case 5: {
                    if (organization.leaveGroup(synchroMessage.initiator, synchroMessage.groupName)) {
                        this.removeCommunity(synchroMessage.community);
                    }
                    this.kernelAgent.callHooks(5, new AGRTrio(synchroMessage.initiator, synchroMessage.community, synchroMessage.groupName, null));
                    break;
                }
                case 11: {
                    this.establishConnectionWith(synchroMessage.getSender(), true);
                    break;
                }
                case 12: {
                    organization.removeAgentsFromKernel(synchroMessage.getSender().getKernel());
                    if (!organization.isEmpty()) break;
                    this.removeCommunity(synchroMessage.community);
                    this.kernelAgent.callHooks(12, synchroMessage.community);
                    break;
                }
                case 7: {
                    if (organization.leaveRole(synchroMessage.initiator, synchroMessage.groupName, synchroMessage.roleName)) {
                        this.removeCommunity(synchroMessage.community);
                    }
                    this.kernelAgent.callHooks(7, new AGRTrio(synchroMessage.initiator, synchroMessage.community, synchroMessage.groupName, synchroMessage.roleName));
                    break;
                }
                case 17: {
                    if (this.getDebug()) {
                        System.err.println("receiving a migration " + synchroMessage.ref.toString());
                    }
                    this.getCurrentKernel().receiveAgent(synchroMessage.ref);
                    System.gc();
                    System.runFinalization();
                }
            }
        } else {
            switch (synchroMessage.code) {
                case 11: {
                    this.kernelAgent.callHooks(11, synchroMessage.community);
                    System.err.println("new community detected");
                    if (this.gui == null) break;
                    this.gui.refreshCommunities();
                    break;
                }
                case 12: {
                    this.kernelAgent.callHooks(12, synchroMessage.community);
                    System.err.println("a community has been deleted ");
                    if (this.gui == null) break;
                    this.gui.refreshCommunities();
                }
            }
        }
    }

    final void handleConnectionMessage(ConnectionMessage connectionMessage) {
        if (connectionMessage.isTheFirstMessage()) {
            this.getCurrentKernel().synchronizeKernel(connectionMessage.getOrgs(), true);
            this.establishConnectionWith(connectionMessage.getSender(), false);
        } else {
            this.getCurrentKernel().synchronizeKernel(connectionMessage.getOrgs(), false);
        }
        if (this.distantKernels.add(connectionMessage.getSender())) {
            this.kernelAgent.callHooks(9, connectionMessage.getSender().getKernel());
            this.kernelAgent.callHooks(6, connectionMessage.getSender(), COMMUNITIES, PUBLIC, SITE);
        }
        System.gc();
        System.runFinalization();
    }

    final synchronized void handleNetworkRequest(NetworkRequest networkRequest) {
        switch (networkRequest.getRequestCode()) {
            case 7: {
                try {
                    Message message = (Message)networkRequest.getArgument();
                    this.getCurrentKernel().sendLocalMessage(message);
                    if (message instanceof PrivateMessage) break;
                    this.kernelAgent.callHooks(1, message.clone());
                }
                catch (MessageException messageException) {
                    if (!this.getDebug()) break;
                    System.err.println(messageException);
                }
                break;
            }
            case 3: {
                if (!networkRequest.getSender().equals(this.myCommunicator)) break;
                this.establishConnectionWith((AgentAddress)networkRequest.getArgument(), true);
                break;
            }
            case 4: {
                this.distantKernels.remove(networkRequest.getArgument());
                this.deconnection((String)networkRequest.getArgument());
                break;
            }
            case 1: {
                if (this.myCommunicator != null) break;
                this.redisplayMyGUI();
                this.myCommunicator = networkRequest.getSender();
                break;
            }
            case 2: {
                if (this.myCommunicator == null || !this.myCommunicator.equals(networkRequest.getSender())) break;
                this.disposeMyGUI();
                this.myCommunicator = null;
                Iterator iterator = this.organizations.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Organization organization = (Organization)entry.getValue();
                    if (!organization.removeDistantAgents()) continue;
                    this.leaveGroup(COMMUNITIES, (String)entry.getKey());
                    iterator.remove();
                }
                this.distantKernels.clear();
                System.gc();
                System.runFinalization();
                break;
            }
            case 5: {
                KernelAddress[] kernelAddressArray = new KernelAddress[this.distantKernels.size()];
                int n = 0;
                Iterator iterator = this.distantKernels.iterator();
                while (iterator.hasNext()) {
                    kernelAddressArray[n] = ((AgentAddress)iterator.next()).getKernel();
                    ++n;
                }
                this.sendMessage(networkRequest.getSender(), new NetworkRequest(5, kernelAddressArray));
                break;
            }
            case 6: {
                if (this.getDebug()) {
                    this.println("receiving a migration request of " + networkRequest.getSender());
                }
                this.tryMigration((KernelAddress)networkRequest.getArgument(), networkRequest.getSender());
            }
        }
    }

    final synchronized void establishConnectionWith(AgentAddress agentAddress, boolean bl) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.organizations.entrySet()) {
            if (!this.connectedWith((String)entry.getKey())) continue;
            Organization organization = ((Organization)entry.getValue()).exportOrg();
            hashMap.put(entry.getKey(), organization);
        }
        this.sendMessage(agentAddress, new ConnectionMessage(hashMap, bl));
        System.err.println("sending connection message");
    }

    final synchronized void deconnection(String string) {
        Iterator iterator = this.distantKernels.iterator();
        while (iterator.hasNext()) {
            AgentAddress agentAddress = (AgentAddress)iterator.next();
            if (!agentAddress.getKernel().getID().equals(string)) continue;
            this.debug("disconnected from " + string);
            Iterator iterator2 = this.organizations.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                Organization organization = (Organization)entry.getValue();
                if (!organization.removeAgentsFromKernel(agentAddress.getKernel())) continue;
                this.leaveGroup(COMMUNITIES, (String)entry.getKey());
                this.sendAll(new SynchroMessage(5, this.getAddress(), COMMUNITIES, (String)entry.getKey(), null, null));
                this.sendAll(new SynchroMessage(12, (String)entry.getKey()));
                iterator2.remove();
            }
            this.kernelAgent.callHooks(10, agentAddress.getKernel());
            this.kernelAgent.callHooks(7, agentAddress, COMMUNITIES, PUBLIC, SITE);
            iterator.remove();
            System.gc();
            System.runFinalization();
            break;
        }
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    final synchronized void updateDistantOrgs(AgentAddress agentAddress, String string, String string2) {
        AgentAddress[] agentAddressArray = this.communities.getRolePlayers(string, SITE);
        Organization organization = (Organization)this.organizations.get(string);
        for (int i = 0; i < agentAddressArray.length; ++i) {
            if (agentAddressArray[i].equals(this.getAddress())) continue;
            SynchroMessage synchroMessage = new SynchroMessage(agentAddress, string, organization.getGroup(string2), string2);
            synchroMessage.setSender(this.getAddress());
            synchroMessage.setReceiver(agentAddressArray[i]);
            this.sendDistantMessage(synchroMessage);
        }
    }

    final synchronized void updateDistantOrgs(int n, AgentAddress agentAddress, String string, String string2, String string3, Object object) {
        AgentAddress[] agentAddressArray = this.communities.getRolePlayers(string, SITE);
        for (int i = 0; i < agentAddressArray.length; ++i) {
            if (agentAddressArray[i].equals(this.getAddress())) continue;
            SynchroMessage synchroMessage = new SynchroMessage(n, agentAddress, string, string2, string3, object);
            synchroMessage.setSender(this.getAddress());
            synchroMessage.setReceiver(agentAddressArray[i]);
            this.sendDistantMessage(synchroMessage);
        }
    }

    final synchronized void tryMigration(KernelAddress kernelAddress, AgentAddress agentAddress) {
        AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
        SynchroMessage synchroMessage = new SynchroMessage(abstractAgent);
        for (Object object : this.distantKernels) {
            if (!((AgentAddress)object).getKernel().equals(kernelAddress)) continue;
            synchroMessage.setReceiver((AgentAddress)object);
            break;
        }
        if (synchroMessage.getReceiver() != null && abstractAgent != null && abstractAgent instanceof Mobile) {
            ((Agent)abstractAgent).getAgentThread().stop();
            if (Kernel.getAddress().equals(((Mobile)((Object)abstractAgent)).getMyAgency())) {
                Object object;
                AgentAddress agentAddress2 = ((Mobile)((Object)abstractAgent)).getMyBirthAddress();
                object = ((Agent)abstractAgent).getAddress().getName();
                Mirror mirror = ((Mobile)((Object)abstractAgent)).createMirror(kernelAddress);
                this.getCurrentKernel().removeAgentFromOrganizations(agentAddress);
                this.getCurrentKernel().removeReferenceOf(agentAddress);
                abstractAgent.setCurrentKernel(null);
                this.currentKernel.launchMirror(mirror, agentAddress2, "mirroAgentOf" + this.getName(), this.getCurrentKernel(), true);
                ((Mobile)((Object)abstractAgent)).createMirror(kernelAddress);
            } else {
                this.getCurrentKernel().removeAgentFromOrganizations(agentAddress);
                this.getCurrentKernel().removeReferenceOf(agentAddress);
                abstractAgent.setCurrentKernel(null);
            }
            synchroMessage.setSender(this.getAddress());
            this.sendDistantMessage(synchroMessage);
        }
    }

    final synchronized boolean sendDistantMessage(Message message) {
        if (this.myCommunicator != null) {
            KernelMessage kernelMessage = new KernelMessage(1, 1, message);
            kernelMessage.setSender(this.getAddress());
            kernelMessage.setReceiver(this.myCommunicator);
            try {
                this.getCurrentKernel().sendLocalMessage(kernelMessage);
            }
            catch (MessageException messageException) {
                if (this.getDebug()) {
                    System.err.println("Unable to send distant message !!" + messageException);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void sendAll(Message message) {
        message.setSender(this.getAddress());
        Iterator iterator = this.distantKernels.iterator();
        while (iterator.hasNext()) {
            Message message2 = (Message)message.clone();
            AgentAddress agentAddress = (AgentAddress)iterator.next();
            message2.setReceiver(agentAddress);
            this.sendDistantMessage(message2);
        }
    }

    synchronized void joinCommunity(String string) {
        if (!this.connectedWith(string)) {
            if (this.createGroup(true, COMMUNITIES, string, null, null) > 0) {
                this.sendAll(new SynchroMessage(this.getAddress(), COMMUNITIES, this.communities.getGroup(string), string));
            }
            this.requestRole(COMMUNITIES, string, SITE, null);
            this.sendAll(new SynchroMessage(6, this.getAddress(), COMMUNITIES, string, SITE, null));
            this.sendAll(new SynchroMessage(11, string));
        }
    }

    synchronized void leaveCommunity(String string) {
        Organization organization = (Organization)this.organizations.get(string);
        organization.removeDistantAgents();
        if (organization.isEmpty()) {
            this.leaveGroup(COMMUNITIES, string);
            this.sendAll(new SynchroMessage(5, this.getAddress(), COMMUNITIES, string, null, null));
            this.organizations.remove(string);
            this.kernelAgent.callHooks(12, string);
        } else {
            this.leaveRole(COMMUNITIES, string, SITE);
            this.sendAll(new SynchroMessage(7, this.getAddress(), COMMUNITIES, string, SITE, null));
            this.sendAll(new SynchroMessage(12, string));
        }
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    synchronized void removeCommunity(String string) {
        System.err.println("removing community : " + string);
        this.organizations.remove(string);
        this.kernelAgent.callHooks(12, string);
        this.leaveGroup(COMMUNITIES, string);
        this.sendAll(new SynchroMessage(5, this.getAddress(), COMMUNITIES, string, null, null));
        this.sendAll(new SynchroMessage(12, string));
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    synchronized boolean connectedWith(String string) {
        return string.equals(COMMUNITIES) || this.communities.isPlayingRole(this.getAddress(), string, SITE);
    }

    synchronized Organization createCommunity(String string) {
        if (!this.organizations.containsKey(string)) {
            Organization organization = new Organization();
            this.organizations.put(string, organization);
            this.createGroup(true, COMMUNITIES, string, null, null);
            this.requestRole(COMMUNITIES, string, SITE, null);
            this.sendAll(new SynchroMessage(this.getAddress(), COMMUNITIES, this.communities.getGroup(string), string));
            this.sendAll(new SynchroMessage(6, this.getAddress(), COMMUNITIES, string, SITE, null));
            this.sendAll(new SynchroMessage(11, string));
            this.kernelAgent.callHooks(11, string);
            if (this.hasGUI()) {
                this.gui.refreshCommunities();
            }
            return organization;
        }
        return null;
    }

    synchronized void refreshCommunities() {
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    synchronized String[] getCommunities() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.communities.getGroups();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.communities.isPlayingRole(this.getAddress(), stringArray[i], "member") && this.communities.getRolePlayer(stringArray[i], SITE) == null) continue;
            hashSet.add(stringArray[i]);
        }
        return hashSet.toArray(new String[0]);
    }

    public void windowClosing(AWTEvent aWTEvent) {
    }
}

