/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import madkit.kernel.InvalidAddressException;
import madkit.kernel.Kernel;

public class KernelAddress
implements Serializable {
    private String host;
    private String ID = "0";
    private String kernelName = "";
    private boolean supportMobility = false;

    public KernelAddress(boolean bl) {
        this.ID = "K" + new Date().getTime();
        try {
            this.host = bl ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "localKernel";
        }
    }

    public KernelAddress(boolean bl, String string) {
        this.ID = "K" + new Date().getTime();
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                if (string.compareTo(inetAddressArray[i].getHostAddress()) != 0) continue;
                this.host = string;
                return;
            }
            this.host = bl ? InetAddress.getLocalHost().getHostAddress() : string2;
        }
        catch (Exception exception) {
            this.host = "localKernel";
        }
    }

    public KernelAddress(String string) throws InvalidAddressException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        try {
            if (stringTokenizer.countTokens() != 2) {
                throw new InvalidAddressException("Invalid count on KernelAddress:" + string + stringTokenizer.countTokens());
            }
            this.host = stringTokenizer.nextToken();
            this.ID = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidAddressException("Invalid element on KernelAddress !" + string + stringTokenizer);
        }
    }

    public boolean isLocal() {
        return this.equals(Kernel.getAddress());
    }

    public boolean equals(Object object) {
        if (object instanceof KernelAddress) {
            KernelAddress kernelAddress = (KernelAddress)object;
            if (kernelAddress != null) {
                return this.toString().equals(kernelAddress.toString());
            }
            return false;
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public String getID() {
        return this.ID;
    }

    public String toString() {
        return this.host + ":" + this.ID;
    }

    public String getInformation() {
        if (!this.supportMobility) {
            return this.host + ":" + this.ID;
        }
        return "Agency Name=" + this.kernelName + "\t:" + this.host + ":" + this.ID;
    }

    public String shortString() {
        return this.host + ":" + this.ID.substring(10);
    }

    public void setKernelName(String string) {
        this.kernelName = string;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public void enableMobility() {
        this.supportMobility = true;
    }

    public void disableMobility() {
        this.supportMobility = false;
    }

    public boolean supportMobility() {
        return this.supportMobility;
    }
}

