/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilderFactory;
import madkit.boot.Madkit;
import madkit.boot.MadkitClassLoader;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentLauncher;
import madkit.kernel.AgentWindowHandler;
import madkit.kernel.GraphicShell;
import madkit.kernel.Kernel;
import madkit.kernel.OPanel;
import madkit.kernel.SplashScreen;
import madkit.kernel.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AbstractMadkitBooter
implements GraphicShell {
    protected static int port;
    protected static boolean graphics;
    protected static boolean ipnumeric;
    protected static boolean nativelf;
    protected static String initFile;
    protected static String ipaddress;
    protected static boolean network;
    public static String CONFIG_FILE;
    public static String SCHEME_FILE;
    public static String PYTHON_FILE;
    public static String BEANSHELL_FILE;
    public static String JESS_FILE;
    public static String SEDIT_FILE;
    public static String FORMALISM_FILE;
    public static String ALL_FILES;
    static AbstractMadkitBooter booterInstance;
    protected Kernel theKernel;
    protected boolean isGraphics = false;
    protected Hashtable guis;
    protected String initialAgentClass = null;
    protected String initialAgentName = null;
    private SplashScreen starter;
    protected boolean allowForPluginAgentification = true;
    public static Hashtable labeltable;

    public static void setBooter(AbstractMadkitBooter abstractMadkitBooter) {
        booterInstance = abstractMadkitBooter;
    }

    public static AbstractMadkitBooter getBooter() {
        return booterInstance;
    }

    protected void setSplashScreen(SplashScreen splashScreen) {
        this.starter = splashScreen;
    }

    protected SplashScreen getSplashScreen() {
        return this.starter;
    }

    public void setProgress(String string) {
        if (this.starter != null) {
            this.starter.setText(string);
        }
    }

    public static String getAgentLabel(String string) {
        if (!labeltable.containsKey(string)) {
            labeltable.put(string, new Integer(2));
            return string;
        }
        int n = (Integer)labeltable.get(string);
        String string2 = string + "-" + n++;
        labeltable.put(string, new Integer(n));
        return string2;
    }

    public static String getAgentLabelFromClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return AbstractMadkitBooter.getAgentLabel(string.substring(n + 1));
        }
        return AbstractMadkitBooter.getAgentLabel(string);
    }

    public AbstractAgent makeScriptAgent(AbstractAgent abstractAgent, String string, String string2, Object object, boolean bl) {
        Object object2;
        Object object3 = null;
        try {
            object2 = null;
            object2 = Utils.loadClass(string);
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = Utils.loadClass(string2);
            objectArray[0] = object;
            Constructor constructor = ((Class)object2).getConstructor(classArray);
            object3 = constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Agent class does not exist: " + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Agent launch exception:\n");
            exception.printStackTrace();
        }
        if (object3 != null && object3 instanceof AbstractAgent) {
            object2 = AbstractMadkitBooter.getAgentLabelFromClassName(object3.getClass().getName());
            abstractAgent.launchAgent((AbstractAgent)object3, (String)object2, bl);
            return (AbstractAgent)object3;
        }
        return null;
    }

    public AbstractAgent makeJavaAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        AbstractAgent abstractAgent2 = null;
        try {
            MadkitClassLoader madkitClassLoader = Madkit.getClassLoader();
            Class clazz = null;
            clazz = Utils.loadClass(string);
            abstractAgent2 = (AbstractAgent)clazz.newInstance();
            if (abstractAgent2 != null && abstractAgent2 instanceof AbstractAgent) {
                String string2 = AbstractMadkitBooter.getAgentLabelFromClassName(abstractAgent2.getClass().getName());
                abstractAgent.launchAgent(abstractAgent2, string2, bl);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Agent class does not exist" + classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Agent launch exception:" + exception);
            exception.printStackTrace();
        }
        return abstractAgent2;
    }

    protected AbstractMadkitBooter(boolean bl, boolean bl2, String string, String string2, boolean bl3) {
        this.init(bl, bl2, string, string2, bl3);
    }

    void createPluginAgents() {
        Class clazz = null;
        try {
            clazz = Madkit.getClassLoader().loadClass("madkit.system.PluginAgent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Warning: no agent plugins");
            return;
        }
        File file = new File(System.getProperty("madkit.dir") + File.separator + "plugins");
        if (file != null && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                try {
                    Agent agent = (Agent)clazz.newInstance();
                    Class[] classArray = new Class[]{Class.forName("java.io.File")};
                    Method method = agent.getClass().getMethod("init", classArray);
                    Method method2 = agent.getClass().getMethod("getPluginName", new Class[0]);
                    if (method == null) continue;
                    method.invoke((Object)agent, fileArray[i]);
                    this.launchAgent(agent, "plugin-" + method2.invoke((Object)agent, new Object[0]), false, null, null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void init(boolean bl, boolean bl2, String string, String string2, boolean bl3) {
        GenericDeclaration genericDeclaration;
        Serializable serializable;
        AbstractMadkitBooter.setBooter(this);
        this.setProgress("Starting micro-kernel...");
        this.isGraphics = bl;
        this.theKernel = string2 == null ? new Kernel("Kernel", bl2) : new Kernel("Kernel", true, string2);
        if (this.isGraphics) {
            this.guis = new Hashtable();
            this.theKernel.registerGUI(this);
        }
        this.setProgress("Initializing main class");
        if (this.initialAgentClass != null) {
            this.launchAgent(this.initialAgentClass, this.initialAgentName);
        }
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            System.err.println("can't make a pause " + exception);
        }
        if (this.allowForPluginAgentification) {
            this.createPluginAgents();
        }
        if (string != null) {
            this.loadConfigFile(new File(string));
        }
        try {
            serializable = Utils.loadClass("madkit.python.PythonController");
            if (serializable != null && (serializable = Utils.loadClass("org.python.core.PySystemState")) != null) {
                this.setProgress("initializing Python.. It can take a minute the first time");
                genericDeclaration = serializable.getMethod("initialize", new Class[0]);
                ((Method)genericDeclaration).invoke(serializable, new Object[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            System.out.println("Error in initializing Python: " + exception.getMessage());
        }
        if (bl3) {
            this.setProgress("initializing network...");
            serializable = null;
            try {
                genericDeclaration = Madkit.getClassLoader().loadClass("madkit.communicator.DynamicTwoChannelsCommunicator");
                serializable = (Agent)((Class)genericDeclaration).newInstance();
            }
            catch (Exception exception) {
                System.err.println("ERROR: Communicator agent not found");
                return;
            }
            this.theKernel.launchAgent((AbstractAgent)serializable, "Communicator " + Kernel.getAddress(), this, graphics);
        }
    }

    public Object getDefaultGUIObject(AbstractAgent abstractAgent) {
        OPanel oPanel = new OPanel();
        abstractAgent.setGUIObject(oPanel);
        abstractAgent.setOutputWriter(oPanel.getOut());
        return oPanel;
    }

    public void setupGUI(AbstractAgent abstractAgent) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setupGUI(abstractAgent, new Point(-1, -1), new Dimension(-1, -1));
    }

    public void setupGUI(AbstractAgent abstractAgent, Point point, Dimension dimension) {
        JFrame jFrame = new JFrame(abstractAgent.getName());
        abstractAgent.initGUI();
        if (point == null) {
            point = new Point(-1, -1);
        }
        if (dimension == null) {
            dimension = new Dimension(-1, -1);
        }
        if (abstractAgent.getGUIObject() != null) {
            jFrame.getContentPane().add("Center", (Component)abstractAgent.getGUIObject());
        }
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(this.createWindowHandler(this.theKernel, abstractAgent));
        if (dimension.width < 0 || dimension.height < 0) {
            jFrame.pack();
        } else {
            jFrame.setSize(dimension);
        }
        if (point.x < 0 || point.y < 0) {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setLocation((int)((double)(dimension2.width / 2) - jFrame.getSize().getWidth() / 2.0 + (double)((int)(Math.random() * 500.0)) - 250.0), (int)((double)(dimension2.height / 2) - jFrame.getSize().getHeight() / 2.0) + (int)(Math.random() * 500.0) - 250);
        } else {
            jFrame.setLocation(point.x, point.y);
        }
        jFrame.show();
        this.guis.put(abstractAgent, jFrame);
    }

    protected WindowListener createWindowHandler(Kernel kernel, AbstractAgent abstractAgent) {
        return new AgentWindowHandler(kernel, this, abstractAgent);
    }

    public void disposeGUI(AbstractAgent abstractAgent) {
        Object v = this.guis.get(abstractAgent);
        if (v != null && v instanceof Frame) {
            ((Frame)v).dispose();
            this.guis.remove(abstractAgent);
        }
    }

    public void disposeGUIImmediatly(AbstractAgent abstractAgent) {
        this.disposeGUI(abstractAgent);
    }

    void launchAgent(AbstractAgent abstractAgent, String string) {
        this.theKernel.launchAgent(abstractAgent, string, this, graphics);
    }

    void launchAgent(AbstractAgent abstractAgent, String string, boolean bl, Point point, Dimension dimension) {
        if (point == null) {
            point = new Point(-1, -1);
        }
        if (dimension == null) {
            dimension = new Dimension(-1, -1);
        }
        this.theKernel.launchAgent(abstractAgent, string, this, bl, point, dimension);
    }

    void launchAgent(String string, String string2) {
        try {
            Class clazz = Madkit.getClassLoader().loadClass(string);
            AbstractAgent abstractAgent = null;
            abstractAgent = (AbstractAgent)clazz.newInstance();
            this.launchAgent(abstractAgent, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Agent class does not exist");
        }
        catch (Exception exception) {
            System.err.println("Agent launch exception:" + exception);
            exception.printStackTrace();
        }
    }

    public void launchAgent(Element element) {
        AgentLauncher agentLauncher = null;
        boolean bl = true;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String string = element.getAttribute("gui");
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                bl = true;
            } else if (string.equalsIgnoreCase("false")) {
                bl = false;
            }
        }
        String string2 = element.getAttribute("X");
        String string3 = element.getAttribute("Y");
        String string4 = element.getAttribute("height");
        String string5 = element.getAttribute("width");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n3 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n4 = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Point point = new Point(n, n2);
        Dimension dimension = new Dimension(n4, n3);
        if (element.getAttribute("type").equalsIgnoreCase("Java")) {
            agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.JavaAgentLauncher", this, null, element.getAttribute("code"), element.getAttribute("name"), null, null, bl, point, dimension);
        } else if (element.getAttribute("type").equalsIgnoreCase("Scheme")) {
            agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "SchemeAgent", "madkit.scheme.SchemeAgent", element.getAttribute("name"), "java.io.File", new File(element.getAttribute("code")), bl, point, dimension);
        } else if (element.getAttribute("type").equalsIgnoreCase("Jess")) {
            agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "JessAgent", "madkit.jess.JessAgent", element.getAttribute("name"), "java.lang.String", element.getAttribute("code"), bl, point, dimension);
        } else if (element.getAttribute("type").equalsIgnoreCase("Python")) {
            agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "PythonAgent", "madkit.python.PythonAgent", element.getAttribute("name"), "java.lang.String", element.getAttribute("code"), bl, point, dimension);
        } else if (element.getAttribute("type").equalsIgnoreCase("BeanShell")) {
            agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "BeanShellAgent", "madkit.bsh.BeanShellAgent", element.getAttribute("name"), "java.lang.String", element.getAttribute("code"), bl, point, dimension);
        } else if (element.getAttribute("type").equalsIgnoreCase("SEdit")) {
            agentLauncher = AgentLauncher.makeAgentLauncher("SEdit.SEditFileAgentLauncher", this, "BeanShellAgent", "madkit.bsh.BeanShellAgent", element.getAttribute("name"), "java.lang.String", element.getAttribute("code"), bl, point, dimension);
        }
        agentLauncher.launch();
    }

    public void loadConfigFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("launch-agent");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.launchAgent(element2);
            }
        }
        catch (IOException iOException) {
            System.err.println("File read error with !\n" + file.getName());
        }
        catch (SAXException sAXException) {
            System.err.println("Parsing error of the file !\n" + file.getName());
        }
        catch (Exception exception) {
            System.err.println("XML problem !\n" + file.getName());
        }
    }

    public void loadFile(AbstractAgent abstractAgent, File file) {
        String string = file.getPath();
        System.out.println("loading file " + file);
        if (string.endsWith("." + CONFIG_FILE)) {
            this.loadConfigFile(file);
        } else if (string.endsWith("." + PYTHON_FILE)) {
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "PythonAgent", "madkit.python.PythonAgent", null, "java.lang.String", string, true, null, null);
            agentLauncher.launch();
        } else if (string.endsWith("." + BEANSHELL_FILE)) {
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "BeanShellAgent", "madkit.bsh.BeanShellAgent", null, "java.lang.String", string, true, null, null);
            agentLauncher.launch();
        } else if (string.endsWith("." + SCHEME_FILE)) {
            System.out.println("OK1");
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "SchemeAgent", "madkit.scheme.SchemeAgent", null, "java.io.File", file, true, null, null);
            agentLauncher.launch();
        } else if (string.endsWith("." + JESS_FILE)) {
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher("madkit.kernel.ScriptAgentLauncher", this, "JessAgent", "madkit.jess.JessAgent", null, "java.lang.String", string, true, null, null);
            agentLauncher.launch();
        } else if (string.endsWith("." + FORMALISM_FILE)) {
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher("SEdit.FormalismFileLauncher", this, null, null, null, "java.io.File", file, true, null, null);
            agentLauncher.setAgent(abstractAgent);
            agentLauncher.launch();
        } else if (string.endsWith("." + SEDIT_FILE)) {
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher("SEdit.SEditFileLauncher", this, null, null, null, "java.io.File", file, true, null, null);
            agentLauncher.setAgent(abstractAgent);
            agentLauncher.launch();
        }
    }

    static void handleArgs(String[] stringArray) {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("--version")) {
                    System.out.println("MadKit/Aalaadin - O. Gutknecht, J. Ferber, F. Michel");
                    System.out.println("  microKernel version: 4.2.0 b1 - China town");
                    System.exit(0);
                }
                if (stringArray[i].equals("--graphics")) {
                    graphics = true;
                }
                if (stringArray[i].equals("--ip-numeric")) {
                    ipnumeric = true;
                }
                if (stringArray[i].equals("--config")) {
                    initFile = stringArray[++i];
                }
                if (stringArray[i].equals("--with-native-lf")) {
                    nativelf = true;
                }
                if (stringArray[i].equals("--communicator-on")) {
                    network = true;
                }
                ipaddress = null;
                if (stringArray[i].equals("--with-java-lf")) {
                    nativelf = false;
                }
                if (stringArray[i].equals("--no-interGroup-Messages")) {
                    Kernel.interGroupMessage = false;
                }
                if (stringArray[i].equals("--fastSynchonous")) {
                    Kernel.fastSynchronous = true;
                }
                if (!stringArray[i].equals("--ip-numeric")) continue;
                ipnumeric = true;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[++i], ".", false);
                try {
                    if (stringTokenizer.countTokens() == 4) {
                        int n;
                        int n2;
                        for (n2 = 0; n2 < 4 && (n = Integer.decode(stringTokenizer.nextToken()).intValue()) >= 0 && n <= 256; ++n2) {
                        }
                        if (n2 == 4) {
                            ipaddress = stringArray[i];
                        }
                    }
                    if (ipaddress != null) continue;
                    System.err.println("Invalid IP address sent as parameter");
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Invalid IP address sent as parameter");
                }
            }
        }
    }

    public static void bootProcess(String[] stringArray) {
        AbstractMadkitBooter.handleArgs(stringArray);
        try {
            if (graphics) {
                Class clazz = Utils.loadClass("javax.swing.UIManager");
                Class[] classArray = new Class[]{};
                Class[] classArray2 = new Class[1];
                Object[] objectArray = new Object[]{};
                Object[] objectArray2 = new Object[1];
                classArray2[0] = Class.forName("java.lang.String");
                Method method = clazz.getMethod("setLookAndFeel", classArray2);
                Method method2 = nativelf ? clazz.getMethod("getSystemLookAndFeelClassName", classArray) : clazz.getMethod("getCrossPlatformLookAndFeelClassName", classArray);
                objectArray2[0] = method2.invoke(null, objectArray);
                method.invoke(null, objectArray2);
            }
        }
        catch (Exception exception) {
            System.err.println("Swing Look&feel exception:" + exception);
        }
    }

    static {
        graphics = false;
        ipnumeric = false;
        nativelf = true;
        initFile = null;
        ipaddress = null;
        network = false;
        CONFIG_FILE = "cfg";
        SCHEME_FILE = "scm";
        PYTHON_FILE = "py";
        BEANSHELL_FILE = "bsh";
        JESS_FILE = "clp";
        SEDIT_FILE = "sed";
        FORMALISM_FILE = "fml";
        ALL_FILES = "cfg,scm,py,bsh,clp,sed,fml";
        booterInstance = null;
        labeltable = new Hashtable();
    }
}

