/*
 * Decompiled with CFR 0.152.
 */
package madkit.utils.graphics;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JTextField;

public class GUIReader
extends Reader
implements ActionListener {
    private Object tf;
    private String str = "";
    private int length;
    private int next = 0;
    private Writer out = null;
    boolean duplicateOnOutput = true;

    public boolean getDuplicateOnOutput() {
        return this.duplicateOnOutput;
    }

    public void setDuplicateOnOutput(boolean bl) {
        this.duplicateOnOutput = bl;
    }

    public GUIReader(TextField textField) {
        this.tf = textField;
        this.str = new String("");
        this.length = this.str.length();
        textField.addActionListener(this);
    }

    public GUIReader(JTextField jTextField) {
        this.tf = jTextField;
        this.str = new String("");
        this.length = this.str.length();
        jTextField.addActionListener(this);
    }

    public GUIReader(JTextField jTextField, Writer writer) {
        this(jTextField);
        this.out = writer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tf instanceof TextField) {
            this.str = new String(((TextField)this.tf).getText() + '\n');
            ((TextField)this.tf).setText("");
        }
        if (this.tf instanceof JTextField) {
            this.str = new String(((JTextField)this.tf).getText() + '\n');
            ((JTextField)this.tf).setText("");
        }
        this.length = this.str.length();
        if (!this.str.equals("") && this.out != null) {
            try {
                if (this.duplicateOnOutput && this.out != null) {
                    this.out.write(this.str);
                }
            }
            catch (IOException iOException) {
                System.err.println("GUIReader output exception: " + iOException);
            }
        }
        this.next = 0;
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (this.str.equals("")) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            return this.str.charAt(this.next++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (this.str.equals("") || this.next >= this.length) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            if (this.next >= this.length) {
                this.str = new String("");
                this.length = 0;
                this.next = 0;
                return -1;
            }
            int n3 = Math.min(this.length - this.next, n2);
            this.str.getChars(this.next, this.next + n3, cArray, n);
            this.next += n3;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                return 0L;
            }
            long l2 = Math.min((long)(this.length - this.next), l);
            this.next = (int)((long)this.next + l2);
            return l2;
        }
    }

    public boolean ready() {
        return !this.str.equals("") && this.next < this.length;
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.next = 0;
        }
    }

    public void close() {
        this.str = null;
    }
}

