/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm.rules;

import java.util.Collection;
import java.util.regex.Pattern;
import madkit.netcomm.KnownProtocols;
import madkit.netcomm.ProtocolInformationImpl;
import madkit.netcomm.Protocollnformation;

public final class Rule {
    public static final int ACCEPT = 0;
    public static final int REJECT = 1;
    public static final int REFUSE = 2;
    public static final String DOT = "\\u002E";
    private final Pattern pattern;
    private final int action;
    private final Object _argument;

    public Rule(String string, int n, Object object) {
        switch (n) {
            case 0: {
                if (object != null && !(object instanceof Collection)) {
                    throw new IllegalArgumentException("to Accept a connection arg must be either a collection of protocols to use or null to use the default protocol order");
                }
                if (object == null) {
                    object = new ProtocolInformationImpl();
                    break;
                }
                if (!(object instanceof Collection)) break;
                object = new ProtocolInformationImpl((Collection)object);
                break;
            }
            case 2: {
                if (object instanceof String && object != null) break;
                throw new IllegalArgumentException("A reason must ");
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action");
            }
        }
        this.action = n;
        this._argument = object;
        this.pattern = Pattern.compile(string);
    }

    public int getAction() {
        return this.action;
    }

    public boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    public String toString() {
        String string = "pattern : " + this.pattern.pattern();
        switch (this.action) {
            case 0: {
                string = string + " ACCEPT - Protocols : " + this.getProtocolInformation().getProtocols().toString();
                break;
            }
            case 1: {
                string = string + " REJECT";
                break;
            }
            case 2: {
                string = string + " REFUSE reason: " + this._argument;
                break;
            }
        }
        return string;
    }

    public boolean contains(String string) {
        if (this.action == 1 || this.action == 2) {
            return false;
        }
        if (this._argument == null) {
            return KnownProtocols.getProtocols().contains(string);
        }
        return ((Protocollnformation)this._argument).getProtocols().contains(string);
    }

    public Protocollnformation getProtocolInformation() {
        if (this.action == 1 || this.action == 2) {
            return new ProtocolInformationImpl((String)this._argument);
        }
        return (Protocollnformation)this._argument;
    }

    public Object getArgument() {
        return this._argument;
    }
}

