/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Communicator;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.NetworkRequest;
import madkit.kernel.StringMessage;
import madkit.netcomm.BroadCastClient;
import madkit.netcomm.BroadCaster;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetAgentGUI;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkIdentifier;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.RouterAgent;
import madkit.netcomm.SocketDynamicConnection;
import madkit.netcomm.SocketKernel;
import madkit.netcomm.StatsAgent;
import madkit.netcomm.TCPServerAgent;
import madkit.netcomm.UDPServerAgent;

public class NetAgent
extends MadkitNetworkAgent
implements Communicator {
    static final int DEFAULT_PORT = 4444;
    private SocketKernel socketInfo;
    private RouterAgent router;
    private TCPServerAgent tcpAgent;
    private UDPServerAgent udpAgent;
    private BroadCastClient broadcast;
    private StatsAgent stats;
    private boolean alive = true;
    private boolean autoBroadcast = false;
    private NetAgentGUI gui;
    private int port;

    public NetAgent() {
        this(4444);
    }

    public NetAgent(int n) {
        this.port = n;
        this.tcpAgent = new TCPServerAgent(this.port);
        this.socketInfo = this.tcpAgent.getSocketKernel();
        this.router = new RouterAgent(this.socketInfo);
    }

    public void live() {
        if (this.autoBroadcast) {
            this.pause(200);
            this.madkitBroadcast();
        }
        while (this.alive) {
            Message message = this.waitNextMessage();
            this.exitImmediatlyOnKill();
            if (!this.alive) {
                return;
            }
            if (message instanceof KernelMessage) {
                this.sendMessage(this.router.getAddress(), new NetworkMessage(7, (KernelMessage)message));
                continue;
            }
            if (message instanceof NetworkMessage) {
                this.handleNetworkMessage((NetworkMessage)message);
                continue;
            }
            if (message instanceof NetConfigMessage) {
                this.handleConfigMessage((NetConfigMessage)message);
                continue;
            }
            if (message instanceof StringMessage) {
                this.handlePersonalMessage((StringMessage)message);
                continue;
            }
            this.debug("unknown message type");
            this.debug(message.toString());
        }
    }

    public void activate() {
        this.debug("NetAgent Activated");
        if (this.hasGUI()) {
            this.gui.setStatus("Active");
        }
        this.requestRole("public", "networking", "netagent", null);
        this.myKernel = this.getAgentWithRole("communications", "site");
        this.sendMessage(this.myKernel, (Message)new NetworkRequest(1));
        this.launchAgent((AbstractAgent)this.tcpAgent, "TCPSocketAgent", false);
        this.launchAgent((AbstractAgent)this.router, "RouterAgent", false);
        this.udpAgent = new UDPServerAgent(this.port);
        this.launchAgent((AbstractAgent)this.udpAgent, "udpserveragent", false);
        this.broadcast = new BroadCastClient();
        this.launchAgent((AbstractAgent)this.broadcast, "broadcastclient", false);
        this.stats = new StatsAgent(NetConfigMessage.isEnableStat());
        SocketDynamicConnection socketDynamicConnection = new SocketDynamicConnection(this.socketInfo);
        this.launchAgent((AbstractAgent)socketDynamicConnection, "multipleSocketv1", false);
    }

    public void end() {
        super.end();
        this.sendMessage(this.myKernel, (Message)new NetworkRequest(2));
        this.killAgent((AbstractAgent)this.tcpAgent);
        this.killAgent((AbstractAgent)this.udpAgent);
        this.killAgent((AbstractAgent)this.router);
        this.killAgent((AbstractAgent)this.stats);
        this.broadcastMessage("public", "networking", "p2pagent", new NetworkMessage(9, null));
        this.alive = false;
        this.println("NetAgent Terminated");
        System.gc();
        this.disposeMyGUI();
    }

    public void initGUI() {
        this.createGroup(false, "public", "networking", "Kernel's Networking group", new NetworkIdentifier());
        this.gui = new NetAgentGUI(this, this.router);
        this.setGUIObject(this.gui);
    }

    public int getPort() {
        return this.socketInfo.getPort();
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
        switch (networkMessage.getType()) {
            case 2: {
                if (!this.hasGUI()) break;
                this.debug("Kernel_connected received from " + networkMessage.getSender());
                this.gui.kernelConnected(networkMessage);
                break;
            }
            case 3: {
                this.debug("KERNEL_DISCONNECTED received");
                if (this.hasGUI()) {
                    this.gui.kernelDisconnected(networkMessage);
                }
                this.sendMessage(this.myKernel, (Message)new NetworkRequest(4, (Object)((KernelAddress)networkMessage.getArgument()).getID()));
                break;
            }
            case 11: {
                if (!this.hasGUI()) break;
                this.gui.updateKernel(networkMessage);
                break;
            }
            case 5: {
                Object object = networkMessage.getArgument();
                if (!(object instanceof NetworkRequest)) break;
                NetworkRequest networkRequest = (NetworkRequest)object;
                this.sendMessage(this.myKernel, (Message)new NetworkRequest(networkRequest.getRequestCode(), networkRequest.getArgument()));
                break;
            }
            default: {
                this.debug("Unknown NetworkMessageType");
                this.debug(networkMessage.toString());
            }
        }
    }

    protected void handleConfigMessage(NetConfigMessage netConfigMessage) {
    }

    protected void handlePersonalMessage(StringMessage stringMessage) {
        this.debug("Communicator: personal message: " + stringMessage);
        StringTokenizer stringTokenizer = new StringTokenizer(stringMessage.getString(), " :");
        String string = "nop";
        String string2 = null;
        int n = 4444;
        String string3 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (string.equals("add-host")) {
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Communicator error: not a valid port number: " + n);
                    }
                }
                this.connectKernel(string2, n);
            } else {
                System.err.println("Communicator error: not a valid host to add: " + string2);
            }
        } else if (string.equals("get-port")) {
            this.sendMessage(stringMessage.getSender(), (Message)new StringMessage("reply port=" + this.getPort()));
        }
    }

    void disconnectKernel(AgentAddress agentAddress) {
        this.sendMessage(agentAddress, new NetworkMessage(4, null));
    }

    public void connectKernel(String string, int n) {
        this.debug("Trying to connect to " + string + ":" + n);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            Socket socket = new Socket(inetAddress, n);
            Vector<Object> vector = new Vector<Object>();
            vector.add(socket);
            vector.add(null);
            vector.add(new SocketKernel(inetAddress.getHostName(), n));
            this.sendMessage(this.router.getAddress(), new NetworkMessage(8, vector));
        }
        catch (UnknownHostException unknownHostException) {
            this.debug("UnknownHostException caught " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
    }

    public void connectAgency(String string, String string2, int n) {
        this.println("Trying to connect Agency to host " + string2 + ":" + n);
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            Vector<Object> vector = new Vector<Object>();
            try {
                Socket socket = new Socket(inetAddress, n);
                vector.add(socket);
                vector.add(null);
                vector.add(new SocketKernel(inetAddress.getHostName(), n));
                this.sendMessage(this.router.getAddress(), new NetworkMessage(8, vector));
            }
            catch (Exception exception) {
                this.println("Connexion with distant agency couldn't be establish" + exception.getMessage());
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.println("Errrror " + unknownHostException.toString());
            this.debug("UnknownHostException caught " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            this.println("Errrror " + iOException.toString());
            this.debug("IOException caught " + iOException.getMessage());
        }
    }

    public boolean madkitBroadcast() {
        try {
            this.println("Broadcasting New Madkit Kernel");
            BroadCaster.broadcast(this.myKernel.getKernel().getID(), this.socketInfo.getHost(), this.socketInfo.getPort());
            return true;
        }
        catch (IOException iOException) {
            this.println("Exception during broadcast");
            this.debug("IOException caught " + iOException.getMessage());
            return false;
        }
    }

    public boolean isAutoBroadcast() {
        return this.autoBroadcast;
    }

    public void setAutoBroadcast(boolean bl) {
        this.autoBroadcast = bl;
    }

    void setStats(StatsAgent statsAgent) {
        this.stats = statsAgent;
    }

    void sendDebug(boolean bl) {
        this.setDebug(bl);
        NetConfigMessage.setDebug(bl);
        this.broadcastMessage("public", "networking", "member", new NetConfigMessage());
    }
}

