/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.InvalidAddressException;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.netcomm.SocketDynamicConnection;
import madkit.netcomm.SocketKernel;
import madkit.netcomm.UDPServerAgent;
import madkit.netcomm.handlers.SocketHandler;

final class DySocketConfigurator
implements Runnable {
    private SocketDynamicConnection agent;
    private Socket _socket;
    private HashSet _dkernels;
    private Thread myThread = null;
    private int _localPort;
    private KernelAddress _localKernel;
    private AgentAddress _kernel;
    private SocketKernel _socketKernel;
    protected DataOutputStream out = null;
    protected DataInputStream in = null;

    public DySocketConfigurator(SocketDynamicConnection socketDynamicConnection, int n, AgentAddress agentAddress, SocketKernel socketKernel, Socket socket, HashSet hashSet) {
        this.agent = socketDynamicConnection;
        this._socket = socket;
        this._dkernels = hashSet;
        this._localPort = n;
        this._localKernel = agentAddress.getKernel();
        this._socketKernel = socketKernel;
        this._kernel = agentAddress;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.myThread == thread) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("InterruptedException " + interruptedException.getMessage());
            }
            try {
                this.debug("Entering run");
                this.addConnectionHandler(this._socket, this._dkernels);
                this.debug("###Finish adding handler - closing socket");
                this.closeSocket(this._socket);
                this.stop();
            }
            catch (IOException iOException) {
                this.debug("IOException caught : " + iOException.toString());
                this.closeSocket(this._socket);
            }
            catch (InvalidAddressException invalidAddressException) {
                this.debug("InvalidAddressException caught : " + invalidAddressException.toString());
                this.closeSocket(this._socket);
            }
        }
    }

    private void closeSocket(Socket socket) {
        try {
            socket.close();
            this.stop();
        }
        catch (IOException iOException) {
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    private void debug(String string) {
        this.agent.debug("[DyConfigurator]  " + string);
    }

    protected void openInputOutputStreams(Socket socket) throws IOException {
        this.out = new DataOutputStream(socket.getOutputStream());
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
    }

    private int exchangeServerSocketPort() throws IOException {
        this.debug("entering exchangeServerSocketPort");
        this.debug("Writing :" + this._localPort);
        this.out.writeInt(this._localPort);
        this.out.flush();
        this.debug("Reading distant port ");
        int n = this.in.readInt();
        this.debug("Got from distant port :" + n);
        return n;
    }

    protected KernelAddress exchangeKernelInformation(Socket socket) throws IOException, InvalidAddressException {
        int n;
        String string = this._localKernel.getID();
        this.out.writeInt(string.length());
        this.out.writeChars(string);
        this.out.flush();
        this.out.writeInt(UDPServerAgent.getPort());
        this.out.flush();
        int n2 = this.in.readInt();
        string = "";
        for (n = 0; n < n2; ++n) {
            string = string + this.in.readChar();
        }
        n = this.in.readInt();
        KernelAddress kernelAddress = new KernelAddress(socket.getInetAddress().getHostName() + ":" + string.toString());
        this.debug("requesting kernel: " + kernelAddress);
        if (string.equals(this._localKernel.getID())) {
            this.debug("trying to add my own kernel");
            return null;
        }
        return kernelAddress;
    }

    protected void addConnectionHandler(Socket socket, HashSet hashSet) throws IOException, InvalidAddressException {
        this.debug("Entering addConnectionHandler");
        this.openInputOutputStreams(socket);
        this.ack();
        this.debug("ACK: OK1");
        int n = this.exchangeServerSocketPort();
        KernelAddress kernelAddress = this.exchangeKernelInformation(socket);
        if (kernelAddress == null) {
            this.closeSocket(this._socket);
            return;
        }
        SocketHandler socketHandler = new SocketHandler(this._localKernel, kernelAddress, socket.getInetAddress(), n, hashSet != null);
        if (this.agent == null) {
            this.debug("SocketAgent null!!!!!");
        }
        if (!this.agent.addConnectionHandler(kernelAddress.getID(), socketHandler)) {
            this.closeSocket(this._socket);
            this.stop();
            return;
        }
        this.ack();
        this.debug("ACK: OK2");
        this.debug("ACK: Information Received");
        if (hashSet != null) {
            socketHandler.sendObject(this.buildSynch('c', hashSet));
        }
        this.agent.sendMessage(this.agent.getAgentWithRole("system", "kernel"), (Message)new KernelMessage(14, 27));
    }

    private void ack() throws IOException {
        int n = -88;
        this.debug("sending: " + (char)n);
        this.out.writeInt(n);
        this.out.flush();
        int n2 = 0;
        this.debug("waiting for " + (char)n);
        while ((n2 = this.in.readInt()) != n) {
            this.debug("connection read: " + n2);
        }
        this.debug("Got the ack " + (char)n2);
    }

    private Vector buildSynch(char c, HashSet hashSet) {
        Vector<Object> vector = new Vector<Object>();
        if (c == 'c') {
            vector.addElement("TRANSMIT_SOCKET_INFO");
        } else if (c == 'r') {
            vector.addElement("ACK_SOCKET_INFO");
        }
        vector.addElement(this._localKernel);
        vector.addElement(this._socketKernel);
        vector.addElement(this._kernel);
        vector.addElement(hashSet);
        return vector;
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "DySocketConfigurator");
            this.myThread.start();
        }
    }

    public void stop() {
        this.myThread = null;
    }

    public boolean isRunning() {
        return this.myThread != null;
    }
}

