/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import madkit.TreeTools.GenericIconDescriptor;
import madkit.explorer.IconPanel;
import madkit.kernel.AbstractAgent;
import madkit.utils.graphics.GraphicUtils;

public class Icon
extends JPanel
implements MouseListener {
    GenericIconDescriptor desc;
    IconPanel iconPanel;
    String name;
    private int x_pos;
    private int y_pos;
    private int iconSize;
    private boolean selected;
    static Icon LastSelected = null;
    AbstractAgent ag;

    public Icon(AbstractAgent abstractAgent, GenericIconDescriptor genericIconDescriptor, String string, int n, IconPanel iconPanel) {
        this.desc = genericIconDescriptor;
        this.name = string;
        this.iconSize = n;
        this.selected = false;
        this.x_pos = 0;
        this.y_pos = 0;
        this.setBackground(Color.white);
        this.iconPanel = iconPanel;
        this.ag = abstractAgent;
        this.addMouseListener(this);
        this.setToolTipText(string);
    }

    protected void setDescriptor(GenericIconDescriptor genericIconDescriptor) {
        this.desc = genericIconDescriptor;
        this.desc.setArg((Object)this);
    }

    public void drawName(String string, Graphics graphics) {
        int n = graphics.getFontMetrics().stringWidth(string);
        if (n > this.iconSize) {
            if (this.selected) {
                graphics.fillRect((this.iconSize - n - 2) / 2, this.iconSize / 2 + 2, n + 2, 14);
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawString(string.substring(0, this.iconSize / 6 - 1) + "..", 3, this.iconSize / 2 + 12);
        } else {
            if (this.selected) {
                graphics.fillRect((this.iconSize - n - 2) / 2, this.iconSize / 2 + 2, n + 2, 14);
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawString(string, (this.iconSize - n) / 2, this.iconSize / 2 + 12);
        }
    }

    protected Image getImage() {
        return this.desc.getImage().getImage();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.iconSize / 3;
        Image image = this.getImage();
        graphics.drawImage(image, (this.iconSize - n) / 2, n / 2, n, n, this);
        this.drawName(this.name, graphics);
    }

    public String getName() {
        return this.name;
    }

    public GenericIconDescriptor getDescriptor() {
        return this.desc;
    }

    public void command(String string) {
        System.err.println("Invalid action " + string);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.selected) {
            if (LastSelected != null) {
                Icon.LastSelected.selected = false;
                LastSelected.repaint();
            }
            LastSelected = this;
            Icon.LastSelected.selected = true;
            LastSelected.repaint();
        } else {
            this.selected = false;
            this.repaint();
            LastSelected = null;
        }
        int n = mouseEvent.getClickCount();
        int n2 = mouseEvent.getButton();
        if (n == 2 && n2 == 1) {
            this.iconPanel.doubleClick(mouseEvent);
            return;
        }
        if (GraphicUtils.isPopupTrigger((MouseEvent)mouseEvent)) {
            this.iconPanel.rightClick(mouseEvent);
            return;
        }
        this.iconPanel.leftClick(mouseEvent);
        this.iconPanel.simpleClick(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

