/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

class FileTableModel
extends AbstractTableModel {
    protected File dir;
    protected String[] filenames;
    protected String[] columnNames = new String[]{"name", "size", "last modified", "Directory?"};
    protected Class[] columnClasses = new Class[]{String.class, Long.class, Date.class, Boolean.class};

    public FileTableModel(File file) {
        this.dir = file;
        this.filenames = file.list();
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.filenames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Class getColumnClass(int n) {
        return this.columnClasses[n];
    }

    public Object getValueAt(int n, int n2) {
        File file = new File(this.dir, this.filenames[n]);
        switch (n2) {
            case 0: {
                return this.filenames[n];
            }
            case 1: {
                return new Long(file.length());
            }
            case 2: {
                return new Date(file.lastModified());
            }
            case 3: {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }
}

