/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import madkit.explorer.Explorer_directory_sortAdapter;
import madkit.explorer.Explorer_hiddenFiles_filterAdapter;
import madkit.explorer.Explorer_name_sortAdapter;
import madkit.explorer.FileIconPanel;
import madkit.kernel.AbstractAgent;

public class Explorer
extends JPanel {
    JPanel contentPane;
    FileIconPanel icons;
    String path;
    String absolutePath;
    boolean hidden;
    AbstractAgent ag;
    JTextField display;

    public Explorer(AbstractAgent abstractAgent, String string, int n, JTextField jTextField) {
        super(new BorderLayout());
        this.ag = abstractAgent;
        this.path = string;
        this.hidden = false;
        this.icons = new FileIconPanel(abstractAgent, n, this);
        this.display = jTextField;
        JScrollPane jScrollPane = new JScrollPane(this.icons);
        this.add((Component)jScrollPane, "Center");
        this.path();
    }

    public Dimension getPreferredSize() {
        return new Dimension(380, 180);
    }

    public void path() {
        File file = new File(this.path);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't get Canonical File");
        }
        this.absolutePath = file.getAbsolutePath();
        this.read();
    }

    public boolean read() {
        File file = new File(this.absolutePath);
        if (this.display != null) {
            this.display.setText(this.absolutePath);
        }
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            this.icons.clear();
            File[] fileArray = file.listFiles(new Explorer_hiddenFiles_filterAdapter(this));
            if (fileArray == null) {
                return false;
            }
            Arrays.sort(fileArray, new Explorer_name_sortAdapter(this));
            Arrays.sort(fileArray, new Explorer_directory_sortAdapter(this));
            for (int i = 0; i < fileArray.length; ++i) {
                this.icons.addItem(fileArray[i]);
            }
            this.validate();
            return true;
        }
        return false;
    }

    public int directorySort(Object object, Object object2) {
        boolean bl = ((File)object).isDirectory();
        boolean bl2 = ((File)object2).isDirectory();
        if (bl && bl2) {
            return 0;
        }
        if (!bl && !bl2) {
            return 0;
        }
        if (bl) {
            return -1;
        }
        return 1;
    }

    public int nameSort(Object object, Object object2) {
        String string = ((File)object).getName();
        String string2 = ((File)object2).getName();
        return string.compareToIgnoreCase(string2);
    }

    public boolean hiddenFilesFilter(File file) {
        if (this.hidden) {
            return true;
        }
        return !file.isHidden();
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public boolean readUp() {
        File file = new File(this.absolutePath);
        String string = file.getParent();
        if (string != null) {
            this.absolutePath = string;
            return this.read();
        }
        return false;
    }

    public boolean readDown() {
        return this.read();
    }

    public String getParent(String string) {
        String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
        return string2.substring(0, string2.lastIndexOf(File.separator) + 1);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String string) {
        this.absolutePath = string;
    }
}

