/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Hashtable;
import madkit.communicator.TransportLayer;
import madkit.communicator.TwoChannelsDatagramListener;
import madkit.communicator.TwoChannelsMessageReceiver;

public class TwoChannelsMessageServer
extends Thread {
    TransportLayer agent;
    ServerSocket serverSocket;
    DatagramSocket serverDSocket;
    Hashtable tableClient;
    TwoChannelsDatagramListener dm;
    TwoChannelsMessageReceiver m;

    public int getServerPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public DatagramSocket getDatagramSocket() {
        return this.serverDSocket;
    }

    public TwoChannelsMessageServer(TransportLayer transportLayer, int n, Hashtable hashtable) throws IOException {
        this.agent = transportLayer;
        this.tableClient = hashtable;
        int n2 = 0;
        while (n2 < 5) {
            try {
                this.serverDSocket = new DatagramSocket(n + n2);
                transportLayer.setPort(n + n2);
                this.agent.println("UDPSocket Listening on port " + this.serverDSocket.getLocalPort());
                n2 = 5;
            }
            catch (SocketException socketException) {
                ++n2;
                this.agent.debug("Could not listen on port: " + n + ", " + socketException);
            }
        }
        n2 = 0;
        while (n2 < 5) {
            try {
                this.serverSocket = new ServerSocket(n + n2);
                transportLayer.setPort(n + n2);
                this.start();
                this.agent.println("TCPSocket Listening on port " + (n + n2));
                n2 = 5;
            }
            catch (IOException iOException) {
                ++n2;
                this.agent.debug("Could not listen on port: " + n + ", " + iOException);
            }
        }
    }

    public void close() {
        this.dm.stop();
        this.m.stop();
        this.dm.close();
        this.m.close();
        this.stop();
        try {
            TwoChannelsMessageServer.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        this.dm = new TwoChannelsDatagramListener(this.agent, this.serverDSocket);
        this.m = new TwoChannelsMessageReceiver(this.agent, this.serverDSocket, this.serverSocket, this.tableClient);
        this.dm.start();
        this.m.start();
    }
}

