/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import madkit.communicator.TransportLayer;
import madkit.communicator.TwoChannelsSocketExtremity;

public class TwoChannelsMessageReceiver
extends Thread {
    public ServerSocket serverSocket;
    public DatagramSocket serverDSocket;
    boolean alive = true;
    TransportLayer pere;
    Hashtable clientTable;

    public TwoChannelsMessageReceiver(TransportLayer transportLayer, DatagramSocket datagramSocket, ServerSocket serverSocket, Hashtable hashtable) {
        this.pere = transportLayer;
        this.serverSocket = serverSocket;
        this.serverDSocket = datagramSocket;
        this.clientTable = hashtable;
    }

    public void run() {
        boolean bl = false;
        Object var2_2 = null;
        while (true) {
            bl = false;
            var2_2 = null;
            if (!this.alive) break;
            try {
                if (this.serverSocket == null) continue;
                Socket socket = this.serverSocket.accept();
                this.pere.debug("ports: serveur:" + this.serverSocket.getLocalPort() + " listener:" + socket.getLocalPort());
                new TwoChannelsSocketExtremity(this.serverDSocket, socket, this.pere, this.clientTable);
            }
            catch (IOException iOException) {
                this.pere.debug("Exception while listening port " + iOException);
                break;
            }
        }
        this.pere.debug("receiver closed");
    }

    public synchronized void close() {
        try {
            this.pere.debug("Receiver: CLOSE!");
            this.alive = false;
            this.serverSocket.close();
            this.serverSocket = null;
        }
        catch (Exception exception) {
            this.pere.debug("Can't close MessageServer from DynamicTwoChannelsCommunicator in an orthodox way");
        }
    }
}

