/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Hashtable;
import java.util.Vector;
import madkit.communicator.CodingModule;
import madkit.communicator.MessageSegment;
import madkit.communicator.SegmentsArray;
import madkit.communicator.StatAgent;
import madkit.communicator.TransportLayer;
import madkit.kernel.Message;

public class TwoChannelsDatagramMessageExtremity
extends Thread {
    public int maxDataSize = 1400;
    public DatagramSocket dSocket;
    static byte[] inBuffer = new byte[1428];
    Hashtable receivedPackets;
    Hashtable messagesSize;
    short overheadSize = (short)4;
    int messageNumber;
    TransportLayer pere;
    protected StatAgent stat;
    CodingModule code;

    public TwoChannelsDatagramMessageExtremity(TransportLayer transportLayer, DatagramSocket datagramSocket, StatAgent statAgent, CodingModule codingModule) {
        this.pere = transportLayer;
        this.dSocket = datagramSocket;
        this.stat = statAgent;
        this.code = codingModule;
    }

    public int getDatagramSocketPort() {
        if (this.dSocket != null) {
            return this.dSocket.getLocalPort();
        }
        return -1;
    }

    private void reconstructObject(byte[] byArray) throws IOException {
        Object object = this.code.decode(byArray);
        this.stat.onIn(byArray.length, false, object);
        if (this.code.shouldBeDefaultTreated(object)) {
            if (object instanceof Message) {
                Message message = (Message)object;
                this.pere.communicatorInject(message);
            } else if (object instanceof Vector) {
                this.pere.communicatorTransmit((Vector)object);
            }
        }
    }

    public void run() {
        SegmentsArray segmentsArray = new SegmentsArray(this.pere);
        segmentsArray.start();
        block4: while (true) {
            try {
                while (true) {
                    int n = 0;
                    DatagramPacket datagramPacket = new DatagramPacket(inBuffer, inBuffer.length);
                    this.dSocket.receive(datagramPacket);
                    try {
                        n = datagramPacket.getLength();
                        byte[] byArray = new byte[n - this.overheadSize];
                        System.arraycopy(datagramPacket.getData(), 0, byArray, 0, n - this.overheadSize);
                        byte[] byArray2 = new byte[this.overheadSize];
                        System.arraycopy(datagramPacket.getData(), n - this.overheadSize, byArray2, 0, this.overheadSize);
                        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray2)));
                        Integer n2 = new Integer(dataInputStream.readShort());
                        byte by = dataInputStream.readByte();
                        byte by2 = dataInputStream.readByte();
                        if (by == 3) {
                            this.reconstructObject(byArray);
                            continue block4;
                        }
                        MessageSegment messageSegment = new MessageSegment(byArray, by2, by > 1);
                        Vector<MessageSegment> vector = segmentsArray.get(n2);
                        if (vector != null) {
                            if (!vector.contains(messageSegment)) {
                                vector.insertElementAt(messageSegment, by2);
                            }
                            if (((MessageSegment)vector.lastElement()).lastSegment() && vector.size() - 1 == ((MessageSegment)vector.lastElement()).getPartNumber()) {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                for (int i = 0; i < vector.size(); ++i) {
                                    byteArrayOutputStream.write(((MessageSegment)vector.elementAt(i)).getSegment());
                                }
                                this.reconstructObject(byteArrayOutputStream.toByteArray());
                                segmentsArray.remove(n2);
                                continue block4;
                            }
                            segmentsArray.put(n2, vector);
                            continue block4;
                        }
                        vector = new Vector<MessageSegment>();
                        vector.addElement(messageSegment);
                        segmentsArray.put(n2, vector);
                        continue block4;
                    }
                    catch (IOException iOException) {
                        System.out.println("DynamicTwoChannelsCommunicator: reciever exception " + iOException.toString());
                        iOException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                this.dSocket.close();
                System.err.println("DynamicTwoChannelsCommunicator: cannot receive datagram...");
                return;
            }
        }
    }

    public void close() {
        try {
            this.dSocket.close();
        }
        catch (Exception exception) {
            System.err.println("Can't close TwoChannelsDatagramMessageReceiver from DynamicTwoChannelsCommunicator in an orthodox way");
        }
    }
}

