/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.util.Vector;
import madkit.kernel.KernelMessage;

public class StatAgent
extends Thread {
    protected final int PERIOD = 20;
    protected final int TOTAL_TYPE = 0;
    protected final int SYSTEM_TYPE = 1;
    protected final int OTHER_TYPE = 2;
    protected final int TCP_TYPE = 3;
    protected final int UDP_TYPE = 4;
    protected final int NB_TYPE = 5;
    protected final String[] TYPE_NAMES = new String[]{"TOTAL", "SYSTEM", "OTHER", "TCP", "UDP"};
    protected final String[] ALL_MESSAGES = new String[]{"madkit.kernel.KernelMessage", "java.util.Vector"};
    protected final int NB_MESSAGE_TYPES = this.ALL_MESSAGES.length;
    protected long oldTime;
    protected long time;
    protected int[] in = new int[5];
    protected int[] out = new int[5];
    protected int[] nbIn = new int[5];
    protected int[] nbOut = new int[5];

    private boolean isType(Object object, int n, boolean bl) {
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return object instanceof KernelMessage || object instanceof Vector;
        }
        if (n == 2) {
            return !(object instanceof KernelMessage) && !(object instanceof Vector);
        }
        if (n == 3) {
            return bl;
        }
        if (n == 4) {
            return !bl;
        }
        System.out.println("Unknown stat type: " + n);
        System.exit(1);
        return false;
    }

    public void onIn(int n, boolean bl, Object object) {
        for (int i = 0; i < 5; ++i) {
            if (!this.isType(object, i, bl)) continue;
            int n2 = i;
            this.in[n2] = this.in[n2] + n;
            this.nbIn[i] = this.nbIn[i] + 1;
        }
    }

    public void onOut(int n, boolean bl, Object object) {
        for (int i = 0; i < 5; ++i) {
            if (!this.isType(object, i, bl)) continue;
            int n2 = i;
            this.out[n2] = this.out[n2] + n;
            this.nbOut[i] = this.nbOut[i] + 1;
        }
    }

    public void run() {
        while (true) {
            for (int i = 0; i < 5; ++i) {
                this.in[i] = 0;
                this.nbIn[i] = 0;
                this.out[i] = 0;
                this.nbOut[i] = 0;
            }
            this.oldTime = System.currentTimeMillis();
            try {
                StatAgent.sleep(20000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.time = System.currentTimeMillis();
        }
    }

    private void printAndFill(int n, int n2) {
        this.printAndFill(n + "", n2);
    }

    private void printAndFill(float f, int n) {
        this.printAndFill(f + "", n);
    }

    private void printAndFill(String string, int n) {
        int n2;
        int n3 = (--n - string.length()) / 2;
        int n4 = n - string.length() - n3;
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.print(" ");
        }
        System.out.print(string);
        for (n2 = 0; n2 < n4; ++n2) {
            System.out.print(" ");
        }
        System.out.print("|");
    }

    private void line(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("-");
        }
    }

    private void printStat(double d) {
        this.printAndFill("", 11);
        this.line(80);
        System.out.println();
        this.printAndFill("", 11);
        this.printAndFill("IN", 40);
        this.printAndFill("OUT", 40);
        System.out.println();
        this.printAndFill("", 11);
        this.line(80);
        System.out.println();
        this.printAndFill("", 11);
        this.printAndFill("NB", 10);
        this.printAndFill("SIZE (o)", 10);
        this.printAndFill("AVERAGE", 10);
        this.printAndFill("FLOW(o/s)", 10);
        this.printAndFill("NB", 10);
        this.printAndFill("SIZE (o)", 10);
        this.printAndFill("AVERAGE", 10);
        this.printAndFill("FLOW(o/s)", 10);
        System.out.println();
        this.line(91);
        System.out.println();
        for (int i = 0; i < 5; ++i) {
            this.lineValues(this.TYPE_NAMES[i], this.nbIn[i], this.in[i], this.nbOut[i], this.out[i], d);
        }
    }

    private void lineValues(String string, int n, int n2, int n3, int n4, double d) {
        System.out.print("|");
        this.printAndFill(string, 10);
        this.printAndFill(n, 10);
        this.printAndFill(n2, 10);
        this.printAndFill((float)n2 / (float)n, 10);
        this.printAndFill((float)((double)n2 / d), 10);
        this.printAndFill(n3, 10);
        this.printAndFill(n4, 10);
        this.printAndFill((float)n4 / (float)n3, 10);
        this.printAndFill((float)((double)n4 / d), 10);
        System.out.println();
        this.line(91);
        System.out.println();
    }
}

