/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import madkit.communicator.DynamicCommBean;
import madkit.communicator.SocketKernel;
import madkit.communicator.TransportLayer;
import madkit.communicator.TwoChannelsSocketExtremity;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.NetworkRequest;
import madkit.kernel.StringMessage;

public final class DynamicTwoChannelsCommunicator
extends Agent {
    static int DEFAULT_PORT = 4444;
    TransportLayer comm;
    DynamicCommBean agentGUI;
    AgentAddress mykernel;
    SocketKernel socketInfo = new SocketKernel(DEFAULT_PORT);
    Map kernels = new HashMap();
    Hashtable clientTable;
    boolean alive = true;
    short messagesSegmentsTableSize = (short)400;
    int garbagePeriod = 10000;
    int timeoutBetweenSegments = 50000;

    public DynamicTwoChannelsCommunicator() {
        System.err.println("SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSalut");
        this.clientTable = new Hashtable();
    }

    public DynamicTwoChannelsCommunicator(int n) {
        this.socketInfo.setPort(n);
        this.clientTable = new Hashtable();
    }

    String getId() {
        return this.getAddress().getKernel().getID();
    }

    int getPort() {
        return this.socketInfo.getPort();
    }

    void setPort(int n) {
        this.socketInfo.setPort(n);
    }

    short getMessagesSegmentsTableSize() {
        return this.messagesSegmentsTableSize;
    }

    int getGarbagePeriod() {
        return this.garbagePeriod;
    }

    int getTimeoutBetweenSegments() {
        return this.timeoutBetweenSegments;
    }

    boolean isAlive() {
        return this.alive;
    }

    public void initGUI() {
        this.agentGUI = new DynamicCommBean(this);
        this.setGUIObject(this.agentGUI);
    }

    public void activate() {
        this.println("Communicator Activated");
        this.comm = new TransportLayer(this, this.clientTable);
        if (this.hasGUI()) {
            this.agentGUI.setActive(this.comm.getServerActive());
        }
        this.requestRole("public", "system", "communicator", null);
        this.mykernel = this.getAgentWithRole("communications", "site");
        this.sendMessage(this.mykernel, (Message)new NetworkRequest(1));
    }

    public void live() {
        while (this.alive) {
            Message message = this.waitNextMessage();
            this.exitImmediatlyOnKill();
            if (!this.alive) {
                return;
            }
            if (message instanceof KernelMessage) {
                this.handleMessage((Message)((KernelMessage)message));
                continue;
            }
            if (!(message instanceof StringMessage)) continue;
            this.handlePersonalMessage((StringMessage)message);
        }
    }

    public void end() {
        this.sendMessage(this.mykernel, (Message)new NetworkRequest(2));
        this.alive = false;
        Iterator iterator = this.clientTable.values().iterator();
        while (iterator.hasNext()) {
            this.comm.disconnect((TwoChannelsSocketExtremity)iterator.next());
        }
        this.comm.close();
        this.println("Agent SocketCommunicator killed. server is closed");
        System.gc();
    }

    synchronized void disconnectFrom(String string) {
        Iterator iterator = this.kernels.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            KernelAddress kernelAddress = null;
            try {
                kernelAddress = new KernelAddress(string2);
            }
            catch (Exception exception) {
                this.println("Bad  KernelAddress in Communicator :" + exception);
            }
            if (!kernelAddress.getID().equals(string)) continue;
            SocketKernel socketKernel = (SocketKernel)this.kernels.get(kernelAddress.toString());
            iterator.remove();
            this.sendMessage(this.mykernel, (Message)new NetworkRequest(4, (Object)string));
            if (!this.hasGUI()) break;
            this.agentGUI.removeText(socketKernel.getHost() + ":" + socketKernel.getPort());
            break;
        }
    }

    synchronized void addHost(String string, int n) {
        this.println("Trying to contact " + string + ":" + n);
        try {
            for (String string2 : this.kernels.keySet()) {
                KernelAddress kernelAddress = new KernelAddress(string2);
                SocketKernel socketKernel = (SocketKernel)this.kernels.get(string2);
                if ((kernelAddress.getHost().equals(string) || string.equals("")) && socketKernel.getPort() == n) {
                    return;
                }
                if (!this.mykernel.getKernel().equals((Object)kernelAddress)) continue;
                return;
            }
        }
        catch (Exception exception) {
            this.println("Error: " + exception);
            return;
        }
        Object object = null;
        try {
            object = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.println("Host " + string + " unknown.");
            return;
        }
        if (this.hasGUI()) {
            this.agentGUI.setStatus("Req.");
        }
        this.comm.connect(new SocketKernel(((InetAddress)object).getHostAddress(), n), this.buildSynch('c'));
    }

    private synchronized boolean addKernel(KernelAddress kernelAddress, SocketKernel socketKernel) {
        if (this.socketInfo.equals(socketKernel)) {
            return false;
        }
        if (!this.kernels.containsKey(kernelAddress.toString()) && socketKernel != null) {
            this.kernels.put(kernelAddress.toString(), socketKernel);
            this.debug("@@@@@@@@@@@ add a new kernel @@@@@@@@ = " + socketKernel + "KernelAddress= " + kernelAddress);
            if (this.hasGUI()) {
                this.agentGUI.setText(socketKernel.getHost() + ":" + socketKernel.getPort());
            }
            this.println("connected with " + kernelAddress);
            return true;
        }
        return false;
    }

    synchronized void injectMessage(Message message) {
        this.sendMessage(this.mykernel, (Message)new NetworkRequest(7, (Object)message));
    }

    private synchronized void handleMessage(Message message) {
        Message message2 = null;
        if (message instanceof KernelMessage) {
            KernelMessage kernelMessage = (KernelMessage)message;
            message2 = (Message)kernelMessage.getArgument();
        } else {
            message2 = message;
        }
        this.comm.sendto(message2, message2.getReceiver().getKernel());
        this.debug("sending message " + message);
    }

    private void handlePersonalMessage(StringMessage stringMessage) {
        this.debug("Communicator: personal message: " + stringMessage);
        StringTokenizer stringTokenizer = new StringTokenizer(stringMessage.getString(), " :");
        String string = "nop";
        String string2 = null;
        int n = DEFAULT_PORT;
        String string3 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (string.equals("add-host")) {
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Communicator error: not a valid port number: " + n);
                    }
                }
                this.addHost(string2, n);
            } else {
                System.err.println("Communicator error: not a valid host to add: " + string2);
            }
        } else if (string.equals("get-port")) {
            this.sendMessage(stringMessage.getSender(), (Message)new StringMessage("reply port=" + this.getPort()));
        }
    }

    synchronized void transmitInfo(Vector vector) {
        Collection collection;
        AgentAddress agentAddress;
        SocketKernel socketKernel;
        KernelAddress kernelAddress;
        Enumeration enumeration = vector.elements();
        String string = (String)enumeration.nextElement();
        if (string.equals("ACK_SOCKET_INFO")) {
            this.debug("  ---------SocketCom--------- ACK_SOCKET_INFO ---- ");
            kernelAddress = (KernelAddress)enumeration.nextElement();
            socketKernel = (SocketKernel)enumeration.nextElement();
            agentAddress = (AgentAddress)enumeration.nextElement();
            collection = (Collection)enumeration.nextElement();
            if (this.addKernel(kernelAddress, socketKernel)) {
                if (this.hasGUI()) {
                    this.agentGUI.setStatus("ok");
                }
                for (SocketKernel socketKernel2 : collection) {
                    if (this.socketInfo.equals(socketKernel2) || this.kernels.containsValue(socketKernel2)) continue;
                    this.comm.connect(socketKernel2, this.buildSynch('c'));
                }
            }
        }
        if (string.equals("TRANSMIT_SOCKET_INFO")) {
            this.debug("  ---------SocketCom------- TRANSMIT_SOCKET_INFO ---- ");
            kernelAddress = (KernelAddress)enumeration.nextElement();
            socketKernel = (SocketKernel)enumeration.nextElement();
            agentAddress = (AgentAddress)enumeration.nextElement();
            collection = (Collection)enumeration.nextElement();
            if (this.addKernel(kernelAddress, socketKernel)) {
                this.comm.replyConnect(kernelAddress, this.buildSynch('r'));
                this.sendMessage(this.mykernel, (Message)new NetworkRequest(3, (Object)agentAddress));
                if (this.hasGUI()) {
                    this.agentGUI.setStatus("ok");
                }
                this.debug("  ---------SocketCom--------- Etape 0 ");
                if (collection != null) {
                    for (SocketKernel socketKernel2 : collection) {
                        if (this.socketInfo.equals(socketKernel2) || this.kernels.containsValue(socketKernel2)) continue;
                        this.comm.connect(socketKernel2, this.buildSynch('c'));
                    }
                }
            }
        }
    }

    private Vector buildSynch(char c) {
        Vector<Object> vector = new Vector<Object>();
        if (c == 'c') {
            vector.addElement("TRANSMIT_SOCKET_INFO");
        } else if (c == 'r') {
            vector.addElement("ACK_SOCKET_INFO");
        }
        vector.addElement(this.getAddress().getKernel());
        vector.addElement(this.socketInfo);
        vector.addElement(this.mykernel);
        vector.addElement(new HashSet(this.kernels.values()));
        return vector;
    }
}

