/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.share;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import madkit.MadChat.share.AbstractShareAgent;
import madkit.MadChat.share.EndDownloadMessage;
import madkit.MadChat.share.FileInfo;
import madkit.MadChat.share.KillMessage;
import madkit.MadChat.share.ListFic;
import madkit.MadChat.share.OffsetMessage;
import madkit.MadChat.share.PaquetOnQueue;
import madkit.MadChat.share.ProgressBar;
import madkit.MadChat.share.ReturnMessage;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SmallShareAgent
extends Agent {
    AbstractShareAgent shareAgent;
    AgentAddress serverAddress;
    AgentAddress smallServerAddress;
    String clientPath;
    int totalDownloadSize = 0;
    int currentDownloadSize = 0;
    Vector stockPaquetOnQueue = new Vector();
    Vector stockUpdatedFile = new Vector();
    int maxSize;
    boolean live;
    boolean killBorn = false;
    boolean updatePlugin;
    String pluginName;
    String currentFile = "";
    String writeMode = "";
    String incomingPluginsPath;
    ProgressBar progressBar = null;
    int currentBarSize = 0;
    Calendar limitDate;
    Calendar currentDate;
    int timeout;
    String groupName = "share";

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public boolean getUpdatePlugin() {
        return this.updatePlugin;
    }

    public SmallShareAgent() {
    }

    public SmallShareAgent(ListFic listFic, AgentAddress agentAddress, AbstractShareAgent abstractShareAgent, boolean bl) {
        Vector vector = listFic.getVector();
        this.serverAddress = agentAddress;
        this.shareAgent = abstractShareAgent;
        this.updatePlugin = bl;
        this.incomingPluginsPath = this.shareAgent.madkitDirectory;
        this.timeout = this.shareAgent.getTimeout();
        this.maxSize = this.shareAgent.getMaxSize();
        this.createPaquet(vector, this.serverAddress);
        this.shareAgent.addPaquetOnQueue(this.stockPaquetOnQueue);
        if (this.updatePlugin) {
            this.pluginName = this.parsePluginName(((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getPath());
            File file = new File(this.clientPath + "/plugins/" + this.pluginName);
            if (file.exists()) {
                File file2 = new File(this.clientPath + "/plugins/" + this.pluginName + "Backup");
                if (file2.exists()) {
                    this.eraseDirectory(file2);
                    System.out.println("(client) " + this.pluginName + "Backup deleted");
                }
                file.renameTo(file2);
                System.out.println("(client) " + this.pluginName + "Backup created");
            }
        }
    }

    public SmallShareAgent(Vector vector, AbstractShareAgent abstractShareAgent) {
        this.shareAgent = abstractShareAgent;
        this.updatePlugin = false;
        this.timeout = this.shareAgent.getTimeout();
        this.maxSize = this.shareAgent.getMaxSize();
        for (int i = 0; i < vector.size(); ++i) {
            this.stockPaquetOnQueue.add(vector.elementAt(i));
            this.totalDownloadSize += ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getPaquetSize();
        }
        this.serverAddress = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getAddress();
    }

    public void activate() {
        this.groupName = this.shareAgent.getGroupName();
        this.createGroup(true, this.groupName, null, null);
        this.requestRole(this.groupName, "SmallShare", null);
        if (!this.killBorn) {
            this.live = true;
            this.startDownload();
        }
    }

    public void live() {
        while (this.live) {
            this.exitImmediatlyOnKill();
            this.checkTimeout();
            if (!this.isMessageBoxEmpty()) {
                Message message = this.waitNextMessage();
                try {
                    this.handleMessage(message);
                }
                catch (IOException iOException) {
                    System.out.println("Error : SmallShareAgent --> HandleMessage");
                }
                continue;
            }
            this.pause(1000);
        }
    }

    public void end() {
        if (!this.killBorn) {
            this.killAgent((AbstractAgent)this.progressBar);
            this.sendMessage(this.smallServerAddress, new EndDownloadMessage());
        }
    }

    void handleMessage(Message message) throws IOException {
        if (message instanceof ReturnMessage) {
            Object object;
            String string = ((ReturnMessage)message).getSender().getKernel().getHost().toString();
            this.smallServerAddress = ((ReturnMessage)message).getSender();
            String string2 = ((ReturnMessage)message).getPath();
            int n = ((ReturnMessage)message).getOffsetStart();
            int n2 = ((ReturnMessage)message).getOffsetEnd();
            byte[] byArray = ((ReturnMessage)message).getByte();
            long l = ((ReturnMessage)message).getLastModified();
            String string3 = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getClientPath();
            this.progressBar.setText("Download " + string2);
            this.progressBar.setDownloadSize(this.currentDownloadSize / 1024 + "/" + this.totalDownloadSize / 1024 + "Ko");
            this.progressBar.setMessage(null);
            boolean bl = this.createFile(string2, n, n2, byArray, string3);
            ++this.currentBarSize;
            this.progressBar.getBar().setValue(this.currentBarSize);
            this.progressBar.validate();
            int n3 = this.stockPaquetOnQueue.size();
            boolean bl2 = true;
            for (int i = 0; i < n3; ++i) {
                object = (PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0);
                String string4 = ((PaquetOnQueue)object).getPath();
                if (!string4.equals(string2)) continue;
                bl2 = false;
                break;
            }
            if (bl2 && !this.updatePlugin && bl) {
                this.updateHistory(string2, string);
                this.shareAgent.AskUserUpdatedFile(string2, string, l);
            }
            if (!this.stockPaquetOnQueue.isEmpty()) {
                PaquetOnQueue paquetOnQueue = (PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0);
                object = paquetOnQueue.getPath();
                n = paquetOnQueue.getOffsetStart();
                n2 = paquetOnQueue.getOffsetEnd();
                this.sendMessage(this.smallServerAddress, new OffsetMessage((String)object, n, n2));
                this.limitDate = Calendar.getInstance();
                this.limitDate.add(13, this.timeout);
            } else {
                if (this.updatePlugin) {
                    this.addUpdatePluginToUpdatingPluginFile();
                }
                this.live = false;
                this.shareAgent.removeSmallShareAgent(this);
                this.currentBarSize = 0;
                System.out.println("(client) All files have been downloaded");
            }
        }
        if (message instanceof KillMessage) {
            for (int i = 0; i < this.stockPaquetOnQueue.size(); ++i) {
                this.shareAgent.removePaquetOnQueue(((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getPath(), this.smallServerAddress, ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getOffsetStart(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getOffsetEnd());
            }
            this.live = false;
            this.shareAgent.removeSmallShareAgent(this);
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void createPaquet(Vector vector, AgentAddress agentAddress) {
        int n;
        if (this.updatePlugin) {
            this.clientPath = this.incomingPluginsPath;
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose Directory");
            jFileChooser.setApproveButtonText("Accept");
            jFileChooser.setCurrentDirectory(new File(this.shareAgent.madkitDirectory + File.separator + this.groupName + File.separator + "Incoming"));
            n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                this.clientPath = jFileChooser.getSelectedFile().getAbsolutePath();
            } else {
                this.killBorn = true;
                this.live = false;
                return;
            }
        }
        this.clientPath = this.clientPath.replace('\\', '/');
        for (int i = 0; i < vector.size(); ++i) {
            n = ((FileInfo)vector.elementAt(i)).getSizeFic();
            String string = ((FileInfo)vector.elementAt(i)).getPath();
            this.totalDownloadSize += n;
            int n2 = n % this.maxSize;
            int n3 = n2 == 0 ? n / this.maxSize : n / this.maxSize + 1;
            int n4 = 0;
            int n5 = 0;
            for (int j = 1; j < n3; ++j) {
                PaquetOnQueue paquetOnQueue = new PaquetOnQueue(string, agentAddress, n4, n5 += this.maxSize, this.clientPath);
                this.stockPaquetOnQueue.addElement(paquetOnQueue);
                n4 = n5;
            }
            n4 = n5;
            PaquetOnQueue paquetOnQueue = new PaquetOnQueue(string, agentAddress, n4, n5 += n2, this.clientPath);
            this.stockPaquetOnQueue.addElement(paquetOnQueue);
        }
    }

    public void startDownload() {
        this.progressBar = this.updatePlugin ? new ProgressBar(0, "Updating plugin(s) from " + this.serverAddress.getKernel().getHost().toString(), "Connection ...", this) : new ProgressBar(0, "Downloading from " + this.serverAddress.getKernel().getHost().toString(), "Connection ...", this);
        this.launchAgent((AbstractAgent)this.progressBar, this.serverAddress.getKernel().getHost().toString(), true);
        this.progressBar.setVisible(true);
        this.progressBar.validate();
        this.progressBar.setMax(this.stockPaquetOnQueue.size());
        this.progressBar.setVisible(true);
        this.progressBar.getBar().setValue(0);
        this.progressBar.validate();
        PaquetOnQueue paquetOnQueue = (PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0);
        String string = paquetOnQueue.getPath();
        int n = paquetOnQueue.getOffsetStart();
        int n2 = paquetOnQueue.getOffsetEnd();
        AgentAddress agentAddress = paquetOnQueue.getAddress();
        this.limitDate = Calendar.getInstance();
        this.limitDate.add(13, this.timeout);
        this.sendMessage(agentAddress, new OffsetMessage(string, n, n2));
    }

    public boolean createFile(String string, int n, int n2, byte[] byArray, String string2) {
        boolean bl = true;
        int n3 = string.lastIndexOf("/");
        if (n3 != -1) {
            String string3 = string.substring(0, n3);
            File file = new File(string2 + "/" + string3);
            file.mkdirs();
        }
        if (n == 0) {
            boolean bl2 = bl = !this.checkIfFileAlreadyExist(string, string2);
        }
        if (!this.currentFile.equals(string2 + "/" + string) || !this.writeMode.equals("ignore")) {
            this.writeFile(string, n, n2, byArray, string2);
        }
        if (!(this.writeMode.equals("null") || this.writeMode.equals("ignore") || this.writeMode.equals("ignore all") || this.stockPaquetOnQueue.isEmpty())) {
            this.stockPaquetOnQueue.removeElementAt(0);
            this.shareAgent.removePaquetOnQueue(string, this.smallServerAddress, n, n2);
        }
        return bl;
    }

    public void updateHistory(String string, String string2) {
        try {
            String string3 = new Date().toString();
            File file = new File(this.shareAgent.madkitDirectory + File.separator + this.groupName + File.separator + "history.ini");
            if (!file.exists()) {
                file.createNewFile();
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("history");
                Element element2 = document.createElement("file");
                element2.setAttribute("date", string3);
                element2.setAttribute("path", string);
                element2.setAttribute("server-name", string2);
                element.appendChild(element2);
                document.appendChild(element);
                OutputFormat outputFormat = new OutputFormat(document);
                FileWriter fileWriter = new FileWriter(file);
                outputFormat.setIndenting(true);
                outputFormat.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            } else {
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(file);
                Element element = document.getDocumentElement();
                Element element3 = document.createElement("file");
                element3.setAttribute("date", string3);
                element3.setAttribute("path", string);
                element3.setAttribute("server-name", string2);
                element.appendChild(element3);
                OutputFormat outputFormat = new OutputFormat(document);
                FileWriter fileWriter = new FileWriter(file);
                outputFormat.setIndenting(true);
                outputFormat.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void checkTimeout() {
        this.currentDate = Calendar.getInstance();
        if (this.currentDate.after(this.limitDate)) {
            int n = JOptionPane.showConfirmDialog(null, "Error connection on server \"" + this.serverAddress.getKernel().getHost().toString() + "\" !" + "\nRetry ?", "Timeout", 0);
            if (n == 0) {
                this.limitDate.add(13, this.timeout);
                this.killAgent((AbstractAgent)this.progressBar);
                this.startDownload();
            } else {
                n = JOptionPane.showConfirmDialog(null, "Would you like to save infos to resume download", "Timeout", 0);
                if (n != 0) {
                    for (int i = 0; i < this.stockPaquetOnQueue.size(); ++i) {
                        String string = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getPath();
                        AgentAddress agentAddress = this.serverAddress;
                        int n2 = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getOffsetStart();
                        int n3 = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(i)).getOffsetEnd();
                        this.shareAgent.removePaquetOnQueue(string, agentAddress, n2, n3);
                    }
                    this.stockPaquetOnQueue.clear();
                    this.shareAgent.removeSmallShareAgent(this);
                }
                this.live = false;
            }
        }
    }

    public void writeFile(String string, int n, int n2, byte[] byArray, String string2) {
        this.currentDownloadSize += byArray.length;
        try {
            File file = new File(string2 + "/" + string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(n);
            randomAccessFile.write(byArray);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Error : SmallShareAgent --> can't write file \"" + string2 + "/" + string + "\".");
        }
    }

    public String parsePluginName(String string) {
        string = ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getPath();
        int n = string.indexOf("/");
        string = string.substring(n + 1);
        n = string.indexOf("/");
        return string.substring(0, n);
    }

    public void addUpdatePluginToUpdatingPluginFile() {
        try {
            File file = new File(this.shareAgent.madkitDirectory + File.separator + this.groupName + File.separator + "updatingPlugin.ini");
            if (!file.exists()) {
                file.createNewFile();
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("updated-plugins");
                Element element2 = document.createElement("plugin");
                element2.setAttribute("plugin-name", this.pluginName);
                element.appendChild(element2);
                document.appendChild(element);
                OutputFormat outputFormat = new OutputFormat(document);
                FileWriter fileWriter = new FileWriter(file);
                outputFormat.setIndenting(true);
                outputFormat.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            } else {
                Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(file);
                Element element = document.getDocumentElement();
                Element element3 = document.createElement("plugin");
                element3.setAttribute("plugin-name", this.pluginName);
                element.appendChild(element3);
                OutputFormat outputFormat = new OutputFormat(document);
                FileWriter fileWriter = new FileWriter(file);
                outputFormat.setIndenting(true);
                outputFormat.setLineSeparator(System.getProperties().get("line.separator").toString());
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
                xMLSerializer.asDOMSerializer();
                xMLSerializer.serialize(document);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean checkIfFileAlreadyExist(String string, String string2) {
        boolean bl = false;
        File file = new File(string2 + "/" + string);
        if (file.exists() && !this.updatePlugin) {
            File file2;
            int n;
            Object[] objectArray = new Object[]{"ignore", "ignore all", "replace", "replace all", "replace with backup", "replace all with backup"};
            this.writeMode = (String)JOptionPane.showInputDialog(null, "An other file with the same name (" + string + ") was found\n" + "What would you like to do?", "Warning", -1, null, objectArray, "ignore");
            if (this.writeMode.equals("ignore") || this.writeMode.equals("null")) {
                this.currentFile = string2 + "/" + string;
                while (!this.stockPaquetOnQueue.isEmpty() && string.equals(((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getPath())) {
                    this.shareAgent.removePaquetOnQueue(((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getPath(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getAddress(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getOffsetStart(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getOffsetEnd());
                    this.stockPaquetOnQueue.remove(0);
                    this.totalDownloadSize -= ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(0)).getPaquetSize();
                    ++this.currentBarSize;
                    bl = true;
                }
            }
            if (this.writeMode.equals("ignore all")) {
                n = this.stockPaquetOnQueue.size();
                int n2 = 0;
                while (n2 < n) {
                    file2 = new File(string2 + "/" + ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n2)).getPath());
                    if (file2.exists()) {
                        this.shareAgent.removePaquetOnQueue(((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n2)).getPath(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n2)).getAddress(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n2)).getOffsetStart(), ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n2)).getOffsetEnd());
                        this.totalDownloadSize -= ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n2)).getPaquetSize();
                        this.stockPaquetOnQueue.remove(n2);
                        ++this.currentBarSize;
                        --n;
                        continue;
                    }
                    ++n2;
                }
                bl = true;
            }
            if (this.writeMode.equals("replace")) {
                file.delete();
            }
            if (this.writeMode.equals("replace all")) {
                for (n = 0; n < this.stockPaquetOnQueue.size(); ++n) {
                    file2 = new File(string2 + "/" + ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n)).getPath());
                    if (!file2.exists()) continue;
                    file2.delete();
                }
            }
            if (this.writeMode.equals("replace with backup")) {
                file.renameTo(new File(string2 + "/" + string + ".backup"));
            }
            if (this.writeMode.equals("replace all with backup")) {
                for (n = 0; n < this.stockPaquetOnQueue.size(); ++n) {
                    file2 = new File(string2 + "/" + ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n)).getPath());
                    if (!file2.exists()) continue;
                    file2.renameTo(new File(string2 + "/" + ((PaquetOnQueue)this.stockPaquetOnQueue.elementAt(n)).getPath() + ".backup"));
                }
            }
        }
        return bl;
    }

    public void eraseDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.eraseDirectory(file2);
            }
            file2.delete();
        }
        file.delete();
    }
}

