/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.share;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import madkit.MadChat.share.AbstractShareAgent;
import madkit.MadChat.share.FicMessage;
import madkit.MadChat.share.SearchTable;
import madkit.MadChat.share.SearchedFile;
import madkit.MadChat.share.SmallSearchFileAgent;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;

class ShareSearchFilePanel
extends JFrame
implements ActionListener {
    AbstractShareAgent shareAgent;
    SmallSearchFileAgent ssfa;
    String fileName;
    SearchTable searchTable;
    JPanel mainPanel;
    JPanel northPanel;
    JPanel southPanel;
    JPanel titlePane;
    JPanel searchPane;
    JPanel resultPane;
    JPanel downloadPane;
    JPanel closePane;
    JTextField searchTextField;
    JButton searchButton;
    JButton closeButton;
    JButton stopButton;
    JButton downloadButton;

    public String getFileName() {
        return this.fileName;
    }

    public ShareSearchFilePanel(AbstractShareAgent abstractShareAgent) {
        this.shareAgent = abstractShareAgent;
        this.fileName = "";
        this.setResizable(false);
        this.setTitle("SHARE SEARCH FILE");
        this.setSize(650, 650);
        this.setLocation(300, 300);
        this.searchTable = new SearchTable(new Vector());
        this.mainPanel = new JPanel(new BorderLayout());
        this.northPanel = new JPanel(new GridLayout(3, 1));
        this.southPanel = new JPanel(new GridLayout(2, 1));
        this.titlePane = new JPanel();
        this.searchPane = new JPanel();
        this.resultPane = new JPanel(new BorderLayout());
        this.downloadPane = new JPanel();
        this.closePane = new JPanel();
        this.searchTextField = new JTextField(10);
        this.searchButton = new JButton("search");
        this.closeButton = new JButton("close");
        this.downloadButton = new JButton("download");
        this.stopButton = new JButton("stop research");
        this.stopButton.setEnabled(false);
        this.searchButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.downloadButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.titlePane.add(new JLabel("=== SHARE SEARCH FILE ==="));
        this.searchPane.add(new JLabel("file "));
        this.searchPane.add(this.searchTextField);
        this.searchPane.add(this.searchButton);
        this.resultPane.add(this.searchTable);
        this.downloadPane.add(this.downloadButton);
        this.downloadPane.add(this.stopButton);
        this.closePane.add(this.closeButton);
        this.northPanel.add(this.titlePane);
        this.northPanel.add(this.searchPane);
        this.northPanel.add(new JLabel("  "));
        this.southPanel.add(this.downloadPane);
        this.southPanel.add(this.closePane);
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.resultPane, "Center");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.mainPanel.add((Component)new JLabel("  "), "East");
        this.mainPanel.add((Component)new JLabel("  "), "West");
        this.getContentPane().add(this.mainPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ShareSearchFilePanel.this.shareAgent.killAgent((AbstractAgent)ShareSearchFilePanel.this.ssfa);
                ShareSearchFilePanel.this.setVisible(false);
                ShareSearchFilePanel.this.dispose();
            }
        });
    }

    public void display() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.searchButton) {
            this.fileName = this.searchTextField.getText();
            this.searchButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.searchButton_action(this.fileName);
        }
        if (actionEvent.getSource() == this.closeButton) {
            this.shareAgent.killAgent((AbstractAgent)this.ssfa);
            this.setVisible(false);
            this.dispose();
        }
        if (actionEvent.getSource() == this.downloadButton) {
            this.downloadButton_action();
        }
        if (actionEvent.getSource() == this.stopButton) {
            this.shareAgent.killAgent((AbstractAgent)this.ssfa);
            this.searchButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
    }

    public void searchButton_action(String string) {
        if (string.equals("")) {
            JOptionPane.showMessageDialog(this, "Please, enter a name file.", "File Name", 0);
            this.searchButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        } else {
            this.updateResultTable(new Vector());
            this.ssfa = new SmallSearchFileAgent(this.shareAgent, this);
            this.shareAgent.launchAgent((AbstractAgent)this.ssfa, "smallSearchFileAgent" + string, false);
        }
    }

    public void downloadButton_action() {
        if (this.searchTable.getSelectedRow() != -1) {
            AgentAddress agentAddress = ((SearchedFile)this.searchTable.getVector().elementAt(this.searchTable.getSelectedRow())).getServerAddress();
            String string = ((SearchedFile)this.searchTable.getVector().elementAt(this.searchTable.getSelectedRow())).getVirtualPath();
            this.shareAgent.sendMessage(agentAddress, new FicMessage(string));
        }
    }

    public void updateResultTable(Vector vector) {
        this.resultPane.removeAll();
        this.searchTable = new SearchTable(vector);
        this.resultPane.add(this.searchTable);
        this.resultPane.validate();
        this.mainPanel.validate();
    }
}

