/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.share;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import madkit.MadChat.MadChat;
import madkit.MadChat.share.AbstractShareAgent;
import madkit.MadChat.share.ExplorerPanel;
import madkit.MadChat.share.ServerPanel_close_actionListenerAdapter;
import madkit.MadChat.share.ServerPanel_download_actionListenerAdapter;
import madkit.MadChat.share.ServerPanel_refresh_actionListenerAdapter;
import madkit.MadChat.share.ServerPanel_view_actionListenerAdapter;
import madkit.MadChat.share.ShareRemoteTree;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AgentAddress;

public class ServerPanel
extends JPanel
implements TreeSelectionListener {
    DirEntry entry;
    AgentAddress address;
    AbstractShareAgent agent;
    ShareRemoteTree tree;
    MadChat agentPanel;
    JButton downloadButton;
    JButton closeButton;
    JButton refreshButton;
    JButton viewButton;
    TreePath selection;
    JPanel optionPanel;
    JPanel downloadPanel;
    JPanel refreshPanel;
    JPanel viewPanel;
    JPanel closePanel;
    JPanel infoPanel;

    public ServerPanel(MadChat madChat, DirEntry dirEntry, AbstractShareAgent abstractShareAgent, AgentAddress agentAddress) {
        this.agentPanel = madChat;
        this.entry = dirEntry;
        this.address = agentAddress;
        this.agent = abstractShareAgent;
        this.setLayout(new BorderLayout());
        this.optionPanel = new JPanel();
        this.downloadPanel = new JPanel();
        this.refreshPanel = new JPanel();
        this.viewPanel = new JPanel();
        this.closePanel = new JPanel();
        this.infoPanel = new JPanel();
        this.optionPanel.setLayout(new GridLayout(5, 1));
        this.downloadPanel.setLayout(new FlowLayout());
        this.refreshPanel.setLayout(new FlowLayout());
        this.viewPanel.setLayout(new FlowLayout());
        this.closePanel.setLayout(new FlowLayout());
        this.infoPanel.setLayout(new FlowLayout());
        this.downloadButton = new JButton("Download");
        this.downloadButton.setToolTipText("Download selected file or directory");
        this.downloadButton.setEnabled(false);
        this.downloadButton.addActionListener(new ServerPanel_download_actionListenerAdapter(this));
        this.closeButton = new JButton("Close");
        this.closeButton.setToolTipText("Close current server panel");
        this.closeButton.addActionListener(new ServerPanel_close_actionListenerAdapter(this));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setToolTipText("Refresh current server panel");
        this.refreshButton.addActionListener(new ServerPanel_refresh_actionListenerAdapter(this));
        this.viewButton = new JButton("View Incoming");
        this.viewButton.setToolTipText("Open your incoming directory with an explorer");
        this.viewButton.addActionListener(new ServerPanel_view_actionListenerAdapter(this));
        Calendar calendar = Calendar.getInstance();
        JLabel jLabel = new JLabel(" Updated : " + 11 + ":" + 12 + ":" + 13);
        this.downloadPanel.add(this.downloadButton);
        this.refreshPanel.add(this.refreshButton);
        this.viewPanel.add(this.viewButton);
        this.closePanel.add(this.closeButton);
        this.infoPanel.add(jLabel);
        this.optionPanel.add(this.downloadPanel);
        this.optionPanel.add(this.refreshPanel);
        this.optionPanel.add(this.viewPanel);
        this.optionPanel.add(this.closePanel);
        this.optionPanel.add(jLabel);
        this.tree = new ShareRemoteTree(this.entry, this.agent, this.address);
        this.tree.getTree().addTreeSelectionListener(this);
        this.add((Component)((Object)this.tree), "Center");
        this.add((Component)this.optionPanel, "East");
    }

    public void close_action(ActionEvent actionEvent) {
        this.agentPanel.removeServerPanel();
    }

    public void download_action(ActionEvent actionEvent) {
        System.out.println("Class ShareAgentPanel : download " + this.selection.toString());
        this.tree.getPath(this.selection.toString());
        this.tree.send();
    }

    public void refresh_action(ActionEvent actionEvent) {
        this.agentPanel.removeServerPanel();
        this.agentPanel.addServerPanel(this.entry, this.address);
    }

    public void view_action(ActionEvent actionEvent) {
        final JFrame jFrame = new JFrame("Explorer");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setContentPane(new ExplorerPanel(this.agent.madkitDirectory + File.separator + this.agent.groupName + File.separator + "Incoming"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selection = this.tree.getTree().getSelectionPath();
        if (this.selection == null) {
            this.downloadButton.setEnabled(false);
        } else {
            this.downloadButton.setEnabled(true);
        }
    }
}

