/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.share;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import madkit.MadChat.share.GenericTableMenu;

public class GenericTable
extends JPanel {
    JTable table;
    TableModel model;
    JScrollPane scrollPane;
    GenericTableMenu menu;
    boolean debug;

    public GenericTable() {
        this.model = new DefaultTableModel();
        this.installTable();
    }

    public GenericTable(TableModel tableModel) {
        this.model = tableModel;
        this.installTable();
    }

    public TableModel getTableModel() {
        return this.model;
    }

    public void installTable() {
        this.debug = false;
        this.table = new JTable(this.model);
        this.menu = new GenericTableMenu(this);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = GenericTable.this.table.getSelectedRow();
                int n2 = GenericTable.this.table.getSelectedColumn();
                int n3 = mouseEvent.getClickCount();
                if (GenericTable.this.debug) {
                    System.out.println("--------------------------------------");
                    System.out.println("Mouse Event Detected");
                    System.out.println("Selected Row : " + n);
                    System.out.println("Selected Column : " + n2);
                    System.out.println("--------------------------------------");
                }
                if (n3 == 1 && (mouseEvent.getModifiers() & 0x10) == 16) {
                    GenericTable.this.click(n, n2);
                }
                if (n3 == 2 && (mouseEvent.getModifiers() & 0x10) == 16) {
                    GenericTable.this.doubleClick(n, n2);
                }
                if ((mouseEvent.getModifiers() & 4) == 4) {
                    GenericTable.this.menu.getPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    GenericTable.this.rightClick(n, n2);
                }
            }
        });
    }

    public void click(int n, int n2) {
        if (this.debug) {
            System.out.println("--------------------------------------");
            System.out.println("Simple Click Detected");
            System.out.println("Selected : row-> " + n + " column-> " + n2);
            System.out.println("--------------------------------------");
        }
    }

    public void doubleClick(int n, int n2) {
        if (this.debug) {
            System.out.println("--------------------------------------");
            System.out.println("Double Click Detected");
            System.out.println("Selected : row-> " + n + " column-> " + n2);
            System.out.println("--------------------------------------");
        }
    }

    public void rightClick(int n, int n2) {
        if (this.debug) {
            System.out.println("--------------------------------------");
            System.out.println("Right Click Detected");
            System.out.println("Selected : row-> " + n + " column-> " + n2);
            System.out.println("--------------------------------------");
        }
    }
}

