/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import madkit.MadChat.ChatMessage;
import madkit.MadChat.Chatter;
import madkit.MadChat.ChatterMessage;
import madkit.MadChat.CommandMessage;
import madkit.MadChat.Config;
import madkit.MadChat.ConfigChan;
import madkit.MadChat.ConfigChangeListener;
import madkit.MadChat.HTMLEditor;
import madkit.MadChat.MadChatHello;
import madkit.MadChat.SmileyTab;
import madkit.MadChat.WriteToolbar;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;

public class PvPanel
extends JPanel
implements ActionListener,
KeyListener,
MouseListener,
ConfigChangeListener {
    private HTMLEditor tZoneLecture = null;
    private JScrollPane scrollbarZLecture = null;
    private JScrollPane scrollbarZListeChatter = null;
    private JTextField tZoneEcriture = null;
    private WriteToolbar tWriteToolbar;
    private String nomChannel;
    private ConfigChan cfgChan;
    private Vector historique;
    private int tailleMaxHistorique;
    private int indexHistorique;
    private Chatter chatter;
    private Chatter me;
    String background;
    Config config;

    public PvPanel(Config config, Chatter chatter) {
        this("$" + chatter.getNom(), config, new ConfigChan("$" + chatter.getNom(), "Bienvenue sur le salon de discussion privee avec " + chatter.getNom(), "", false, false));
        this.chatter = chatter;
    }

    public PvPanel(String string, Config config, ConfigChan configChan) {
        this.config = config;
        this.config.addConfigChangeListener(this);
        this.historique = new Vector();
        this.tailleMaxHistorique = 20;
        this.indexHistorique = 1;
        this.me = new Chatter(this.config.getLogin(), false, this.config.getChatAgent().getAddress());
        this.nomChannel = string;
        this.cfgChan = configChan;
        this.background = this.config.getOsName().startsWith("Windows") ? "<body background=\"file:///" + this.config.getBackground() + "\">" : "<body background=\"file://" + this.config.getBackground() + "\">";
        this.setLayout(new BorderLayout());
        this.tZoneLecture = new HTMLEditor();
        this.tZoneLecture.setEditable(false);
        this.tZoneLecture.addMouseListener(this);
        this.tZoneLecture.insertHTML(this.background);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tZoneEcriture = new JTextField();
        this.tZoneEcriture.addKeyListener(this);
        this.tZoneEcriture.addActionListener(this);
        this.tWriteToolbar = new WriteToolbar(this.tZoneEcriture, config);
        this.tWriteToolbar.setFloatable(false);
        jPanel.add((Component)this.tWriteToolbar, "North");
        jPanel.add((Component)this.tZoneEcriture, "South");
        this.scrollbarZLecture = new JScrollPane(this.tZoneLecture, 20, 31);
        this.scrollbarZLecture.setWheelScrollingEnabled(true);
        this.add((Component)this.scrollbarZLecture, "Center");
        this.add((Component)jPanel, "South");
    }

    public void addChatter(Chatter chatter) {
        this.insertInfoMessage("" + chatter.getNom() + " vient de se connecter au channel", "#0000ff");
    }

    public void removeChatter(AgentAddress agentAddress) {
        if (this.getHim() != null) {
            this.insertInfoMessage("" + this.getHim().getNom() + " vient de quitter le channel", "#ff0000");
            this.chatter = null;
        }
    }

    public void updateChatterNick(AgentAddress agentAddress, String string) {
        if (this.chatter != null) {
            System.out.println("changement nick");
            String string2 = this.getHim().getNom();
            this.chatter.setNom(string);
            this.tZoneLecture.insertHTML("<font color =\"#FF0000\">" + string2 + " change de nom pour \"" + this.chatter.getNom() + "\" </font>");
        }
    }

    public void quit() {
        MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
        System.out.println("QUIT le channel $" + this.getMe().getNom());
        CommandMessage commandMessage = new CommandMessage(madChatHello.getAddress(), 30, "$" + this.getMe().getNom(), "$" + this.getMe().getNom());
        if (this.getHim() != null) {
            this.config.getChatAgent().sendMessage(this.getHim().getAdresse(), (Message)commandMessage);
        }
        if (this.tWriteToolbar.isSaveLog()) {
            try {
                FileWriter fileWriter = new FileWriter(this.config.getLogPath() + this.getNomChannel() + ".log", true);
                fileWriter.write(this.getConversation());
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void join() {
        MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
        Chatter chatter = new Chatter(this.config.getLogin(), false, madChatHello.getAddress());
        ChatterMessage chatterMessage = new ChatterMessage(chatter, this.getNomChannel());
    }

    public void insertChatMessage(String string, String string2) {
        if (this.getHim() != null) {
            String string3 = Integer.toHexString(this.tWriteToolbar.getCurrentColor().getRGB()).substring(2);
            string2 = this.filterHTML(string2);
            if (this.config.isTimestamp()) {
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                this.tZoneLecture.insertHTML("<font color=\"white\" size=2>&lt;" + string + " " + simpleDateFormat.format(date) + "&gt;</font> <font color=\"#" + string3 + "\" face=" + this.tWriteToolbar.getPolice() + " size=\"" + this.tWriteToolbar.getTaillePolice() + "\">" + string2 + "</font>");
            } else {
                this.tZoneLecture.insertHTML("<font color=\"white\" size=2>&lt;" + string + "&gt;</font><font color=\"#" + string3 + "\" face=" + this.tWriteToolbar.getPolice() + " size=\"" + this.tWriteToolbar.getTaillePolice() + "\">" + string2 + "</font>");
            }
            System.out.println("Message: " + string2);
        } else {
            this.insertInfoMessage("L'utilisateur " + this.chatter.getNom() + " n'est pas connecte sur ce channel.", "\"yellow\"");
        }
    }

    public void insertInfoMessage(String string, String string2) {
        string = this.filterHTML(string);
        this.tZoneLecture.insertHTML("<b><font color=\"" + string2 + "\">" + string + "</font></b>");
        System.out.println("Message: " + string);
    }

    private String filterHTML(String string) {
        String string2 = string.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\\[g\\]", "<b>");
        string2 = string2.replaceAll("\\[/g\\]", "</b>");
        string2 = string2.replaceAll("\\[i\\]", "<i>");
        string2 = string2.replaceAll("\\[/i\\]", "</i>");
        SmileyTab smileyTab = this.config.getSmileyTab();
        String[] stringArray = smileyTab.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = smileyTab.getPathBySmiley(stringArray[i]);
            if (string3 == null) continue;
            string3 = "<img src=\"" + string3 + "\">";
            int n = string2.indexOf(stringArray[i]);
            if (n == -1) continue;
            int n2 = stringArray[i].length();
            char[] cArray = string2.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n != -1) {
                stringBuffer.append(cArray, n3, n - n3);
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string2.indexOf(stringArray[i], n3);
            }
            stringBuffer.append(cArray, n3, cArray.length - n3);
            string2 = stringBuffer.toString();
        }
        System.out.println(string2);
        return string2;
    }

    public String getNomChannel() {
        return this.nomChannel;
    }

    public ConfigChan getConfigChan() {
        return this.cfgChan;
    }

    public void setConfigChan(ConfigChan configChan) {
        this.cfgChan = configChan;
    }

    public String getConversation() {
        return this.tZoneLecture.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tZoneEcriture) {
            String string = this.tZoneEcriture.getText();
            if (this.getHim() != null) {
                ChatMessage chatMessage = new ChatMessage(this.config.getLogin(), "$" + this.getHim().getNom(), string);
                ChatMessage chatMessage2 = new ChatMessage(this.config.getLogin(), "$" + this.getMe().getNom(), string);
                this.config.getChatAgent().sendMessage(this.getMe().getAdresse(), (Message)chatMessage);
                this.config.getChatAgent().sendMessage(this.getHim().getAdresse(), (Message)chatMessage2);
                if (this.historique.size() == this.tailleMaxHistorique) {
                    this.historique.remove(this.historique.size() - 1);
                }
                this.historique.add(0, string);
                this.indexHistorique = -1;
            } else {
                this.insertInfoMessage("La connexion avec votre correspondant a ?t? rompue.", "red");
            }
            this.tZoneEcriture.setText("");
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            System.out.println("Histo : " + this.indexHistorique + " " + (this.historique.size() - 1));
            if (this.indexHistorique < this.historique.size() - 1) {
                ++this.indexHistorique;
            }
            String string = (String)this.historique.get(this.indexHistorique);
            this.tZoneEcriture.setText(string);
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.indexHistorique > -1) {
                --this.indexHistorique;
            }
            String string = this.indexHistorique > -1 ? (String)this.historique.get(this.indexHistorique) : "";
            this.tZoneEcriture.setText(string);
        }
    }

    public Chatter getMe() {
        return this.me;
    }

    public Chatter getHim() {
        return this.chatter;
    }

    public void setHim(Chatter chatter) {
        this.chatter = chatter;
        this.insertInfoMessage(this.chatter.getNom() + " vient de rejoindre le chat prive.", "yellow");
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this.tZoneLecture || mouseEvent.getClickCount() == 2) {
            // empty if block
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void configChanged(String string) {
        if (string.equals("background")) {
            String string2 = this.tZoneLecture.getText();
            this.tZoneLecture.setText("");
            if (this.config.getOsName().startsWith("Windows")) {
                this.tZoneLecture.insertHTML("<body background=\"file:///" + this.config.getBackground() + "\">");
            } else {
                this.tZoneLecture.insertHTML("<body background=\"file://" + this.config.getBackground() + "\">");
            }
            this.tZoneEcriture.setText("");
            this.tZoneLecture.insertHTML(string2);
        } else if (string.equals("login")) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 31, this.getNomChannel(), this.config.getLogin());
            madChatHello.broadcastMessage("MadChat", this.getNomChannel(), "chatter", commandMessage);
        } else if (string.equals("theme")) {
            System.out.println("theme change");
        }
    }
}

