/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import madkit.MadChat.ChatterList;
import madkit.MadChat.Config;
import madkit.MadChat.FileChooserGUI;
import madkit.MadChat.MadChatHello;

public class PanneauConfig
extends JFrame
implements ActionListener {
    JTabbedPane tabbedChan;
    JPanel panelUser;
    GridBagLayout gridUser;
    GridBagLayout gridAffichage;
    GridBagLayout gridSysteme;
    JPanel panelAffichage;
    JPanel panelPartage;
    JPanel panelSysteme;
    JLabel nick;
    JLabel mail;
    JTextField nickEntry;
    JTextField mailEntry;
    JLabel Image;
    JLabel lang;
    JComboBox langEntry;
    JLabel theme;
    JComboBox themeEntry;
    JCheckBox timestamp;
    JLabel background;
    JTextField backgroundEntry;
    JButton fileBrowser;
    String backgroundPath;
    String oldBackground;
    JCheckBox checkServ;
    JButton bConfigServer;
    JCheckBox logAuto;
    JLabel log;
    JTextField logPath;
    JButton valid;
    private Config config;

    public PanneauConfig(Config config) {
        this.config = config;
        this.oldBackground = this.config.getBackground();
        System.out.println("old background = " + this.oldBackground);
        this.gridUser = new GridBagLayout();
        this.gridAffichage = new GridBagLayout();
        this.gridSysteme = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tabbedChan = new JTabbedPane();
        this.panelUser = new JPanel();
        this.panelAffichage = new JPanel();
        this.panelPartage = new JPanel(new BorderLayout());
        this.panelSysteme = new JPanel();
        this.nick = new JLabel(this.config.getLangProperty("PANEL_CONF_LABEL_NICKNAME"));
        this.nickEntry = new JTextField(this.config.getLogin(), 10);
        this.mail = new JLabel("Modifier le mail actuel : ");
        this.mailEntry = new JTextField(10);
        this.lang = new JLabel(this.config.getLangProperty("PANEL_CONF_LABEL_LANG"));
        this.langEntry = new JComboBox();
        File file = new File(this.config.getConfigPath() + "Lang");
        String[] stringArray = file.list();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].substring(0, stringArray[i].length() - 5);
            if (string.equals(this.config.getLang())) {
                n = i;
            }
            this.langEntry.addItem(string);
        }
        this.langEntry.setSelectedIndex(n);
        this.theme = new JLabel(this.config.getLangProperty("PANEL_CONF_LABEL_THEME"));
        this.themeEntry = new JComboBox();
        file = new File(this.config.getThemePath());
        String[] stringArray2 = file.list();
        n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals(this.config.getTheme())) {
                n = i;
            }
            this.themeEntry.addItem(stringArray2[i]);
        }
        this.themeEntry.setSelectedIndex(n);
        this.themeEntry.addActionListener(this);
        this.background = new JLabel(this.config.getLangProperty("PANEL_CONF_LABEL_BACKGROUND"));
        this.backgroundEntry = new JTextField(this.config.getBackground(), 20);
        this.fileBrowser = new JButton(this.config.getLangProperty("PANEL_CONF_BROWSE"));
        this.timestamp = new JCheckBox(this.config.getLangProperty("PANEL_CONF_LABEL_TIMESTAMP"), this.config.isTimestamp());
        this.checkServ = new JCheckBox(this.config.getLangProperty("PANEL_CONF_LABEL_LAUNCH_SHARE"), this.config.isShare());
        this.checkServ.addActionListener(this);
        this.bConfigServer = new JButton(this.config.getLangProperty("PANEL_CONF_LABEL_CONFIG_SHARE"));
        this.bConfigServer.addActionListener(this);
        this.panelPartage.add((Component)this.checkServ, "North");
        this.panelPartage.add((Component)this.bConfigServer, "South");
        this.logAuto = new JCheckBox(this.config.getLangProperty("PANEL_CONF_LABEL_SAVE_LOG"), this.config.isLogAuto());
        this.log = new JLabel(this.config.getLangProperty("PANEL_CONF_LABEL_LOG_PATH"));
        this.logPath = new JTextField(this.config.getLogPath());
        this.logPath.setPreferredSize(new Dimension(180, 18));
        this.panelUser.setLayout(this.gridUser);
        this.gridUser.setConstraints(this.nick, gridBagConstraints);
        this.panelUser.add(this.nick);
        gridBagConstraints.gridwidth = 0;
        this.gridUser.setConstraints(this.nickEntry, gridBagConstraints);
        this.panelUser.add(this.nickEntry);
        gridBagConstraints.gridwidth = -1;
        this.gridUser.setConstraints(this.mail, gridBagConstraints);
        this.panelUser.add(this.mail);
        this.gridUser.setConstraints(this.mailEntry, gridBagConstraints);
        this.panelUser.add(this.mailEntry);
        gridBagConstraints.fill = 11;
        gridBagConstraints.weightx = 1.0;
        this.panelAffichage.setLayout(this.gridAffichage);
        this.gridAffichage.setConstraints(this.lang, gridBagConstraints);
        this.panelAffichage.add(this.lang);
        gridBagConstraints.gridwidth = 0;
        this.gridAffichage.setConstraints(this.langEntry, gridBagConstraints);
        this.panelAffichage.add(this.langEntry);
        gridBagConstraints.gridwidth = -1;
        this.gridAffichage.setConstraints(this.theme, gridBagConstraints);
        this.panelAffichage.add(this.theme);
        gridBagConstraints.gridwidth = 0;
        this.gridAffichage.setConstraints(this.themeEntry, gridBagConstraints);
        this.panelAffichage.add(this.themeEntry);
        gridBagConstraints.gridwidth = -1;
        this.gridAffichage.setConstraints(this.background, gridBagConstraints);
        this.panelAffichage.add(this.background);
        gridBagConstraints.gridwidth = 0;
        this.gridAffichage.setConstraints(this.backgroundEntry, gridBagConstraints);
        this.panelAffichage.add(this.backgroundEntry);
        this.gridAffichage.setConstraints(this.fileBrowser, gridBagConstraints);
        this.panelAffichage.add(this.fileBrowser);
        this.fileBrowser.addActionListener(this);
        this.gridAffichage.setConstraints(this.timestamp, gridBagConstraints);
        this.panelAffichage.add(this.timestamp);
        gridBagConstraints.fill = 11;
        gridBagConstraints.weightx = 1.0;
        this.panelSysteme.setLayout(this.gridSysteme);
        this.gridSysteme.setConstraints(this.logAuto, gridBagConstraints);
        this.panelSysteme.add(this.logAuto);
        gridBagConstraints.gridwidth = 0;
        this.gridSysteme.setConstraints(this.log, gridBagConstraints);
        this.panelSysteme.add(this.log);
        this.gridSysteme.setConstraints(this.logPath, gridBagConstraints);
        this.panelSysteme.add(this.logPath);
        this.tabbedChan.add((Component)this.panelUser, this.config.getLangProperty("PANEL_CONF_TAB_USER"));
        this.tabbedChan.add((Component)this.panelAffichage, this.config.getLangProperty("PANEL_CONF_TAB_DISPLAY"));
        this.tabbedChan.add((Component)this.panelPartage, this.config.getLangProperty("PANEL_CONF_TAB_SHARE"));
        this.tabbedChan.add((Component)this.panelSysteme, this.config.getLangProperty("PANEL_CONF_TAB_SYSTEM"));
        this.getContentPane().add((Component)this.tabbedChan, "North");
        this.valid = new JButton(this.config.getLangProperty("PANEL_CONF_OK"));
        this.getContentPane().add((Component)this.valid, "South");
        this.valid.addActionListener(this);
        this.pack();
    }

    public boolean isBackgroundChanged() {
        return !this.config.getBackground().equals(this.oldBackground);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.valid) {
            System.out.println(this.nickEntry.getText());
            if (!this.nickEntry.getText().startsWith("@") && !this.nickEntry.getText().startsWith("+")) {
                MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
                ChatterList chatterList = madChatHello.getDisplay().getChatListInChan("default");
                if (!this.nickEntry.getText().equals("")) {
                    if (chatterList.getByLogin(this.nickEntry.getText()) == null) {
                        this.config.setLogin(this.nickEntry.getText());
                    } else if (!this.nickEntry.getText().equals(this.config.getLogin())) {
                        madChatHello.getDisplay().getCurrentChan().insertInfoMessage("Config : Ce nick est deja en cours d'utilisation, veuillez en choisir un autre.", "yellow");
                    }
                } else {
                    madChatHello.getDisplay().getCurrentChan().insertInfoMessage("Config : Le nick \"" + this.nickEntry.getText() + "\" n'est pas valide.", "yellow");
                }
                this.config.setTimestamp(this.timestamp.isSelected());
                this.config.setLogAuto(this.logAuto.isSelected());
                this.config.setTheme(this.themeEntry.getSelectedItem().toString());
                this.config.setBackground(this.backgroundEntry.getText());
                this.config.setShare(this.checkServ.isSelected());
                this.config.setLang(this.langEntry.getSelectedItem().toString());
                this.config.save();
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.bConfigServer) {
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(this.config.getSenderAgent().getDisplay());
            jFrame.pack();
            jFrame.show();
        } else if (actionEvent.getSource() == this.fileBrowser) {
            FileChooserGUI fileChooserGUI = new FileChooserGUI(this.config);
            fileChooserGUI.setSize(300, 200);
            this.backgroundEntry.setText(fileChooserGUI.getBackgroundPath());
        } else if (actionEvent.getSource() == this.themeEntry) {
            this.backgroundEntry.setText(this.config.getThemePath() + (String)this.themeEntry.getSelectedItem() + this.config.getFileSeparator() + "background.jpg");
        }
    }
}

