/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.util.Date;
import java.util.Vector;
import javax.swing.JPanel;
import madkit.MadChat.ChatMessage;
import madkit.MadChat.ChatterMessage;
import madkit.MadChat.CommandMessage;
import madkit.MadChat.Config;
import madkit.MadChat.InfoServMessage;
import madkit.MadChat.ListMessage;
import madkit.MadChat.MadChat;
import madkit.MadChat.PingMessage;
import madkit.MadChat.PvPanel;
import madkit.MadChat.ShareServerMessage;
import madkit.MadChat.share.RequestTreeMessage;
import madkit.MadChat.share.SenderAgent;
import madkit.MadChat.share.ShareAgent;
import madkit.MadChat.share.TreeMessage;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;

public class MadChatHello
extends Agent {
    Config configuration;
    String myCommunity = "MadChat";
    String myGroup = "default";
    String myRole = "chatter";
    MadChat display;
    boolean alive = true;

    public void initGUI() {
        this.configuration = new Config(this);
        SenderAgent senderAgent = new SenderAgent();
        ShareAgent shareAgent = new ShareAgent();
        this.configuration.setSenderAgent(senderAgent);
        this.configuration.setShareAgent(shareAgent);
        if (this.configuration.isShare()) {
            this.launchAgent((AbstractAgent)senderAgent, "share", false);
        }
        this.launchAgent((AbstractAgent)shareAgent, "share", false);
        this.display = new MadChat(this.configuration);
        this.setGUIObject(this.display);
    }

    public void activate() {
        int n = this.createGroup(true, this.myCommunity, this.myGroup, null, null);
        if (n == 1) {
            this.println("I create the group " + this.myGroup + " in community " + this.myCommunity);
        } else if (n == -1) {
            this.println("The group has already been created");
        } else {
            this.println("Cannot create the group");
        }
        this.display.addChan("default");
    }

    public void live() {
        this.println("Hello world...");
        while (this.alive) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public MadChat getDisplay() {
        return this.display;
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleMessage(Message message) {
        Message message2;
        this.println("On est ds le HandleMsg");
        if (message instanceof ChatMessage) {
            this.println("instance of chatmsg");
            message2 = (ChatMessage)message;
            this.display.insertChatMsgInChan(message2.getChannel(), message2.getChatter(), message2.getContent());
        } else if (message instanceof PingMessage) {
            this.println("instance of pingmsg");
            message2 = (PingMessage)message;
            Date date = new Date();
            long l = date.getTime() - message2.getTime();
            System.out.println("Time in ms : " + l);
            this.display.insertInfoMsgInChan(message2.getChannel(), "[- " + message2.getChatter() + " PING reply : " + l + " ms -]", "red");
        } else if (message instanceof CommandMessage) {
            this.println("instance of commandMessage");
            message2 = (CommandMessage)message;
            switch (message2.getMessageType()) {
                case 0: {
                    this.println("renvoie la liste");
                    ListMessage listMessage = new ListMessage(this.display.getChatterListInChan(message2.getChannel()), message2.getChannel());
                    this.sendMessage(message2.getSource(), listMessage);
                    break;
                }
                case 30: {
                    this.println(message2.getSource() + " va quitter le salon " + message2.getData());
                    this.display.removeChatterInChan(message2.getChannel(), message2.getSource());
                    break;
                }
                case 31: {
                    this.println("change de nick " + message2.getData());
                    this.display.setChatterNickInChan(message2.getChannel(), message2.getSource(), message2.getData());
                    break;
                }
                case 1: {
                    this.println("demande mon serveur de fichier");
                    ShareServerMessage shareServerMessage = new ShareServerMessage(this.getAddress(), message2.getChannel(), null);
                    if (this.configuration.isShareRunning()) {
                        shareServerMessage.setShareServer(this.configuration.getSenderAgent().getAddress());
                    }
                    this.sendMessage(message2.getSource(), shareServerMessage);
                    break;
                }
                case 2: {
                    this.println("demande info chan");
                    InfoServMessage infoServMessage = new InfoServMessage(message2.getChannel(), this.display.getConfigChan(message2.getChannel()));
                    this.sendMessage(message2.getSender(), infoServMessage);
                    break;
                }
                case 32: {
                    this.println("message : OP " + message2.getData());
                    this.display.setOP(message2.getChannel(), message2.getSource(), message2.getData(), true);
                    break;
                }
                case 33: {
                    this.println("message : DEOP");
                    this.display.setOP(message2.getChannel(), message2.getSource(), message2.getData(), false);
                    break;
                }
                case 34: {
                    this.println("message : SLAP");
                    this.display.slapInChan(message2.getChannel(), message2.getSource(), message2.getData());
                    break;
                }
                case 35: {
                    this.println("message : Kick");
                    this.display.kickInChan(message2.getChannel(), message2.getSource(), message2.getData());
                    break;
                }
                case 36: {
                    this.println("message : PV");
                    System.out.println(message2.getChannel());
                    if (this.display.existChan(message2.getChannel())) {
                        JPanel jPanel = this.display.getChan(message2.getChannel());
                        if (!(jPanel instanceof PvPanel)) break;
                        ((PvPanel)jPanel).setHim(this.display.getChatListInChan("default").getByLogin(message2.getData()));
                        break;
                    }
                    this.display.addChanPV(this.configuration, this.display.getChatListInChan("default").getByLogin(message2.getData()));
                    break;
                }
                case 37: {
                    this.println("message : PING");
                    PingMessage pingMessage = new PingMessage(message2.getTime(), message2.getChannel(), this.configuration.getLogin());
                    this.sendMessage(message2.getSender(), pingMessage);
                    break;
                }
                case 38: {
                    this.println("message : WHOIS");
                    break;
                }
            }
        } else if (message instanceof ShareServerMessage) {
            this.println("======================>shareServerMessage detected");
            message2 = (ShareServerMessage)message;
            if (message2.getShareServer() != null) {
                this.sendMessage(message2.getShareServer(), new RequestTreeMessage("request-tree"));
            } else {
                this.display.insertInfoMsgInChan(message2.getChannel(), "Aucun fichier partag?", "#ff0000");
            }
        }
        if (message instanceof TreeMessage) {
            message2 = ((TreeMessage)message).getSender();
            System.out.println("(client) TreeMessage received");
            String string = ((TreeMessage)message).getSender().getKernel().getHost().toString();
            DirEntry dirEntry = ((TreeMessage)message).getDir();
            Vector vector = dirEntry.getVect();
            this.println("adresse==============================>" + message2);
            this.display.addServerPanel(dirEntry, ((TreeMessage)message).getSender());
            return;
        }
        if (message instanceof InfoServMessage) {
            this.println("instance of InfoServMessage");
            message2 = (InfoServMessage)message;
            this.display.setConfigInChan(message2.getChan(), message2.getConfigChan());
            this.display.insertInfoMsgInChan(message2.getChan(), "Le topic du channel viens de changer!", "#ffffff");
            return;
        }
        if (message instanceof ListMessage) {
            this.println("instance of lsitMessage");
            message2 = (ListMessage)message;
            this.display.setChatterListInChan(message2.getChannel(), message2.getChatterList());
            return;
        }
        if (!(message instanceof ChatterMessage)) return;
        this.println("instance of ChatterMessage");
        message2 = (ChatterMessage)message;
        this.display.addChatterInChan(message2.getChannel(), message2.getChatter());
    }

    public void sendMessageToAnyone(String string, String string2, String string3, Message message) {
        AgentAddress[] agentAddressArray = this.getAgentsWithRole(string, string2, string3);
        if (agentAddressArray.length > 1) {
            int n;
            for (n = 0; agentAddressArray[n] == this.getAddress() && n < agentAddressArray.length; ++n) {
            }
            this.sendMessage(agentAddressArray[n], message);
            System.out.println("envoie ? " + agentAddressArray[n] + " " + agentAddressArray[n]);
        } else {
            this.sendMessage(string, string2, string3, message);
            System.out.println("envoie au hasard ");
        }
    }

    public void end() {
        this.configuration.save();
        this.display.closeAllChannel();
        this.configuration.getSenderAgent().saveDirectory();
        this.killAgent((AbstractAgent)this.configuration.getSenderAgent());
        this.killAgent((AbstractAgent)this.configuration.getShareAgent());
    }
}

