/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import madkit.MadChat.ChatPanel;
import madkit.MadChat.Chatter;
import madkit.MadChat.ChatterList;
import madkit.MadChat.CloseAndMaxTabbedPane.CloseAndMaxTabbedPane;
import madkit.MadChat.CloseAndMaxTabbedPane.CloseListener;
import madkit.MadChat.Config;
import madkit.MadChat.ConfigChan;
import madkit.MadChat.MainMenu;
import madkit.MadChat.MainToolbar;
import madkit.MadChat.PvPanel;
import madkit.MadChat.share.ServerPanel;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AgentAddress;

public class MadChat
extends JRootPane
implements CloseListener {
    public static final String ApplicationImagePath = new File(".").getAbsolutePath();
    private CloseAndMaxTabbedPane tabbedChan;
    private MainMenu mainMenu;
    private MainToolbar mainTool;
    private JPanel tmpPanel;
    private Config configuration;

    public MadChat(Config config) {
        this.configuration = config;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.tabbedChan = new CloseAndMaxTabbedPane(false);
        this.tabbedChan.setMaxIcon(false);
        this.tabbedChan.addCloseListener(this);
        this.mainTool = new MainToolbar(this, this.configuration);
        this.mainTool.setFloatable(false);
        this.mainMenu = new MainMenu(this.tabbedChan, this.configuration);
        this.mainMenu.setPreferredSize(new Dimension(640, 30));
        this.setJMenuBar(this.mainMenu);
        jPanel.add((Component)this.mainTool, "North");
        jPanel.add(this.tabbedChan);
        this.setPreferredSize(new Dimension(640, 480));
    }

    public void insertChatMsgInChan(String string, String string2, String string3) {
        System.out.println("-------------------------------- index de " + string + " = ");
        int n = this.tabbedChan.indexOfTab(string);
        System.out.println(n);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            if (component instanceof ChatPanel) {
                ChatPanel chatPanel = (ChatPanel)component;
                chatPanel.insertChatMessage(string2, string3);
            } else {
                System.out.println("MadChat : On est dans un PV panel");
                PvPanel pvPanel = (PvPanel)component;
                pvPanel.insertChatMessage(string2, string3);
            }
        }
    }

    public void insertInfoMsgInChan(String string, String string2, String string3) {
        System.out.println("-------------------------------- index de " + string + " = ");
        int n = this.tabbedChan.indexOfTab(string);
        System.out.println(n);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.insertInfoMessage(string2, string3);
        }
    }

    public ConfigChan getConfigChan(String string) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component == null) {
            return null;
        }
        ChatPanel chatPanel = (ChatPanel)component;
        return chatPanel.getConfigChan();
    }

    public Chatter[] getChatterListInChan(String string) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component == null) {
            return null;
        }
        ChatPanel chatPanel = (ChatPanel)component;
        return chatPanel.getChatterList();
    }

    public ChatterList getChatListInChan(String string) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component == null) {
            return null;
        }
        ChatPanel chatPanel = (ChatPanel)component;
        return chatPanel.getChatList();
    }

    public void slapInChan(String string, AgentAddress agentAddress, String string2) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.insertInfoMessage(chatPanel.getChatList().getByAgentAddress(agentAddress).getNom() + " envoie une truite dans la gueulle de " + string2, "green");
        }
    }

    public void kickInChan(String string, AgentAddress agentAddress, String string2) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.insertInfoMessage(string2 + " a ete kicke par " + chatPanel.getChatList().getByAgentAddress(agentAddress).getNom(), "red");
        }
    }

    public void setChatterListInChan(String string, Chatter[] chatterArray) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.setChatterList(chatterArray);
        }
    }

    public void setChatterNickInChan(String string, AgentAddress agentAddress, String string2) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        System.out.println("Index de " + string + " : " + n + " " + string2);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.updateChatterNick(agentAddress, string2);
        }
    }

    public void addChatterInChan(String string, Chatter chatter) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.addChatter(chatter);
        }
    }

    public void removeChatterInChan(String string, AgentAddress agentAddress) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            if (component instanceof ChatPanel) {
                ChatPanel chatPanel = (ChatPanel)component;
                chatPanel.removeChatter(agentAddress);
            } else {
                PvPanel pvPanel = (PvPanel)component;
                pvPanel.removeChatter(agentAddress);
            }
        }
    }

    public void setOP(String string, AgentAddress agentAddress, String string2, boolean bl) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.getChatList().getByLogin(string2).setOp(bl);
            System.out.println(string2 + " est maintenant OP " + bl);
            if (bl) {
                chatPanel.insertInfoMessage(chatPanel.getChatList().getByAgentAddress(agentAddress).getNom() + " donne le status d'operateur a " + string2, "#000000");
            } else {
                chatPanel.insertInfoMessage(chatPanel.getChatList().getByAgentAddress(agentAddress).getNom() + " enleve le status d'operateur a " + string2, "#000000");
            }
        }
    }

    public void closeAllChannel() {
        Component[] componentArray = this.tabbedChan.getComponents();
        for (int i = 0; i < this.tabbedChan.getTabCount(); ++i) {
            Component component = this.tabbedChan.getComponentAt(i);
            if (!(component instanceof ChatPanel)) continue;
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.quit();
        }
    }

    public void addChan(String string) {
        ChatPanel chatPanel = new ChatPanel(string, this.configuration);
        this.tabbedChan.addTab(string, chatPanel);
        chatPanel.join();
    }

    public void addChanPV(Config config, Chatter chatter) {
        PvPanel pvPanel = new PvPanel(config, chatter);
        this.tabbedChan.addTab("$" + chatter.getNom(), pvPanel);
    }

    public void addChan(String string, String string2) {
        ConfigChan configChan = new ConfigChan(string, "", string2, false, false);
        ChatPanel chatPanel = new ChatPanel(string, this.configuration, configChan);
        this.tabbedChan.addTab(string, chatPanel);
        chatPanel.join();
    }

    public void addServerPanel(DirEntry dirEntry, AgentAddress agentAddress) {
        ServerPanel serverPanel = new ServerPanel(this, dirEntry, this.configuration.getShareAgent(), agentAddress);
        this.tabbedChan.addTab("%" + agentAddress.getKernel().getHost().toString(), serverPanel);
        this.repaint();
    }

    public void removeServerPanel() {
        this.tabbedChan.removeTabAt(this.tabbedChan.getSelectedIndex());
        this.repaint();
    }

    public ConfigChan getCurrentConfigChan() {
        Component component = this.tabbedChan.getSelectedComponent();
        if (component != null && component instanceof ChatPanel) {
            ChatPanel chatPanel = (ChatPanel)component;
            return chatPanel.getConfigChan();
        }
        return null;
    }

    public ChatPanel getCurrentChan() {
        Component component = this.tabbedChan.getSelectedComponent();
        if (component != null && component instanceof ChatPanel) {
            ChatPanel chatPanel = (ChatPanel)component;
            return chatPanel;
        }
        return null;
    }

    public void setConfigInChan(String string, ConfigChan configChan) {
        int n = this.tabbedChan.indexOfTab(string);
        Component component = this.tabbedChan.getComponentAt(n);
        if (component != null) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.setConfigChan(configChan);
        }
    }

    public String[] getAllChan() {
        String[] stringArray = new String[this.tabbedChan.getTabCount()];
        for (int i = 0; i < this.tabbedChan.getTabCount(); ++i) {
            stringArray[i] = this.tabbedChan.getTitleAt(i);
            System.out.println("tab " + i + " : " + stringArray[i]);
        }
        return stringArray;
    }

    public boolean isChan(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < this.tabbedChan.getTabCount(); ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean existChan(String string) {
        boolean bl = false;
        for (int i = 0; i < this.tabbedChan.getTabCount(); ++i) {
            System.out.println("nom du chan : " + this.tabbedChan.getTitleAt(i));
            if (!this.tabbedChan.getTitleAt(i).equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    public JPanel getChan(String string) {
        for (int i = 0; i < this.tabbedChan.getTabCount(); ++i) {
            System.out.println("nom du chan : " + this.tabbedChan.getTitleAt(i));
            if (!this.tabbedChan.getTitleAt(i).equals(string)) continue;
            return (JPanel)this.tabbedChan.getComponentAt(i);
        }
        return null;
    }

    public void closeOperation(MouseEvent mouseEvent) {
        Component component = this.tabbedChan.getSelectedComponent();
        if (component instanceof ChatPanel) {
            ChatPanel chatPanel = (ChatPanel)component;
            if (!chatPanel.getNomChannel().equals("default")) {
                chatPanel.quit();
                this.tabbedChan.remove(this.tabbedChan.getSelectedIndex());
            }
        } else if (component instanceof PvPanel) {
            PvPanel pvPanel = (PvPanel)component;
            pvPanel.quit();
            this.tabbedChan.remove(this.tabbedChan.getSelectedIndex());
        } else {
            this.tabbedChan.remove(this.tabbedChan.getSelectedIndex());
        }
    }
}

