/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import madkit.MadChat.ChanInfoAgent;
import madkit.MadChat.Config;
import madkit.MadChat.ConfigChan;
import madkit.MadChat.MadChat;
import madkit.MadChat.MyTableModel;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;

public class JDialogChanList
extends JDialog
implements ActionListener {
    private JPanel panelChan;
    private JLabel label;
    private JComboBox comboChan;
    private JButton valid;
    private JButton cancel;
    private JButton refresh;
    private Config config;
    private JTable table;
    private MadChat chat;
    private ConfigChan cfgChan;
    private MyTableModel tm;

    public JDialogChanList(MadChat madChat, Config config) {
        this.config = config;
        this.chat = madChat;
        String[] stringArray = new String[]{this.config.getLangProperty("PANEL_CHANLIST_TABLE_JOIN"), this.config.getLangProperty("PANEL_CHANLIST_TABLE_NAME"), this.config.getLangProperty("PANEL_CHANLIST_TABLE_TOPIC"), this.config.getLangProperty("PANEL_CHANLIST_TABLE_PASSWORD"), this.config.getLangProperty("PANEL_CHANLIST_TABLE_CONNECTED")};
        Object[][] objectArray = new String[][]{{"", "", "", "", ""}};
        this.tm = new MyTableModel(stringArray, objectArray);
        this.panelChan = new JPanel(new BorderLayout());
        this.valid = new JButton(this.config.getLangProperty("PANEL_CHANLIST_OK"));
        this.valid.addActionListener(this);
        this.cancel = new JButton(this.config.getLangProperty("PANEL_CHANLIST_CANCEL"));
        this.cancel.addActionListener(this);
        this.refresh = new JButton(this.config.getLangProperty("PANEL_CHANLIST_REFRESH"));
        this.refresh.addActionListener(this);
        this.label = new JLabel(this.config.getLangProperty("PANEL_CHANLIST_LABEL_CHANLIST"));
        this.table = new JTable(this.tm);
        this.table.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 40));
        this.table.setPreferredSize(new Dimension(500, 200));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(135);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(15);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(10);
        this.panelChan.add((Component)this.label, "North");
        this.panelChan.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.refresh);
        jPanel.add(this.valid);
        jPanel.add(this.cancel);
        this.panelChan.add((Component)jPanel, "South");
        this.getContentPane().add(this.panelChan);
        this.setSize(500, 250);
        ChanInfoAgent chanInfoAgent = new ChanInfoAgent(this.tm, this.config);
        this.config.getChatAgent().launchAgent((AbstractAgent)chanInfoAgent, "UpdateChan", false);
        this.show();
    }

    public Object[][] initTable() {
        Agent agent = this.config.getChatAgent();
        String[] stringArray = agent.getExistingGroups("MadChat");
        Object[][] objectArray = new Object[stringArray.length][5];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("%") || stringArray[i].startsWith("$")) {
                System.out.println(stringArray[i] + " est prive");
                continue;
            }
            objectArray[i][0] = new Boolean(false);
            objectArray[i][1] = stringArray[i];
            objectArray[i][2] = this.cfgChan.getTopic();
            objectArray[i][3] = this.cfgChan.getPassword();
            objectArray[i][4] = new Integer(agent.getAgentsWithRole("MadChat", stringArray[i], "chatter").length);
        }
        return objectArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.valid) {
            for (int i = 0; i < this.tm.getRowCount(); ++i) {
                Boolean bl;
                Object object = this.tm.getValueAt(i, 0);
                if (!(object instanceof Boolean) || !(bl = (Boolean)this.tm.getValueAt(i, 0)).booleanValue()) continue;
                this.chat.addChan((String)this.tm.getValueAt(i, 1));
                System.out.println("chan cree !");
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.cancel) {
            this.dispose();
        } else if (actionEvent.getSource() == this.refresh) {
            ChanInfoAgent chanInfoAgent = new ChanInfoAgent(this.tm, this.config);
            this.config.getChatAgent().launchAgent((AbstractAgent)chanInfoAgent, "UpdateChan", false);
        }
    }
}

