/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.CloseAndMaxTabbedPane;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;
import madkit.MadChat.CloseAndMaxTabbedPane.CloseListener;
import madkit.MadChat.CloseAndMaxTabbedPane.CloseTabPaneEnhancedUI;
import madkit.MadChat.CloseAndMaxTabbedPane.CloseTabPaneUI;
import madkit.MadChat.CloseAndMaxTabbedPane.DoubleClickListener;
import madkit.MadChat.CloseAndMaxTabbedPane.MaxListener;
import madkit.MadChat.CloseAndMaxTabbedPane.PopupOutsideListener;

public class CloseAndMaxTabbedPane
extends JTabbedPane {
    private int overTabIndex = -1;
    private CloseTabPaneUI paneUI;

    public CloseAndMaxTabbedPane(boolean bl) {
        super.setTabLayoutPolicy(1);
        this.paneUI = bl ? new CloseTabPaneEnhancedUI() : new CloseTabPaneUI();
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    public boolean isMaxEnabled() {
        return this.paneUI.isMaxEnabled();
    }

    public void setTabLayoutPolicy(int n) {
    }

    public void setTabPlacement(int n) {
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
    }

    public void setCloseIcon(boolean bl) {
        this.paneUI.setCloseIcon(bl);
    }

    public void setMaxIcon(boolean bl) {
        this.paneUI.setMaxIcon(bl);
    }

    public void detachTab(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            return;
        }
        final JFrame jFrame = new JFrame();
        Window window = SwingUtilities.windowForComponent(this);
        final int n2 = n;
        final JComponent jComponent = (JComponent)this.getComponentAt(n2);
        final Icon icon = this.getIconAt(n2);
        final String string = this.getTitleAt(n2);
        final String string2 = this.getToolTipTextAt(n2);
        final Border border = jComponent.getBorder();
        this.removeTabAt(n);
        jComponent.setPreferredSize(jComponent.getSize());
        jFrame.setTitle(string);
        jFrame.getContentPane().add(jComponent);
        jFrame.setLocation(window.getLocation());
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                CloseAndMaxTabbedPane.this.insertTab(string, icon, jComponent, string2, Math.min(n2, CloseAndMaxTabbedPane.this.getTabCount()));
                jComponent.setBorder(border);
                CloseAndMaxTabbedPane.this.setSelectedComponent(jComponent);
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            public void windowGainedFocus(WindowEvent windowEvent) {
                this.start = System.currentTimeMillis();
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                this.end = System.currentTimeMillis();
                long l = this.end - this.start;
                if (l < 100L) {
                    jFrame.toFront();
                }
                jFrame.removeWindowFocusListener(this);
            }
        };
        jFrame.addWindowFocusListener(windowFocusListener);
        jFrame.show();
        jFrame.toFront();
    }

    public synchronized void addCloseListener(CloseListener closeListener) {
        this.listenerList.add(CloseListener.class, closeListener);
    }

    public synchronized void addMaxListener(MaxListener maxListener) {
        this.listenerList.add(MaxListener.class, maxListener);
    }

    public synchronized void addDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.listenerList.add(DoubleClickListener.class, doubleClickListener);
    }

    public synchronized void addPopupOutsideListener(PopupOutsideListener popupOutsideListener) {
        this.listenerList.add(PopupOutsideListener.class, popupOutsideListener);
    }

    public synchronized void removeCloseListener(CloseListener closeListener) {
        this.listenerList.remove(CloseListener.class, closeListener);
    }

    public synchronized void removeMaxListener(MaxListener maxListener) {
        this.listenerList.remove(MaxListener.class, maxListener);
    }

    public synchronized void removeDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.listenerList.remove(DoubleClickListener.class, doubleClickListener);
    }

    public synchronized void removePopupOutsideListener(PopupOutsideListener popupOutsideListener) {
        this.listenerList.remove(PopupOutsideListener.class, popupOutsideListener);
    }

    public void fireCloseTabEvent(MouseEvent mouseEvent, int n) {
        this.overTabIndex = n;
        EventListener[] eventListenerArray = this.getListeners(CloseListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((CloseListener)eventListenerArray[i]).closeOperation(mouseEvent);
        }
    }

    public void fireMaxTabEvent(MouseEvent mouseEvent, int n) {
        this.overTabIndex = n;
        EventListener[] eventListenerArray = this.getListeners(MaxListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MaxListener)eventListenerArray[i]).maxOperation(mouseEvent);
        }
    }

    public void fireDoubleClickTabEvent(MouseEvent mouseEvent, int n) {
        this.overTabIndex = n;
        EventListener[] eventListenerArray = this.getListeners(DoubleClickListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((DoubleClickListener)eventListenerArray[i]).doubleClickOperation(mouseEvent);
        }
    }

    public void firePopupOutsideTabEvent(MouseEvent mouseEvent) {
        this.overTabIndex = -1;
        EventListener[] eventListenerArray = this.getListeners(PopupOutsideListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((PopupOutsideListener)eventListenerArray[i]).popupOutsideOperation(mouseEvent);
        }
    }
}

