/*
 * Decompiled with CFR 0.152.
 */
package jsynedit;

import gnu.GUIUtilities;
import gnu.search.SearchHighlight;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import jedit.syntax.SyntaxStyle;
import jedit.textarea.JEditTextArea;
import jedit.textarea.TextAreaPainter;
import jsynedit.AbstractEditorPanel;
import jsynedit.JSyneditInputHandler;
import jsynedit.UndoComponent;

public class AbstractDoc
extends JEditTextArea {
    protected UndoComponent undo;
    private boolean wrap;
    private String currentFile;
    private SearchHighlight searchHighlight;
    private AbstractEditorPanel editor;
    private JSyneditInputHandler inputHandler = new JSyneditInputHandler();
    private String fontName = "Monospaced";
    private int fontStyle = 0;
    private int fontSize = 12;

    public AbstractDoc() {
        this.inputHandler.addDefaultKeyBindings();
        this.setInputHandler(this.inputHandler);
        this.undo = new UndoComponent();
        this.wrap = false;
        this.getDocument().addUndoableEditListener(this.undo);
        this.currentFile = null;
        this.setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
    }

    public void undo() {
        this.undo.undo();
    }

    public void redo() {
        this.undo.redo();
    }

    public void initSearchHighlight() {
        if (this.searchHighlight == null) {
            this.searchHighlight = new SearchHighlight();
            this.getPainter().addCustomHighlight(this.searchHighlight);
        }
    }

    public SearchHighlight getSearchHighlight() {
        return this.searchHighlight;
    }

    public File getFile() {
        return this.currentFile == null ? null : new File(this.currentFile);
    }

    public AbstractEditorPanel getEditor() {
        return this.editor;
    }

    public void setEditor(AbstractEditorPanel abstractEditorPanel) {
        this.editor = abstractEditorPanel;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String string) {
        this.currentFile = string;
    }

    public void loadTextAreaProperties() {
        try {
            this.setElectricScroll(Integer.parseInt(AbstractEditorPanel.getProperty("editor.autoScroll")));
        }
        catch (NumberFormatException numberFormatException) {
            this.setElectricScroll(0);
        }
        String string = AbstractEditorPanel.getProperty("editor.newLine");
        if (string == null) {
            AbstractEditorPanel.setProperty("editor.newLine", System.getProperty("line.separator"));
        }
        try {
            this.setFontSize(Integer.parseInt(AbstractEditorPanel.getProperty("editor.fontSize")));
        }
        catch (NumberFormatException numberFormatException) {
            this.setFontSize(12);
            AbstractEditorPanel.setProperty("editor.fontSize", "12");
        }
        try {
            this.setFontSize(Integer.parseInt(AbstractEditorPanel.getProperty("fontSize")));
        }
        catch (NumberFormatException numberFormatException) {
            this.setFontSize(12);
            AbstractEditorPanel.setProperty("fontSize", "12");
        }
        try {
            this.setFontStyle(Integer.parseInt(AbstractEditorPanel.getProperty("fontStyle")));
        }
        catch (NumberFormatException numberFormatException) {
            this.setFontStyle(0);
            AbstractEditorPanel.setProperty("fontStyle", "0");
        }
        this.setFontName(AbstractEditorPanel.getProperty("fontName"));
        TextAreaPainter textAreaPainter = this.getPainter();
        textAreaPainter.setLineHighlightEnabled(AbstractEditorPanel.getBooleanProperty("lineHighlight"));
        textAreaPainter.setEOLMarkersPainted(AbstractEditorPanel.getBooleanProperty("eolMarkers"));
        textAreaPainter.setBlockCaretEnabled(AbstractEditorPanel.getBooleanProperty("blockCaret"));
        textAreaPainter.setBracketHighlightColor(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.bracketHighlightColor")));
        textAreaPainter.setLineHighlightColor(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.lineHighlightColor")));
        textAreaPainter.setEOLMarkerColor(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.eolMarkerColor")));
        textAreaPainter.setCaretColor(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.caretColor")));
        textAreaPainter.setSelectionColor(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.selectionColor")));
        textAreaPainter.setBackground(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.bgColor")));
        textAreaPainter.setForeground(GUIUtilities.parseColor(AbstractEditorPanel.getProperty("editor.fgColor")));
        this.loadStyles(textAreaPainter);
        this.setCaretBlinkEnabled(AbstractEditorPanel.getBooleanProperty("blinkingCaret"));
        this.repaint();
    }

    public void loadUndoProperties() {
        long l;
        int n;
        try {
            n = Integer.parseInt(AbstractEditorPanel.getProperty("options.undo.limit"));
        }
        catch (Exception exception) {
            n = 100;
        }
        try {
            l = Long.parseLong(AbstractEditorPanel.getProperty("options.undo.sequence"));
        }
        catch (Exception exception) {
            l = 500L;
        }
        this.undo.setLimit(n);
        this.undo.setSequenceDelay(l);
        AbstractEditorPanel.setProperty("options.undo.limit", "" + n);
        AbstractEditorPanel.setProperty("options.undo.sequence", "" + l);
    }

    private void loadStyles(TextAreaPainter textAreaPainter) {
        try {
            SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[11];
            syntaxStyleArray[1] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.comment1"));
            syntaxStyleArray[2] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.comment2"));
            syntaxStyleArray[6] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.keyword1"));
            syntaxStyleArray[7] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.keyword2"));
            syntaxStyleArray[8] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.keyword3"));
            syntaxStyleArray[3] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.literal1"));
            syntaxStyleArray[4] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.literal2"));
            syntaxStyleArray[9] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.operator"));
            syntaxStyleArray[10] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.invalid"));
            syntaxStyleArray[5] = GUIUtilities.parseStyle(AbstractEditorPanel.getProperty("editor.style.label"));
            textAreaPainter.setStyles(syntaxStyleArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.changeFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setMinimumSize(new Dimension(80 * fontMetrics.charWidth('m'), 5 * fontMetrics.getHeight()));
        this.repaint();
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
        this.changeFont();
        this.repaint();
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.changeFont();
    }

    private void changeFont() {
        this.getPainter().setFont(new Font(this.fontName, this.fontStyle, this.fontSize));
    }

    public boolean getSoftTab() {
        return AbstractEditorPanel.getBooleanProperty("editor.softTab");
    }

    public int getTabSize() {
        String string = AbstractEditorPanel.getProperty("editor.tabSize");
        if (string == null) {
            return 8;
        }
        Integer n = new Integer(string);
        if (n != null) {
            return n;
        }
        return 8;
    }
}

