/*
 * Decompiled with CFR 0.152.
 */
package jedit.lang;

import jedit.KeywordMap;
import jedit.lang.SQLTokenMarker;

public class TSQLTokenMarker
extends SQLTokenMarker {
    private static KeywordMap tsqlKeywords;

    public TSQLTokenMarker() {
        super(TSQLTokenMarker.getKeywordMap(), true);
    }

    public static KeywordMap getKeywordMap() {
        if (tsqlKeywords == null) {
            tsqlKeywords = new KeywordMap(true);
            TSQLTokenMarker.addKeywords();
            TSQLTokenMarker.addDataTypes();
            TSQLTokenMarker.addSystemFunctions();
            TSQLTokenMarker.addOperators();
            TSQLTokenMarker.addSystemStoredProcedures();
            TSQLTokenMarker.addSystemTables();
        }
        return tsqlKeywords;
    }

    private static void addKeywords() {
        tsqlKeywords.add("ADD", (byte)6);
        tsqlKeywords.add("ALTER", (byte)6);
        tsqlKeywords.add("ANSI_NULLS", (byte)6);
        tsqlKeywords.add("AS", (byte)6);
        tsqlKeywords.add("ASC", (byte)6);
        tsqlKeywords.add("AUTHORIZATION", (byte)6);
        tsqlKeywords.add("BACKUP", (byte)6);
        tsqlKeywords.add("BEGIN", (byte)6);
        tsqlKeywords.add("BREAK", (byte)6);
        tsqlKeywords.add("BROWSE", (byte)6);
        tsqlKeywords.add("BULK", (byte)6);
        tsqlKeywords.add("BY", (byte)6);
        tsqlKeywords.add("CASCADE", (byte)6);
        tsqlKeywords.add("CHECK", (byte)6);
        tsqlKeywords.add("CHECKPOINT", (byte)6);
        tsqlKeywords.add("CLOSE", (byte)6);
        tsqlKeywords.add("CLUSTERED", (byte)6);
        tsqlKeywords.add("COLUMN", (byte)6);
        tsqlKeywords.add("COMMIT", (byte)6);
        tsqlKeywords.add("COMMITTED", (byte)6);
        tsqlKeywords.add("COMPUTE", (byte)6);
        tsqlKeywords.add("CONFIRM", (byte)6);
        tsqlKeywords.add("CONSTRAINT", (byte)6);
        tsqlKeywords.add("CONTAINS", (byte)6);
        tsqlKeywords.add("CONTAINSTABLE", (byte)6);
        tsqlKeywords.add("CONTINUE", (byte)6);
        tsqlKeywords.add("CONTROLROW", (byte)6);
        tsqlKeywords.add("CREATE", (byte)6);
        tsqlKeywords.add("CURRENT", (byte)6);
        tsqlKeywords.add("CURRENT_DATE", (byte)6);
        tsqlKeywords.add("CURRENT_TIME", (byte)6);
        tsqlKeywords.add("CURSOR", (byte)6);
        tsqlKeywords.add("DATABASE", (byte)6);
        tsqlKeywords.add("DBCC", (byte)6);
        tsqlKeywords.add("DEALLOCATE", (byte)6);
        tsqlKeywords.add("DECLARE", (byte)6);
        tsqlKeywords.add("DEFAULT", (byte)6);
        tsqlKeywords.add("DELETE", (byte)6);
        tsqlKeywords.add("DENY", (byte)6);
        tsqlKeywords.add("DESC", (byte)6);
        tsqlKeywords.add("DISK", (byte)6);
        tsqlKeywords.add("DISTINCT", (byte)6);
        tsqlKeywords.add("DISTRIBUTED", (byte)6);
        tsqlKeywords.add("DOUBLE", (byte)6);
        tsqlKeywords.add("DROP", (byte)6);
        tsqlKeywords.add("DUMMY", (byte)6);
        tsqlKeywords.add("DUMP", (byte)6);
        tsqlKeywords.add("ELSE", (byte)6);
        tsqlKeywords.add("END", (byte)6);
        tsqlKeywords.add("ERRLVL", (byte)6);
        tsqlKeywords.add("ERROREXIT", (byte)6);
        tsqlKeywords.add("ESCAPE", (byte)6);
        tsqlKeywords.add("EXCEPT", (byte)6);
        tsqlKeywords.add("EXEC", (byte)6);
        tsqlKeywords.add("EXECUTE", (byte)6);
        tsqlKeywords.add("EXIT", (byte)6);
        tsqlKeywords.add("FETCH", (byte)6);
        tsqlKeywords.add("FILE", (byte)6);
        tsqlKeywords.add("FILLFACTOR", (byte)6);
        tsqlKeywords.add("FLOPPY", (byte)6);
        tsqlKeywords.add("FOR", (byte)6);
        tsqlKeywords.add("FOREIGN", (byte)6);
        tsqlKeywords.add("FREETEXT", (byte)6);
        tsqlKeywords.add("FREETEXTTABLE", (byte)6);
        tsqlKeywords.add("FROM", (byte)6);
        tsqlKeywords.add("FULL", (byte)6);
        tsqlKeywords.add("GOTO", (byte)6);
        tsqlKeywords.add("GRANT", (byte)6);
        tsqlKeywords.add("GROUP", (byte)6);
        tsqlKeywords.add("HAVING", (byte)6);
        tsqlKeywords.add("HOLDLOCK", (byte)6);
        tsqlKeywords.add("IDENTITY_INSERT", (byte)6);
        tsqlKeywords.add("IDENTITYCOL", (byte)6);
        tsqlKeywords.add("ID", (byte)6);
        tsqlKeywords.add("IF", (byte)6);
        tsqlKeywords.add("INDEX", (byte)6);
        tsqlKeywords.add("INNER", (byte)6);
        tsqlKeywords.add("INSERT", (byte)6);
        tsqlKeywords.add("INTO", (byte)6);
        tsqlKeywords.add("IS", (byte)6);
        tsqlKeywords.add("ISOLATION", (byte)6);
        tsqlKeywords.add("KEY", (byte)6);
        tsqlKeywords.add("KILL", (byte)6);
        tsqlKeywords.add("LEVEL", (byte)6);
        tsqlKeywords.add("LINENO", (byte)6);
        tsqlKeywords.add("LOAD", (byte)6);
        tsqlKeywords.add("MAX", (byte)6);
        tsqlKeywords.add("MIN", (byte)6);
        tsqlKeywords.add("MIRROREXIT", (byte)6);
        tsqlKeywords.add("NATIONAL", (byte)6);
        tsqlKeywords.add("NOCHECK", (byte)6);
        tsqlKeywords.add("NONCLUSTERED", (byte)6);
        tsqlKeywords.add("OF", (byte)6);
        tsqlKeywords.add("OFF", (byte)6);
        tsqlKeywords.add("OFFSETS", (byte)6);
        tsqlKeywords.add("ON", (byte)6);
        tsqlKeywords.add("ONCE", (byte)6);
        tsqlKeywords.add("ONLY", (byte)6);
        tsqlKeywords.add("OPEN", (byte)6);
        tsqlKeywords.add("OPENDATASOURCE", (byte)6);
        tsqlKeywords.add("OPENQUERY", (byte)6);
        tsqlKeywords.add("OPENROWSET", (byte)6);
        tsqlKeywords.add("OPTION", (byte)6);
        tsqlKeywords.add("ORDER", (byte)6);
        tsqlKeywords.add("OVER", (byte)6);
        tsqlKeywords.add("PERCENT", (byte)6);
        tsqlKeywords.add("PERM", (byte)6);
        tsqlKeywords.add("PERMANENT", (byte)6);
        tsqlKeywords.add("PIPE", (byte)6);
        tsqlKeywords.add("PLAN", (byte)6);
        tsqlKeywords.add("PRECISION", (byte)6);
        tsqlKeywords.add("PREPARE", (byte)6);
        tsqlKeywords.add("PRIMARY", (byte)6);
        tsqlKeywords.add("PRINT", (byte)6);
        tsqlKeywords.add("PRIVILEGES", (byte)6);
        tsqlKeywords.add("PROC", (byte)6);
        tsqlKeywords.add("PROCEDURE", (byte)6);
        tsqlKeywords.add("PROCESSEXIT", (byte)6);
        tsqlKeywords.add("PUBLIC", (byte)6);
        tsqlKeywords.add("QUOTED_IDENTIFIER", (byte)6);
        tsqlKeywords.add("RAISERROR", (byte)6);
        tsqlKeywords.add("READ", (byte)6);
        tsqlKeywords.add("READTEXT", (byte)6);
        tsqlKeywords.add("RECONFIGURE", (byte)6);
        tsqlKeywords.add("REFERENCES", (byte)6);
        tsqlKeywords.add("REPEATABLE", (byte)6);
        tsqlKeywords.add("REPLICATION", (byte)6);
        tsqlKeywords.add("RESTORE", (byte)6);
        tsqlKeywords.add("RESTRICT", (byte)6);
        tsqlKeywords.add("RETURN", (byte)6);
        tsqlKeywords.add("REVOKE", (byte)6);
        tsqlKeywords.add("ROLLBACK", (byte)6);
        tsqlKeywords.add("ROWGUIDCOL", (byte)6);
        tsqlKeywords.add("RULE", (byte)6);
        tsqlKeywords.add("SAVE", (byte)6);
        tsqlKeywords.add("SCHEMA", (byte)6);
        tsqlKeywords.add("SELECT", (byte)6);
        tsqlKeywords.add("SERIALIZABLE", (byte)6);
        tsqlKeywords.add("SET", (byte)6);
        tsqlKeywords.add("SETUSER", (byte)6);
        tsqlKeywords.add("SHUTDOWN", (byte)6);
        tsqlKeywords.add("STATISTICS", (byte)6);
        tsqlKeywords.add("TABLE", (byte)6);
        tsqlKeywords.add("TAPE", (byte)6);
        tsqlKeywords.add("TEMP", (byte)6);
        tsqlKeywords.add("TEMPORARY", (byte)6);
        tsqlKeywords.add("TEXTIMAGE_ON", (byte)6);
        tsqlKeywords.add("THEN", (byte)6);
        tsqlKeywords.add("TO", (byte)6);
        tsqlKeywords.add("TOP", (byte)6);
        tsqlKeywords.add("TRAN", (byte)6);
        tsqlKeywords.add("TRANSACTION", (byte)6);
        tsqlKeywords.add("TRIGGER", (byte)6);
        tsqlKeywords.add("TRUNCATE", (byte)6);
        tsqlKeywords.add("TSEQUAL", (byte)6);
        tsqlKeywords.add("UNCOMMITTED", (byte)6);
        tsqlKeywords.add("UNION", (byte)6);
        tsqlKeywords.add("UNIQUE", (byte)6);
        tsqlKeywords.add("UPDATE", (byte)6);
        tsqlKeywords.add("UPDATETEXT", (byte)6);
        tsqlKeywords.add("USE", (byte)6);
        tsqlKeywords.add("VALUES", (byte)6);
        tsqlKeywords.add("VARYING", (byte)6);
        tsqlKeywords.add("VIEW", (byte)6);
        tsqlKeywords.add("WAITFOR", (byte)6);
        tsqlKeywords.add("WHEN", (byte)6);
        tsqlKeywords.add("WHERE", (byte)6);
        tsqlKeywords.add("WHILE", (byte)6);
        tsqlKeywords.add("WITH", (byte)6);
        tsqlKeywords.add("WORK", (byte)6);
        tsqlKeywords.add("WRITETEXT", (byte)6);
    }

    private static void addDataTypes() {
        tsqlKeywords.add("binary", (byte)6);
        tsqlKeywords.add("bit", (byte)6);
        tsqlKeywords.add("char", (byte)6);
        tsqlKeywords.add("character", (byte)6);
        tsqlKeywords.add("datetime", (byte)6);
        tsqlKeywords.add("decimal", (byte)6);
        tsqlKeywords.add("float", (byte)6);
        tsqlKeywords.add("image", (byte)6);
        tsqlKeywords.add("int", (byte)6);
        tsqlKeywords.add("integer", (byte)6);
        tsqlKeywords.add("money", (byte)6);
        tsqlKeywords.add("name", (byte)6);
        tsqlKeywords.add("numeric", (byte)6);
        tsqlKeywords.add("nchar", (byte)6);
        tsqlKeywords.add("nvarchar", (byte)6);
        tsqlKeywords.add("ntext", (byte)6);
        tsqlKeywords.add("real", (byte)6);
        tsqlKeywords.add("smalldatetime", (byte)6);
        tsqlKeywords.add("smallint", (byte)6);
        tsqlKeywords.add("smallmoney", (byte)6);
        tsqlKeywords.add("text", (byte)6);
        tsqlKeywords.add("timestamp", (byte)6);
        tsqlKeywords.add("tinyint", (byte)6);
        tsqlKeywords.add("uniqueidentifier", (byte)6);
        tsqlKeywords.add("varbinary", (byte)6);
        tsqlKeywords.add("varchar", (byte)6);
    }

    private static void addSystemFunctions() {
        tsqlKeywords.add("@@CONNECTIONS", (byte)7);
        tsqlKeywords.add("@@CPU_BUSY", (byte)7);
        tsqlKeywords.add("@@CURSOR_ROWS", (byte)7);
        tsqlKeywords.add("@@DATEFIRST", (byte)7);
        tsqlKeywords.add("@@DBTS", (byte)7);
        tsqlKeywords.add("@@ERROR", (byte)7);
        tsqlKeywords.add("@@FETCH_STATUS", (byte)7);
        tsqlKeywords.add("@@IDENTITY", (byte)7);
        tsqlKeywords.add("@@IDLE", (byte)7);
        tsqlKeywords.add("@@IO_BUSY", (byte)7);
        tsqlKeywords.add("@@LANGID", (byte)7);
        tsqlKeywords.add("@@LANGUAGE", (byte)7);
        tsqlKeywords.add("@@LOCK_TIMEOUT", (byte)7);
        tsqlKeywords.add("@@MAX_CONNECTIONS", (byte)7);
        tsqlKeywords.add("@@MAX_PRECISION", (byte)7);
        tsqlKeywords.add("@@NESTLEVEL", (byte)7);
        tsqlKeywords.add("@@OPTIONS", (byte)7);
        tsqlKeywords.add("@@PACK_RECEIVED", (byte)7);
        tsqlKeywords.add("@@PACK_SENT", (byte)7);
        tsqlKeywords.add("@@PACKET_ERRORS", (byte)7);
        tsqlKeywords.add("@@PROCID", (byte)7);
        tsqlKeywords.add("@@REMSERVER", (byte)7);
        tsqlKeywords.add("@@ROWCOUNT", (byte)7);
        tsqlKeywords.add("@@SERVERNAME", (byte)7);
        tsqlKeywords.add("@@SERVICENAME", (byte)7);
        tsqlKeywords.add("@@SPID", (byte)7);
        tsqlKeywords.add("@@TEXTSIZE", (byte)7);
        tsqlKeywords.add("@@TIMETICKS", (byte)7);
        tsqlKeywords.add("@@TOTAL_ERRORS", (byte)7);
        tsqlKeywords.add("@@TOTAL_READ", (byte)7);
        tsqlKeywords.add("@@TOTAL_WRITE", (byte)7);
        tsqlKeywords.add("@@TRANCOUNT", (byte)7);
        tsqlKeywords.add("@@VERSION", (byte)7);
        tsqlKeywords.add("ABS", (byte)7);
        tsqlKeywords.add("ACOS", (byte)7);
        tsqlKeywords.add("APP_NAME", (byte)7);
        tsqlKeywords.add("ASCII", (byte)7);
        tsqlKeywords.add("ASIN", (byte)7);
        tsqlKeywords.add("ATAN", (byte)7);
        tsqlKeywords.add("ATN2", (byte)7);
        tsqlKeywords.add("CASE", (byte)7);
        tsqlKeywords.add("CAST", (byte)7);
        tsqlKeywords.add("CEILING", (byte)7);
        tsqlKeywords.add("CHARINDEX", (byte)7);
        tsqlKeywords.add("COALESCE", (byte)7);
        tsqlKeywords.add("COL_LENGTH", (byte)7);
        tsqlKeywords.add("COL_NAME", (byte)7);
        tsqlKeywords.add("COLUMNPROPERTY", (byte)7);
        tsqlKeywords.add("CONVERT", (byte)7);
        tsqlKeywords.add("COS", (byte)7);
        tsqlKeywords.add("COT", (byte)7);
        tsqlKeywords.add("CURRENT_TIME", (byte)7);
        tsqlKeywords.add("CURRENT_DATE", (byte)7);
        tsqlKeywords.add("CURRENT_TIMESTAMP", (byte)7);
        tsqlKeywords.add("CURRENT_USER", (byte)7);
        tsqlKeywords.add("CURSOR_STATUS", (byte)7);
        tsqlKeywords.add("DATABASEPROPERTY", (byte)7);
        tsqlKeywords.add("DATALENGTH", (byte)7);
        tsqlKeywords.add("DATEADD", (byte)7);
        tsqlKeywords.add("DATEDIFF", (byte)7);
        tsqlKeywords.add("DATENAME", (byte)7);
        tsqlKeywords.add("DATEPART", (byte)7);
        tsqlKeywords.add("DAY", (byte)7);
        tsqlKeywords.add("DB_ID", (byte)7);
        tsqlKeywords.add("DB_NAME", (byte)7);
        tsqlKeywords.add("DEGREES", (byte)7);
        tsqlKeywords.add("DIFFERENCE", (byte)7);
        tsqlKeywords.add("EXP", (byte)7);
        tsqlKeywords.add("FILE_ID", (byte)7);
        tsqlKeywords.add("FILE_NAME", (byte)7);
        tsqlKeywords.add("FILEGROUP_ID", (byte)7);
        tsqlKeywords.add("FILEGROUP_NAME", (byte)7);
        tsqlKeywords.add("FILEGROUPPROPERTY", (byte)7);
        tsqlKeywords.add("FILEPROPERTY", (byte)7);
        tsqlKeywords.add("FLOOR", (byte)7);
        tsqlKeywords.add("FORMATMESSAGE", (byte)7);
        tsqlKeywords.add("FULLTEXTCATALOGPROPERTY", (byte)7);
        tsqlKeywords.add("FULLTEXTSERVICEPROPERTY", (byte)7);
        tsqlKeywords.add("GETANSINULL", (byte)7);
        tsqlKeywords.add("GETDATE", (byte)7);
        tsqlKeywords.add("HOST_ID", (byte)7);
        tsqlKeywords.add("HOST_NAME", (byte)7);
        tsqlKeywords.add("IDENT_INCR", (byte)7);
        tsqlKeywords.add("IDENT_SEED", (byte)7);
        tsqlKeywords.add("IDENTITY_INSERT", (byte)7);
        tsqlKeywords.add("INDEX_COL", (byte)7);
        tsqlKeywords.add("INDEXPROPERTY", (byte)7);
        tsqlKeywords.add("IS_MEMBER", (byte)7);
        tsqlKeywords.add("IS_SRVROLEMEMBER", (byte)7);
        tsqlKeywords.add("ISDATE", (byte)7);
        tsqlKeywords.add("ISNULL", (byte)7);
        tsqlKeywords.add("ISNUMERIC", (byte)7);
        tsqlKeywords.add("LEFT", (byte)7);
        tsqlKeywords.add("LEN", (byte)7);
        tsqlKeywords.add("LOG", (byte)7);
        tsqlKeywords.add("LOG10", (byte)7);
        tsqlKeywords.add("LOWER", (byte)7);
        tsqlKeywords.add("LTRIM", (byte)7);
        tsqlKeywords.add("MONTH", (byte)7);
        tsqlKeywords.add("NEWID", (byte)7);
        tsqlKeywords.add("NULLIF", (byte)7);
        tsqlKeywords.add("OBJECT_ID", (byte)7);
        tsqlKeywords.add("OBJECT_NAME", (byte)7);
        tsqlKeywords.add("OBJECTPROPERTY", (byte)7);
        tsqlKeywords.add("PARSENAME", (byte)7);
        tsqlKeywords.add("PATINDEX", (byte)7);
        tsqlKeywords.add("PERMISSIONS", (byte)7);
        tsqlKeywords.add("PI", (byte)7);
        tsqlKeywords.add("POWER", (byte)7);
        tsqlKeywords.add("QUOTENAME", (byte)7);
        tsqlKeywords.add("RADIANS", (byte)7);
        tsqlKeywords.add("RAND", (byte)7);
        tsqlKeywords.add("REPLACE", (byte)7);
        tsqlKeywords.add("REPLICATE", (byte)7);
        tsqlKeywords.add("REVERSE", (byte)7);
        tsqlKeywords.add("RIGHT", (byte)7);
        tsqlKeywords.add("ROUND", (byte)7);
        tsqlKeywords.add("RTRIM", (byte)7);
        tsqlKeywords.add("SESSION_USER", (byte)7);
        tsqlKeywords.add("SIGN", (byte)7);
        tsqlKeywords.add("SIN", (byte)7);
        tsqlKeywords.add("SOUNDEX", (byte)7);
        tsqlKeywords.add("SPACE", (byte)7);
        tsqlKeywords.add("SQRT", (byte)7);
        tsqlKeywords.add("SQUARE", (byte)7);
        tsqlKeywords.add("STATS_DATE", (byte)7);
        tsqlKeywords.add("STR", (byte)7);
        tsqlKeywords.add("STUFF", (byte)7);
        tsqlKeywords.add("SUBSTRING", (byte)7);
        tsqlKeywords.add("SUSER_ID", (byte)7);
        tsqlKeywords.add("SUSER_NAME", (byte)7);
        tsqlKeywords.add("SUSER_SID", (byte)7);
        tsqlKeywords.add("SUSER_SNAME", (byte)7);
        tsqlKeywords.add("SYSTEM_USER", (byte)7);
        tsqlKeywords.add("TAN", (byte)7);
        tsqlKeywords.add("TEXTPTR", (byte)7);
        tsqlKeywords.add("TEXTVALID", (byte)7);
        tsqlKeywords.add("TYPEPROPERTY", (byte)7);
        tsqlKeywords.add("UNICODE", (byte)7);
        tsqlKeywords.add("UPPER", (byte)7);
        tsqlKeywords.add("USER_ID", (byte)7);
        tsqlKeywords.add("USER_NAME", (byte)7);
        tsqlKeywords.add("USER", (byte)7);
        tsqlKeywords.add("YEAR", (byte)7);
    }

    private static void addOperators() {
        tsqlKeywords.add("ALL", (byte)6);
        tsqlKeywords.add("AND", (byte)6);
        tsqlKeywords.add("ANY", (byte)6);
        tsqlKeywords.add("BETWEEN", (byte)6);
        tsqlKeywords.add("CROSS", (byte)6);
        tsqlKeywords.add("EXISTS", (byte)6);
        tsqlKeywords.add("IN", (byte)6);
        tsqlKeywords.add("INTERSECT", (byte)6);
        tsqlKeywords.add("JOIN", (byte)6);
        tsqlKeywords.add("LIKE", (byte)6);
        tsqlKeywords.add("NOT", (byte)6);
        tsqlKeywords.add("NULL", (byte)6);
        tsqlKeywords.add("OR", (byte)6);
        tsqlKeywords.add("OUTER", (byte)6);
        tsqlKeywords.add("SOME", (byte)6);
    }

    private static void addSystemStoredProcedures() {
        tsqlKeywords.add("sp_add_agent_parameter", (byte)8);
        tsqlKeywords.add("sp_add_agent_profile", (byte)8);
        tsqlKeywords.add("sp_add_alert", (byte)8);
        tsqlKeywords.add("sp_add_category", (byte)8);
        tsqlKeywords.add("sp_add_data_file_recover_suspect_db", (byte)8);
        tsqlKeywords.add("sp_add_job", (byte)8);
        tsqlKeywords.add("sp_add_jobschedule", (byte)8);
        tsqlKeywords.add("sp_add_jobserver", (byte)8);
        tsqlKeywords.add("sp_add_jobstep", (byte)8);
        tsqlKeywords.add("sp_add_log_file_recover_suspect_db", (byte)8);
        tsqlKeywords.add("sp_add_notification", (byte)8);
        tsqlKeywords.add("sp_add_operator", (byte)8);
        tsqlKeywords.add("sp_add_targetservergroup", (byte)8);
        tsqlKeywords.add("sp_add_targetsvrgrp_member", (byte)8);
        tsqlKeywords.add("sp_addalias", (byte)8);
        tsqlKeywords.add("sp_addapprole", (byte)8);
        tsqlKeywords.add("sp_addarticle", (byte)8);
        tsqlKeywords.add("sp_adddistpublisher", (byte)8);
        tsqlKeywords.add("sp_adddistributiondb", (byte)8);
        tsqlKeywords.add("sp_adddistributor", (byte)8);
        tsqlKeywords.add("sp_addextendedproc", (byte)8);
        tsqlKeywords.add("sp_addgroup", (byte)8);
        tsqlKeywords.add("sp_addlinkedserver", (byte)8);
        tsqlKeywords.add("sp_addlinkedsrvlogin", (byte)8);
        tsqlKeywords.add("sp_addlinkedsrvlogin", (byte)8);
        tsqlKeywords.add("sp_addlogin", (byte)8);
        tsqlKeywords.add("sp_addmergearticle", (byte)8);
        tsqlKeywords.add("sp_addmergefilter", (byte)8);
        tsqlKeywords.add("sp_addmergepublication", (byte)8);
        tsqlKeywords.add("sp_addmergepullsubscription", (byte)8);
        tsqlKeywords.add("sp_addmergepullsubscription_agent", (byte)8);
        tsqlKeywords.add("sp_addmergesubscription", (byte)8);
        tsqlKeywords.add("sp_addmessage", (byte)8);
        tsqlKeywords.add("sp_addpublication", (byte)8);
        tsqlKeywords.add("sp_addpublication_snapshot", (byte)8);
        tsqlKeywords.add("sp_addpublisher70", (byte)8);
        tsqlKeywords.add("sp_addpullsubscription", (byte)8);
        tsqlKeywords.add("sp_addpullsubscription_agent", (byte)8);
        tsqlKeywords.add("sp_addremotelogin", (byte)8);
        tsqlKeywords.add("sp_addrole", (byte)8);
        tsqlKeywords.add("sp_addrolemember", (byte)8);
        tsqlKeywords.add("sp_addserver", (byte)8);
        tsqlKeywords.add("sp_addsrvrolemember", (byte)8);
        tsqlKeywords.add("sp_addsubscriber", (byte)8);
        tsqlKeywords.add("sp_addsubscriber_schedule", (byte)8);
        tsqlKeywords.add("sp_addsubscription", (byte)8);
        tsqlKeywords.add("sp_addsynctriggers", (byte)8);
        tsqlKeywords.add("sp_addtabletocontents", (byte)8);
        tsqlKeywords.add("sp_addtask", (byte)8);
        tsqlKeywords.add("sp_addtype", (byte)8);
        tsqlKeywords.add("sp_addumpdevice", (byte)8);
        tsqlKeywords.add("sp_adduser", (byte)8);
        tsqlKeywords.add("sp_altermessage", (byte)8);
        tsqlKeywords.add("sp_apply_job_to_targets", (byte)8);
        tsqlKeywords.add("sp_approlepassword", (byte)8);
        tsqlKeywords.add("sp_article_validation", (byte)8);
        tsqlKeywords.add("sp_articlecolumn", (byte)8);
        tsqlKeywords.add("sp_articlefilter", (byte)8);
        tsqlKeywords.add("sp_articlesynctranprocs", (byte)8);
        tsqlKeywords.add("sp_articleview", (byte)8);
        tsqlKeywords.add("sp_attach_db", (byte)8);
        tsqlKeywords.add("sp_attach_single_file_db", (byte)8);
        tsqlKeywords.add("sp_autostats", (byte)8);
        tsqlKeywords.add("sp_bindefault", (byte)8);
        tsqlKeywords.add("sp_bindrule", (byte)8);
        tsqlKeywords.add("sp_bindsession", (byte)8);
        tsqlKeywords.add("sp_browsereplcmds", (byte)8);
        tsqlKeywords.add("sp_catalogs", (byte)8);
        tsqlKeywords.add("sp_certify_removable", (byte)8);
        tsqlKeywords.add("sp_change_agent_parameter", (byte)8);
        tsqlKeywords.add("sp_change_agent_profile", (byte)8);
        tsqlKeywords.add("sp_change_subscription_properties", (byte)8);
        tsqlKeywords.add("sp_change_users_login", (byte)8);
        tsqlKeywords.add("sp_changearticle", (byte)8);
        tsqlKeywords.add("sp_changedbowner", (byte)8);
        tsqlKeywords.add("sp_changedistpublisher", (byte)8);
        tsqlKeywords.add("sp_changedistributiondb", (byte)8);
        tsqlKeywords.add("sp_changedistributor_password", (byte)8);
        tsqlKeywords.add("sp_changedistributor_property", (byte)8);
        tsqlKeywords.add("sp_changegroup", (byte)8);
        tsqlKeywords.add("sp_changemergearticle", (byte)8);
        tsqlKeywords.add("sp_changemergefilter", (byte)8);
        tsqlKeywords.add("sp_changemergepublication", (byte)8);
        tsqlKeywords.add("sp_changemergepullsubscription", (byte)8);
        tsqlKeywords.add("sp_changemergesubscription", (byte)8);
        tsqlKeywords.add("sp_changeobjectowner", (byte)8);
        tsqlKeywords.add("sp_changepublication", (byte)8);
        tsqlKeywords.add("sp_changesubscriber", (byte)8);
        tsqlKeywords.add("sp_changesubscriber_schedule", (byte)8);
        tsqlKeywords.add("sp_changesubstatus", (byte)8);
        tsqlKeywords.add("sp_check_for_sync_trigger", (byte)8);
        tsqlKeywords.add("sp_column_privileges", (byte)8);
        tsqlKeywords.add("sp_column_privileges_ex", (byte)8);
        tsqlKeywords.add("sp_columns", (byte)8);
        tsqlKeywords.add("sp_columns_ex", (byte)8);
        tsqlKeywords.add("sp_configure", (byte)8);
        tsqlKeywords.add("sp_create_removable", (byte)8);
        tsqlKeywords.add("sp_createorphan", (byte)8);
        tsqlKeywords.add("sp_createstats", (byte)8);
        tsqlKeywords.add("sp_cursor", (byte)8);
        tsqlKeywords.add("sp_cursor_list", (byte)8);
        tsqlKeywords.add("sp_cursorclose", (byte)8);
        tsqlKeywords.add("sp_cursorexecute", (byte)8);
        tsqlKeywords.add("sp_cursorfetch", (byte)8);
        tsqlKeywords.add("sp_cursoropen", (byte)8);
        tsqlKeywords.add("sp_cursoroption", (byte)8);
        tsqlKeywords.add("sp_cursorprepare", (byte)8);
        tsqlKeywords.add("sp_cursorunprepare", (byte)8);
        tsqlKeywords.add("sp_cycle_errorlog", (byte)8);
        tsqlKeywords.add("sp_databases", (byte)8);
        tsqlKeywords.add("sp_datatype_info", (byte)8);
        tsqlKeywords.add("sp_dbcmptlevel", (byte)8);
        tsqlKeywords.add("sp_dbfixedrolepermission", (byte)8);
        tsqlKeywords.add("sp_dboption", (byte)8);
        tsqlKeywords.add("sp_defaultdb", (byte)8);
        tsqlKeywords.add("sp_defaultlanguage", (byte)8);
        tsqlKeywords.add("sp_delete_alert", (byte)8);
        tsqlKeywords.add("sp_delete_backuphistory", (byte)8);
        tsqlKeywords.add("sp_delete_category", (byte)8);
        tsqlKeywords.add("sp_delete_job", (byte)8);
        tsqlKeywords.add("sp_delete_jobschedule", (byte)8);
        tsqlKeywords.add("sp_delete_jobserver", (byte)8);
        tsqlKeywords.add("sp_delete_jobstep", (byte)8);
        tsqlKeywords.add("sp_delete_notification", (byte)8);
        tsqlKeywords.add("sp_delete_operator", (byte)8);
        tsqlKeywords.add("sp_delete_targetserver", (byte)8);
        tsqlKeywords.add("sp_delete_targetservergroup", (byte)8);
        tsqlKeywords.add("sp_delete_targetsvrgrp_member", (byte)8);
        tsqlKeywords.add("sp_deletemergeconflictrow", (byte)8);
        tsqlKeywords.add("sp_denylogin", (byte)8);
        tsqlKeywords.add("sp_depends", (byte)8);
        tsqlKeywords.add("sp_describe_cursor", (byte)8);
        tsqlKeywords.add("sp_describe_cursor_columns", (byte)8);
        tsqlKeywords.add("sp_describe_cursor_tables", (byte)8);
        tsqlKeywords.add("sp_detach_db", (byte)8);
        tsqlKeywords.add("sp_drop_agent_parameter", (byte)8);
        tsqlKeywords.add("sp_drop_agent_profile", (byte)8);
        tsqlKeywords.add("sp_dropalias", (byte)8);
        tsqlKeywords.add("sp_dropapprole", (byte)8);
        tsqlKeywords.add("sp_droparticle", (byte)8);
        tsqlKeywords.add("sp_dropdevice", (byte)8);
        tsqlKeywords.add("sp_dropdistpublisher", (byte)8);
        tsqlKeywords.add("sp_dropdistributiondb", (byte)8);
        tsqlKeywords.add("sp_dropdistributor", (byte)8);
        tsqlKeywords.add("sp_dropextendedproc", (byte)8);
        tsqlKeywords.add("sp_dropgroup", (byte)8);
        tsqlKeywords.add("sp_droplinkedsrvlogin", (byte)8);
        tsqlKeywords.add("sp_droplinkedsrvlogin", (byte)8);
        tsqlKeywords.add("sp_droplogin", (byte)8);
        tsqlKeywords.add("sp_dropmergearticle", (byte)8);
        tsqlKeywords.add("sp_dropmergefilter", (byte)8);
        tsqlKeywords.add("sp_dropmergepublication", (byte)8);
        tsqlKeywords.add("sp_dropmergepullsubscription", (byte)8);
        tsqlKeywords.add("sp_dropmergesubscription", (byte)8);
        tsqlKeywords.add("sp_dropmessage", (byte)8);
        tsqlKeywords.add("sp_droporphans", (byte)8);
        tsqlKeywords.add("sp_droppublication", (byte)8);
        tsqlKeywords.add("sp_droppullsubscription", (byte)8);
        tsqlKeywords.add("sp_dropremotelogin", (byte)8);
        tsqlKeywords.add("sp_droprole", (byte)8);
        tsqlKeywords.add("sp_droprolemember", (byte)8);
        tsqlKeywords.add("sp_dropserver", (byte)8);
        tsqlKeywords.add("sp_dropsrvrolemember", (byte)8);
        tsqlKeywords.add("sp_dropsubscriber", (byte)8);
        tsqlKeywords.add("sp_dropsubscription", (byte)8);
        tsqlKeywords.add("sp_droptask", (byte)8);
        tsqlKeywords.add("sp_droptype", (byte)8);
        tsqlKeywords.add("sp_dropuser", (byte)8);
        tsqlKeywords.add("sp_dropwebtask", (byte)8);
        tsqlKeywords.add("sp_dsninfo", (byte)8);
        tsqlKeywords.add("sp_dumpparamcmd", (byte)8);
        tsqlKeywords.add("sp_enumcodepages", (byte)8);
        tsqlKeywords.add("sp_enumcustomresolvers", (byte)8);
        tsqlKeywords.add("sp_enumdsn", (byte)8);
        tsqlKeywords.add("sp_enumfullsubscribers", (byte)8);
        tsqlKeywords.add("sp_execute", (byte)8);
        tsqlKeywords.add("sp_executesql", (byte)8);
        tsqlKeywords.add("sp_expired_subscription_cleanup", (byte)8);
        tsqlKeywords.add("sp_fkeys", (byte)8);
        tsqlKeywords.add("sp_foreignkeys", (byte)8);
        tsqlKeywords.add("sp_fulltext_catalog", (byte)8);
        tsqlKeywords.add("sp_fulltext_column", (byte)8);
        tsqlKeywords.add("sp_fulltext_database", (byte)8);
        tsqlKeywords.add("sp_fulltext_service", (byte)8);
        tsqlKeywords.add("sp_fulltext_table", (byte)8);
        tsqlKeywords.add("sp_generatefilters", (byte)8);
        tsqlKeywords.add("sp_get_distributor", (byte)8);
        tsqlKeywords.add("sp_getbindtoken", (byte)8);
        tsqlKeywords.add("sp_getmergedeletetype", (byte)8);
        tsqlKeywords.add("sp_grant_publication_access", (byte)8);
        tsqlKeywords.add("sp_grantdbaccess", (byte)8);
        tsqlKeywords.add("sp_grantlogin", (byte)8);
        tsqlKeywords.add("sp_help", (byte)8);
        tsqlKeywords.add("sp_help_agent_default", (byte)8);
        tsqlKeywords.add("sp_help_agent_parameter", (byte)8);
        tsqlKeywords.add("sp_help_agent_profile", (byte)8);
        tsqlKeywords.add("sp_help_alert", (byte)8);
        tsqlKeywords.add("sp_help_category", (byte)8);
        tsqlKeywords.add("sp_help_downloadlist", (byte)8);
        tsqlKeywords.add("sp_help_fulltext_catalogs", (byte)8);
        tsqlKeywords.add("sp_help_fulltext_catalogs_cursor", (byte)8);
        tsqlKeywords.add("sp_help_fulltext_columns", (byte)8);
        tsqlKeywords.add("sp_help_fulltext_columns_cursor", (byte)8);
        tsqlKeywords.add("sp_help_fulltext_tables", (byte)8);
        tsqlKeywords.add("sp_help_fulltext_tables_cursor", (byte)8);
        tsqlKeywords.add("sp_help_job", (byte)8);
        tsqlKeywords.add("sp_help_jobhistory", (byte)8);
        tsqlKeywords.add("sp_help_jobschedule", (byte)8);
        tsqlKeywords.add("sp_help_jobserver", (byte)8);
        tsqlKeywords.add("sp_help_jobstep", (byte)8);
        tsqlKeywords.add("sp_help_notification", (byte)8);
        tsqlKeywords.add("sp_help_operator", (byte)8);
        tsqlKeywords.add("sp_help_publication_access", (byte)8);
        tsqlKeywords.add("sp_help_targetserver", (byte)8);
        tsqlKeywords.add("sp_help_targetservergroup", (byte)8);
        tsqlKeywords.add("sp_helparticle", (byte)8);
        tsqlKeywords.add("sp_helparticlecolumns", (byte)8);
        tsqlKeywords.add("sp_helpconstraint", (byte)8);
        tsqlKeywords.add("sp_helpdb", (byte)8);
        tsqlKeywords.add("sp_helpdbfixedrole", (byte)8);
        tsqlKeywords.add("sp_helpdevice", (byte)8);
        tsqlKeywords.add("sp_helpdistpublisher", (byte)8);
        tsqlKeywords.add("sp_helpdistributiondb", (byte)8);
        tsqlKeywords.add("sp_helpdistributor", (byte)8);
        tsqlKeywords.add("sp_helpextendedproc", (byte)8);
        tsqlKeywords.add("sp_helpfile", (byte)8);
        tsqlKeywords.add("sp_helpfilegroup", (byte)8);
        tsqlKeywords.add("sp_helpgroup", (byte)8);
        tsqlKeywords.add("sp_helphistory", (byte)8);
        tsqlKeywords.add("sp_helpindex", (byte)8);
        tsqlKeywords.add("sp_helplanguage", (byte)8);
        tsqlKeywords.add("sp_helplinkedsrvlogin", (byte)8);
        tsqlKeywords.add("sp_helplogins", (byte)8);
        tsqlKeywords.add("sp_helpmergearticle", (byte)8);
        tsqlKeywords.add("sp_helpmergearticleconflicts", (byte)8);
        tsqlKeywords.add("sp_helpmergeconflictrows", (byte)8);
        tsqlKeywords.add("sp_helpmergedeleteconflictrows", (byte)8);
        tsqlKeywords.add("sp_helpmergefilter", (byte)8);
        tsqlKeywords.add("sp_helpmergepublication", (byte)8);
        tsqlKeywords.add("sp_helpmergepullsubscription", (byte)8);
        tsqlKeywords.add("sp_helpmergesubscription", (byte)8);
        tsqlKeywords.add("sp_helpntgroup", (byte)8);
        tsqlKeywords.add("sp_helppublication", (byte)8);
        tsqlKeywords.add("sp_helppullsubscription", (byte)8);
        tsqlKeywords.add("sp_helpremotelogin", (byte)8);
        tsqlKeywords.add("sp_helpreplicationdboption", (byte)8);
        tsqlKeywords.add("sp_helprole", (byte)8);
        tsqlKeywords.add("sp_helprolemember", (byte)8);
        tsqlKeywords.add("sp_helprotect", (byte)8);
        tsqlKeywords.add("sp_helpserver", (byte)8);
        tsqlKeywords.add("sp_helpsort", (byte)8);
        tsqlKeywords.add("sp_helpsrvrole", (byte)8);
        tsqlKeywords.add("sp_helpsrvrolemember", (byte)8);
        tsqlKeywords.add("sp_helpsubscriberinfo", (byte)8);
        tsqlKeywords.add("sp_helpsubscription", (byte)8);
        tsqlKeywords.add("sp_helpsubscription_properties", (byte)8);
        tsqlKeywords.add("sp_helptask", (byte)8);
        tsqlKeywords.add("sp_helptext", (byte)8);
        tsqlKeywords.add("sp_helptrigger", (byte)8);
        tsqlKeywords.add("sp_helpuser", (byte)8);
        tsqlKeywords.add("sp_indexes", (byte)8);
        tsqlKeywords.add("sp_indexoption", (byte)8);
        tsqlKeywords.add("sp_link_publication", (byte)8);
        tsqlKeywords.add("sp_linkedservers", (byte)8);
        tsqlKeywords.add("sp_lock", (byte)8);
        tsqlKeywords.add("sp_makewebtask", (byte)8);
        tsqlKeywords.add("sp_manage_jobs_by_login", (byte)8);
        tsqlKeywords.add("sp_mergedummyupdate", (byte)8);
        tsqlKeywords.add("sp_mergesubscription_cleanup", (byte)8);
        tsqlKeywords.add("sp_monitor", (byte)8);
        tsqlKeywords.add("sp_msx_defect", (byte)8);
        tsqlKeywords.add("sp_msx_enlist", (byte)8);
        tsqlKeywords.add("sp_OACreate", (byte)8);
        tsqlKeywords.add("sp_OADestroy", (byte)8);
        tsqlKeywords.add("sp_OAGetErrorInfo", (byte)8);
        tsqlKeywords.add("sp_OAGetProperty", (byte)8);
        tsqlKeywords.add("sp_OAMethod", (byte)8);
        tsqlKeywords.add("sp_OASetProperty", (byte)8);
        tsqlKeywords.add("sp_OAStop", (byte)8);
        tsqlKeywords.add("sp_password", (byte)8);
        tsqlKeywords.add("sp_pkeys", (byte)8);
        tsqlKeywords.add("sp_post_msx_operation", (byte)8);
        tsqlKeywords.add("sp_prepare", (byte)8);
        tsqlKeywords.add("sp_primarykeys", (byte)8);
        tsqlKeywords.add("sp_processmail", (byte)8);
        tsqlKeywords.add("sp_procoption", (byte)8);
        tsqlKeywords.add("sp_publication_validation", (byte)8);
        tsqlKeywords.add("sp_purge_jobhistory", (byte)8);
        tsqlKeywords.add("sp_purgehistory", (byte)8);
        tsqlKeywords.add("sp_reassigntask", (byte)8);
        tsqlKeywords.add("sp_recompile", (byte)8);
        tsqlKeywords.add("sp_refreshsubscriptions", (byte)8);
        tsqlKeywords.add("sp_refreshview", (byte)8);
        tsqlKeywords.add("sp_reinitmergepullsubscription", (byte)8);
        tsqlKeywords.add("sp_reinitmergesubscription", (byte)8);
        tsqlKeywords.add("sp_reinitpullsubscription", (byte)8);
        tsqlKeywords.add("sp_reinitsubscription", (byte)8);
        tsqlKeywords.add("sp_remoteoption", (byte)8);
        tsqlKeywords.add("sp_remove_job_from_targets", (byte)8);
        tsqlKeywords.add("sp_removedbreplication", (byte)8);
        tsqlKeywords.add("sp_rename", (byte)8);
        tsqlKeywords.add("sp_renamedb", (byte)8);
        tsqlKeywords.add("sp_replcmds", (byte)8);
        tsqlKeywords.add("sp_replcounters", (byte)8);
        tsqlKeywords.add("sp_repldone", (byte)8);
        tsqlKeywords.add("sp_replflush", (byte)8);
        tsqlKeywords.add("sp_replication_agent_checkup", (byte)8);
        tsqlKeywords.add("sp_replicationdboption", (byte)8);
        tsqlKeywords.add("sp_replsetoriginator", (byte)8);
        tsqlKeywords.add("sp_replshowcmds", (byte)8);
        tsqlKeywords.add("sp_repltrans", (byte)8);
        tsqlKeywords.add("sp_reset_connection", (byte)8);
        tsqlKeywords.add("sp_resync_targetserver", (byte)8);
        tsqlKeywords.add("sp_revoke_publication_access", (byte)8);
        tsqlKeywords.add("sp_revokedbaccess", (byte)8);
        tsqlKeywords.add("sp_revokelogin", (byte)8);
        tsqlKeywords.add("sp_runwebtask", (byte)8);
        tsqlKeywords.add("sp_script_synctran_commands", (byte)8);
        tsqlKeywords.add("sp_scriptdelproc", (byte)8);
        tsqlKeywords.add("sp_scriptinsproc", (byte)8);
        tsqlKeywords.add("sp_scriptmappedupdproc", (byte)8);
        tsqlKeywords.add("sp_scriptupdproc", (byte)8);
        tsqlKeywords.add("sp_sdidebug", (byte)8);
        tsqlKeywords.add("sp_server_info", (byte)8);
        tsqlKeywords.add("sp_serveroption", (byte)8);
        tsqlKeywords.add("sp_serveroption", (byte)8);
        tsqlKeywords.add("sp_setapprole", (byte)8);
        tsqlKeywords.add("sp_setnetname", (byte)8);
        tsqlKeywords.add("sp_spaceused", (byte)8);
        tsqlKeywords.add("sp_special_columns", (byte)8);
        tsqlKeywords.add("sp_sproc_columns", (byte)8);
        tsqlKeywords.add("sp_srvrolepermission", (byte)8);
        tsqlKeywords.add("sp_start_job", (byte)8);
        tsqlKeywords.add("sp_statistics", (byte)8);
        tsqlKeywords.add("sp_stop_job", (byte)8);
        tsqlKeywords.add("sp_stored_procedures", (byte)8);
        tsqlKeywords.add("sp_subscription_cleanup", (byte)8);
        tsqlKeywords.add("sp_table_privileges", (byte)8);
        tsqlKeywords.add("sp_table_privileges_ex", (byte)8);
        tsqlKeywords.add("sp_table_validation", (byte)8);
        tsqlKeywords.add("sp_tableoption", (byte)8);
        tsqlKeywords.add("sp_tables", (byte)8);
        tsqlKeywords.add("sp_tables_ex", (byte)8);
        tsqlKeywords.add("sp_unbindefault", (byte)8);
        tsqlKeywords.add("sp_unbindrule", (byte)8);
        tsqlKeywords.add("sp_unprepare", (byte)8);
        tsqlKeywords.add("sp_update_agent_profile", (byte)8);
        tsqlKeywords.add("sp_update_alert", (byte)8);
        tsqlKeywords.add("sp_update_category", (byte)8);
        tsqlKeywords.add("sp_update_job", (byte)8);
        tsqlKeywords.add("sp_update_jobschedule", (byte)8);
        tsqlKeywords.add("sp_update_jobstep", (byte)8);
        tsqlKeywords.add("sp_update_notification", (byte)8);
        tsqlKeywords.add("sp_update_operator", (byte)8);
        tsqlKeywords.add("sp_update_targetservergroup", (byte)8);
        tsqlKeywords.add("sp_updatestats", (byte)8);
        tsqlKeywords.add("sp_updatetask", (byte)8);
        tsqlKeywords.add("sp_validatelogins", (byte)8);
        tsqlKeywords.add("sp_validname", (byte)8);
        tsqlKeywords.add("sp_who", (byte)8);
        tsqlKeywords.add("xp_cmdshell", (byte)8);
        tsqlKeywords.add("xp_deletemail", (byte)8);
        tsqlKeywords.add("xp_enumgroups", (byte)8);
        tsqlKeywords.add("xp_findnextmsg", (byte)8);
        tsqlKeywords.add("xp_findnextmsg", (byte)8);
        tsqlKeywords.add("xp_grantlogin", (byte)8);
        tsqlKeywords.add("xp_logevent", (byte)8);
        tsqlKeywords.add("xp_loginconfig", (byte)8);
        tsqlKeywords.add("xp_logininfo", (byte)8);
        tsqlKeywords.add("xp_msver", (byte)8);
        tsqlKeywords.add("xp_readmail", (byte)8);
        tsqlKeywords.add("xp_revokelogin", (byte)8);
        tsqlKeywords.add("xp_sendmail", (byte)8);
        tsqlKeywords.add("xp_sprintf", (byte)8);
        tsqlKeywords.add("xp_sqlinventory", (byte)8);
        tsqlKeywords.add("xp_sqlmaint", (byte)8);
        tsqlKeywords.add("xp_sqltrace", (byte)8);
        tsqlKeywords.add("xp_sscanf", (byte)8);
        tsqlKeywords.add("xp_startmail", (byte)8);
        tsqlKeywords.add("xp_stopmail", (byte)8);
        tsqlKeywords.add("xp_trace_addnewqueue", (byte)8);
        tsqlKeywords.add("xp_trace_deletequeuedefinition", (byte)8);
        tsqlKeywords.add("xp_trace_destroyqueue", (byte)8);
        tsqlKeywords.add("xp_trace_enumqueuedefname", (byte)8);
        tsqlKeywords.add("xp_trace_enumqueuehandles", (byte)8);
        tsqlKeywords.add("xp_trace_eventclassrequired", (byte)8);
        tsqlKeywords.add("xp_trace_flushqueryhistory", (byte)8);
        tsqlKeywords.add("xp_trace_generate_event", (byte)8);
        tsqlKeywords.add("xp_trace_getappfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getconnectionidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getcpufilter", (byte)8);
        tsqlKeywords.add("xp_trace_getdbidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getdurationfilter", (byte)8);
        tsqlKeywords.add("xp_trace_geteventfilter", (byte)8);
        tsqlKeywords.add("xp_trace_geteventnames", (byte)8);
        tsqlKeywords.add("xp_trace_getevents", (byte)8);
        tsqlKeywords.add("xp_trace_gethostfilter", (byte)8);
        tsqlKeywords.add("xp_trace_gethpidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getindidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getntdmfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getntnmfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getobjidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getqueueautostart", (byte)8);
        tsqlKeywords.add("xp_trace_getqueuedestination", (byte)8);
        tsqlKeywords.add("xp_trace_getqueueproperties", (byte)8);
        tsqlKeywords.add("xp_trace_getreadfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getserverfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getseverityfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getspidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getsysobjectsfilter", (byte)8);
        tsqlKeywords.add("xp_trace_gettextfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getuserfilter", (byte)8);
        tsqlKeywords.add("xp_trace_getwritefilter", (byte)8);
        tsqlKeywords.add("xp_trace_loadqueuedefinition", (byte)8);
        tsqlKeywords.add("xp_trace_pausequeue", (byte)8);
        tsqlKeywords.add("xp_trace_restartqueue", (byte)8);
        tsqlKeywords.add("xp_trace_savequeuedefinition", (byte)8);
        tsqlKeywords.add("xp_trace_setappfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setconnectionidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setcpufilter", (byte)8);
        tsqlKeywords.add("xp_trace_setdbidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setdurationfilter", (byte)8);
        tsqlKeywords.add("xp_trace_seteventclassrequired", (byte)8);
        tsqlKeywords.add("xp_trace_seteventfilter", (byte)8);
        tsqlKeywords.add("xp_trace_sethostfilter", (byte)8);
        tsqlKeywords.add("xp_trace_sethpidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setindidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setntdmfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setntnmfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setobjidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setqueryhistory", (byte)8);
        tsqlKeywords.add("xp_trace_setqueueautostart", (byte)8);
        tsqlKeywords.add("xp_trace_setqueuecreateinfo", (byte)8);
        tsqlKeywords.add("xp_trace_setqueuedestination", (byte)8);
        tsqlKeywords.add("xp_trace_setreadfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setserverfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setseverityfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setspidfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setsysobjectsfilter", (byte)8);
        tsqlKeywords.add("xp_trace_settextfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setuserfilter", (byte)8);
        tsqlKeywords.add("xp_trace_setwritefilter", (byte)8);
    }

    private static void addSystemTables() {
        tsqlKeywords.add("backupfile", (byte)8);
        tsqlKeywords.add("backupmediafamily", (byte)8);
        tsqlKeywords.add("backupmediaset", (byte)8);
        tsqlKeywords.add("backupset", (byte)8);
        tsqlKeywords.add("MSagent_parameters", (byte)8);
        tsqlKeywords.add("MSagent_profiles", (byte)8);
        tsqlKeywords.add("MSarticles", (byte)8);
        tsqlKeywords.add("MSdistpublishers", (byte)8);
        tsqlKeywords.add("MSdistribution_agents", (byte)8);
        tsqlKeywords.add("MSdistribution_history", (byte)8);
        tsqlKeywords.add("MSdistributiondbs", (byte)8);
        tsqlKeywords.add("MSdistributor", (byte)8);
        tsqlKeywords.add("MSlogreader_agents", (byte)8);
        tsqlKeywords.add("MSlogreader_history", (byte)8);
        tsqlKeywords.add("MSmerge_agents", (byte)8);
        tsqlKeywords.add("MSmerge_contents", (byte)8);
        tsqlKeywords.add("MSmerge_delete_conflicts", (byte)8);
        tsqlKeywords.add("MSmerge_genhistory", (byte)8);
        tsqlKeywords.add("MSmerge_history", (byte)8);
        tsqlKeywords.add("MSmerge_replinfo", (byte)8);
        tsqlKeywords.add("MSmerge_subscriptions", (byte)8);
        tsqlKeywords.add("MSmerge_tombstone", (byte)8);
        tsqlKeywords.add("MSpublication_access", (byte)8);
        tsqlKeywords.add("Mspublications", (byte)8);
        tsqlKeywords.add("Mspublisher_databases", (byte)8);
        tsqlKeywords.add("MSrepl_commands", (byte)8);
        tsqlKeywords.add("MSrepl_errors", (byte)8);
        tsqlKeywords.add("Msrepl_originators", (byte)8);
        tsqlKeywords.add("MSrepl_transactions", (byte)8);
        tsqlKeywords.add("MSrepl_version", (byte)8);
        tsqlKeywords.add("MSreplication_objects", (byte)8);
        tsqlKeywords.add("MSreplication_subscriptions", (byte)8);
        tsqlKeywords.add("MSsnapshot_agents", (byte)8);
        tsqlKeywords.add("MSsnapshot_history", (byte)8);
        tsqlKeywords.add("MSsubscriber_info", (byte)8);
        tsqlKeywords.add("MSsubscriber_schedule", (byte)8);
        tsqlKeywords.add("MSsubscription_properties", (byte)8);
        tsqlKeywords.add("MSsubscriptions", (byte)8);
        tsqlKeywords.add("restorefile", (byte)8);
        tsqlKeywords.add("restorefilegroup", (byte)8);
        tsqlKeywords.add("restorehistory", (byte)8);
        tsqlKeywords.add("sysalerts", (byte)8);
        tsqlKeywords.add("sysallocations", (byte)8);
        tsqlKeywords.add("sysaltfiles", (byte)8);
        tsqlKeywords.add("sysarticles", (byte)8);
        tsqlKeywords.add("sysarticleupdates", (byte)8);
        tsqlKeywords.add("syscacheobjects", (byte)8);
        tsqlKeywords.add("syscategories", (byte)8);
        tsqlKeywords.add("syscharsets", (byte)8);
        tsqlKeywords.add("syscolumns", (byte)8);
        tsqlKeywords.add("syscomments", (byte)8);
        tsqlKeywords.add("sysconfigures", (byte)8);
        tsqlKeywords.add("sysconstraints", (byte)8);
        tsqlKeywords.add("syscurconfigs", (byte)8);
        tsqlKeywords.add("sysdatabases", (byte)8);
        tsqlKeywords.add("sysdatabases", (byte)8);
        tsqlKeywords.add("sysdepends", (byte)8);
        tsqlKeywords.add("sysdevices", (byte)8);
        tsqlKeywords.add("sysdownloadlist", (byte)8);
        tsqlKeywords.add("sysfilegroups", (byte)8);
        tsqlKeywords.add("sysfiles", (byte)8);
        tsqlKeywords.add("sysforeignkeys", (byte)8);
        tsqlKeywords.add("sysfulltextcatalogs", (byte)8);
        tsqlKeywords.add("sysindexes", (byte)8);
        tsqlKeywords.add("sysindexkeys", (byte)8);
        tsqlKeywords.add("sysjobhistory", (byte)8);
        tsqlKeywords.add("sysjobs", (byte)8);
        tsqlKeywords.add("sysjobschedules", (byte)8);
        tsqlKeywords.add("sysjobservers", (byte)8);
        tsqlKeywords.add("sysjobsteps", (byte)8);
        tsqlKeywords.add("syslanguages", (byte)8);
        tsqlKeywords.add("syslockinfo", (byte)8);
        tsqlKeywords.add("syslogins", (byte)8);
        tsqlKeywords.add("sysmembers", (byte)8);
        tsqlKeywords.add("sysmergearticles", (byte)8);
        tsqlKeywords.add("sysmergepublications", (byte)8);
        tsqlKeywords.add("sysmergeschemachange", (byte)8);
        tsqlKeywords.add("sysmergesubscriptions", (byte)8);
        tsqlKeywords.add("sysmergesubsetfilters", (byte)8);
        tsqlKeywords.add("sysmessages", (byte)8);
        tsqlKeywords.add("sysnotifications", (byte)8);
        tsqlKeywords.add("sysobjects", (byte)8);
        tsqlKeywords.add("sysobjects", (byte)8);
        tsqlKeywords.add("sysoledbusers", (byte)8);
        tsqlKeywords.add("sysoperators", (byte)8);
        tsqlKeywords.add("sysperfinfo", (byte)8);
        tsqlKeywords.add("syspermissions", (byte)8);
        tsqlKeywords.add("sysprocesses", (byte)8);
        tsqlKeywords.add("sysprotects", (byte)8);
        tsqlKeywords.add("syspublications", (byte)8);
        tsqlKeywords.add("sysreferences", (byte)8);
        tsqlKeywords.add("sysremotelogins", (byte)8);
        tsqlKeywords.add("sysreplicationalerts", (byte)8);
        tsqlKeywords.add("sysservers", (byte)8);
        tsqlKeywords.add("sysservers", (byte)8);
        tsqlKeywords.add("syssubscriptions", (byte)8);
        tsqlKeywords.add("systargetservergroupmembers", (byte)8);
        tsqlKeywords.add("systargetservergroups", (byte)8);
        tsqlKeywords.add("systargetservers", (byte)8);
        tsqlKeywords.add("systaskids", (byte)8);
        tsqlKeywords.add("systypes", (byte)8);
        tsqlKeywords.add("sysusers", (byte)8);
    }
}

