/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.jbrowser.Options;
import java.lang.reflect.Modifier;

public class RWModifier
extends Modifier {
    private static final int STRICT = 2048;
    private static final int CLASS = 32768;
    private static final int NO_MODIFIERS = 0;
    private static final int ALL_MODIFIERS = 36863;
    private static final int VALID_FOR_CLASS = 36369;
    private static final int INVALID_FOR_CONSTRUCTOR = 1336;
    private static final int INVALID_FOR_ABSTRACT_METHOD = 314;
    private static final int INVALID_FOR_INTERFACE_METHOD = 318;
    static final int TOPLEVEL_VIS_PACKAGE = 0;
    static final int TOPLEVEL_VIS_PUBLIC = 1;
    static final int MEMBER_VIS_PRIVATE = 0;
    static final int MEMBER_VIS_PACKAGE = 1;
    static final int MEMBER_VIS_PROTECTED = 2;
    static final int MEMBER_VIS_PUBLIC = 3;

    public static final boolean isStrict(int n) {
        return (n & 0x800) > 0;
    }

    public static final boolean isClass(int n) {
        return (n & 0x8000) > 0;
    }

    public static final boolean isClassOrInterface(int n) {
        return (n & 0x8200) > 0;
    }

    public static final int setClass(int n) {
        return n | 0x8000;
    }

    public static final int setAbstract(int n) {
        return n | 0x400;
    }

    public static final int setFinal(int n) {
        return n | 0x10;
    }

    public static final int setInterface(int n) {
        return n | 0x200;
    }

    public static final int setNative(int n) {
        return n | 0x100;
    }

    public static final int setPrivate(int n) {
        return n | 2;
    }

    public static final int setProtected(int n) {
        return n | 4;
    }

    public static final int setPublic(int n) {
        return n | 1;
    }

    public static final int setStatic(int n) {
        return n | 8;
    }

    public static final int setStrict(int n) {
        return n | 0x800;
    }

    public static final int setSynchronized(int n) {
        return n | 0x20;
    }

    public static final int setTransient(int n) {
        return n | 0x80;
    }

    public static final int setVolatile(int n) {
        return n | 0x40;
    }

    public static final int setClass(int n, boolean bl) {
        return bl ? n | 0x8000 : n & 0xFFFF7FFF;
    }

    public static final int setAbstract(int n, boolean bl) {
        return bl ? n | 0x400 : n & 0xFFFFFBFF;
    }

    public static final int setFinal(int n, boolean bl) {
        return bl ? n | 0x10 : n & 0xFFFFFFEF;
    }

    public static final int setInterface(int n, boolean bl) {
        return bl ? n | 0x200 : n & 0xFFFFFDFF;
    }

    public static final int setNative(int n, boolean bl) {
        return bl ? n | 0x100 : n & 0xFFFFFEFF;
    }

    public static final int setPrivate(int n, boolean bl) {
        return bl ? n | 2 : n & 0xFFFFFFFD;
    }

    public static final int setProtected(int n, boolean bl) {
        return bl ? n | 4 : n & 0xFFFFFFFB;
    }

    public static final int setPublic(int n, boolean bl) {
        return bl ? n | 1 : n & 0xFFFFFFFE;
    }

    public static final int setStatic(int n, boolean bl) {
        return bl ? n | 8 : n & 0xFFFFFFF7;
    }

    public static final int setStrict(int n, boolean bl) {
        return bl ? n | 0x800 : n & 0xFFFFF7FF;
    }

    public static final int setSynchronized(int n, boolean bl) {
        return bl ? n | 0x20 : n & 0xFFFFFFDF;
    }

    public static final int setTransient(int n, boolean bl) {
        return bl ? n | 0x80 : n & 0xFFFFFF7F;
    }

    public static final int setVolatile(int n, boolean bl) {
        return bl ? n | 0x40 : n & 0xFFFFFFBF;
    }

    public static boolean isValidForClass(int n) {
        return (n & 0xFFFF71EE) != 0;
    }

    public static boolean isValidForConstructor(int n) {
        return (n & 0x538) == 0;
    }

    public static boolean isValidInterfaceMethod(int n) {
        return (n & 0x13E) == 0;
    }

    public static boolean isValidAbstractMethod(int n) {
        return (n & 0x13A) == 0;
    }

    public static String toString(int n, Options.DisplayIro displayIro) {
        String string = "";
        string = displayIro.getVisSymbols() ? (RWModifier.isPrivate(n) ? string + "-" : (RWModifier.isProtected(n) ? string + "#" : (RWModifier.isPublic(n) ? string + "+" : string + " "))) : (RWModifier.isPrivate(n) ? string + "private " : (RWModifier.isProtected(n) ? string + "protected " : (RWModifier.isPublic(n) ? string + "public " : string + "")));
        if (!displayIro.getStaticUlined() && RWModifier.isStatic(n)) {
            string = string + "static ";
        }
        if (!displayIro.getAbstractItalic() && RWModifier.isAbstract(n)) {
            string = string + "abstract ";
        }
        if (RWModifier.isFinal(n)) {
            string = string + "final ";
        }
        if (displayIro.getShowMiscMod()) {
            if (RWModifier.isVolatile(n)) {
                string = string + "volatile ";
            }
            if (RWModifier.isTransient(n)) {
                string = string + "transient ";
            }
            if (RWModifier.isSynchronized(n)) {
                string = string + "synchronized ";
            }
            if (RWModifier.isNative(n)) {
                string = string + "native ";
            }
            if (RWModifier.isStrict(n)) {
                string = string + "strictfp ";
            }
        }
        if (displayIro.getShowIconKeywords()) {
            if (RWModifier.isClass(n)) {
                string = string + "class ";
            } else if (RWModifier.isInterface(n)) {
                string = string + "interface ";
            }
        }
        return string;
    }

    public static final int getVisLevelIndex(int n) {
        if (RWModifier.isPublic(n)) {
            return 3;
        }
        if (RWModifier.isProtected(n)) {
            return 2;
        }
        if (RWModifier.isPrivate(n)) {
            return 0;
        }
        return 1;
    }

    public static final int getTopLevelVisIndex(int n) {
        if (RWModifier.isPublic(n)) {
            return 1;
        }
        return 0;
    }

    public static final int getMemberVisIndex(int n) {
        if (RWModifier.isPublic(n)) {
            return 3;
        }
        if (RWModifier.isProtected(n)) {
            return 2;
        }
        if (RWModifier.isPrivate(n)) {
            return 0;
        }
        return 1;
    }
}

