/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.jbrowser.JBrowseParser;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import jsynedit.AbstractDoc;
import jsynedit.AbstractEditorPanel;

class JEditLineSource
implements JBrowseParser.LineSource {
    private AbstractEditorPanel view;
    private AbstractDoc buffer;
    private Element map;
    private Element lineElement;
    private String name;
    private int start;
    private int lastLine;

    JEditLineSource(AbstractEditorPanel abstractEditorPanel) {
        this.view = abstractEditorPanel;
        this.reset();
    }

    public void reset() {
        this.buffer = this.view.getTextArea();
        this.map = this.buffer.getDocument().getDefaultRootElement();
        this.start = 0;
        this.lastLine = -1;
        this.name = this.buffer.getName();
    }

    public final String getName() {
        return this.name;
    }

    public final Object createPosition(int n) {
        Position position;
        try {
            position = this.buffer.getDocument().createPosition(n);
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    public final String getLine(int n) {
        String string;
        if (n > this.map.getElementCount() - 1) {
            System.out.println(this + " Argument to getLine() is bad: " + n);
            return null;
        }
        try {
            this.lineElement = this.map.getElement(n);
            if (this.lineElement == null) {
                return null;
            }
            this.lastLine = n;
            this.start = this.lineElement.getStartOffset();
            string = this.buffer.getDocument().getText(this.start, this.lineElement.getEndOffset() - this.start - 1);
        }
        catch (BadLocationException badLocationException) {
            string = "";
        }
        return string;
    }

    public final boolean isExhausted() {
        return this.lastLine >= this.map.getElementCount() - 1;
    }

    public final int getStartOffset() {
        return this.start;
    }

    public final int getTotalLines() {
        return this.map.getElementCount();
    }

    final AbstractDoc getTextArea() {
        return this.buffer;
    }
}

