/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.gui.AbstractOptionPane;
import gnu.gui.JextCheckBox;
import gnu.gui.ModifiedCellRenderer;
import gnu.jbrowser.JBrowsePlugin;
import gnu.jbrowser.Options;
import gnu.jbrowser.PropertyAccessor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JBrowseOptionPane
extends AbstractOptionPane
implements ActionListener {
    boolean isInitGui;
    boolean isInitModel;
    private JextCheckBox cbxStatusBar;
    private JextCheckBox cbxShowAttributes;
    private JextCheckBox cbxShowPrimitives;
    private JextCheckBox cbxShowGeneralizations;
    private JextCheckBox cbxShowThrows;
    private JComboBox cmbTopLevelVis;
    private JComboBox cmbMemberVis;
    private int topLevelVisIndex;
    private int memberVisIndex;
    private JextCheckBox cbxShowArguments;
    private JextCheckBox cbxShowArgumentNames;
    private JextCheckBox cbxShowNestedName;
    private JextCheckBox cbxShowIconKeywords;
    private JextCheckBox cbxShowMiscMod;
    private JextCheckBox cbxAlphaSort;
    private JextCheckBox cbxShowLineNum;
    private JComboBox cmbStyle;
    private int styleIndex = 0;
    private JextCheckBox cbxVisSymbols;
    private JextCheckBox cbxAbstractItalic;
    private JextCheckBox cbxStaticUlined;
    private JextCheckBox cbxTypeIsSuffixed;
    private Options options = new Options();
    private Options.Filter filterOpt = this.options.getFilterOptions();
    private Options.Display displayOpt = this.options.getDisplayOptions();
    private PropertyAccessor props;
    private boolean batchUpdate = false;

    public JBrowseOptionPane() {
        super("jbrowse");
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
        this.props = new JBrowsePlugin.PropAccessor();
        this.options.load(this.props);
        this.initGui();
        this.initModel();
    }

    public JBrowseOptionPane(String string) {
        super("jbrowse");
        this.setName(string);
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
    }

    PropertyAccessor getPropertyAccessor() {
        return this.props;
    }

    void setPropertyAccessor(PropertyAccessor propertyAccessor) {
        this.props = propertyAccessor;
    }

    public boolean isInitGui() {
        return this.isInitGui;
    }

    public boolean isInitModel() {
        return this.isInitModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 == this.cbxStatusBar) {
            object = this.options;
        } else if (object2 == this.cbxShowAttributes) {
            object = this.filterOpt;
            if (this.cbxShowAttributes.getModel().isSelected()) {
                this.cbxShowPrimitives.getModel().setEnabled(true);
            } else {
                this.cbxShowPrimitives.getModel().setSelected(false);
                this.cbxShowPrimitives.getModel().setEnabled(false);
            }
        } else if (object2 == this.cbxShowPrimitives) {
            object = this.filterOpt;
        } else if (object2 == this.cbxShowGeneralizations) {
            object = this.filterOpt;
        } else if (object2 == this.cbxShowThrows) {
            object = this.filterOpt;
        } else if (object2 == this.cmbTopLevelVis) {
            object = this.filterOpt;
            this.topLevelVisIndex = this.cmbTopLevelVis.getSelectedIndex();
        } else if (object2 == this.cmbMemberVis) {
            object = this.filterOpt;
            this.memberVisIndex = this.cmbMemberVis.getSelectedIndex();
        } else if (object2 == this.cmbStyle) {
            object = this.displayOpt;
            this.styleIndex = this.cmbStyle.getSelectedIndex();
            this.refreshDisplayOptions(this.styleIndex);
        } else if (object2 == this.cbxShowArguments) {
            object = this.displayOpt;
            if (this.cbxShowArguments.getModel().isSelected()) {
                this.cbxShowArgumentNames.getModel().setEnabled(true);
            } else {
                this.cbxShowArgumentNames.getModel().setSelected(false);
                this.cbxShowArgumentNames.getModel().setEnabled(false);
            }
        } else {
            object = this.displayOpt;
        }
        if (!this.batchUpdate) {
            this.setOptions();
            ChangeListener changeListener = this.options.getListener();
            if (changeListener != null) {
                ChangeEvent changeEvent = new ChangeEvent(object);
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void load() {
        this.batchUpdate = true;
        this.options.load(this.props);
        this.batchUpdate = false;
    }

    void initGui() {
        JLabel jLabel = new JLabel(this.props.getProperty("options." + this.getName() + ".panel_label") + ":", 2);
        jLabel.setFont(new Font("Helvetica", 3, 13));
        this.addComponent(jLabel);
        JPanel jPanel = new JPanel(new FlowLayout(0, 9, 0));
        this.cbxStatusBar = new JextCheckBox("Display status bar");
        jPanel.add(this.cbxStatusBar);
        this.cbxStatusBar.addActionListener(this);
        this.addComponent(jPanel);
        OptionPanel optionPanel = new OptionPanel();
        TitledBorder titledBorder = new TitledBorder(new BevelBorder(1), " What to include ", 2, 2);
        optionPanel.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(0, 3, 1, 1)));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.cbxShowAttributes = new JextCheckBox("Attributes ");
        jPanel2.add(this.cbxShowAttributes);
        this.cbxShowPrimitives = new JextCheckBox("include");
        jPanel2.add(this.cbxShowPrimitives);
        optionPanel.addComponent(jPanel2);
        this.cbxShowAttributes.addActionListener(this);
        this.cbxShowPrimitives.addActionListener(this);
        this.cbxShowGeneralizations = new JextCheckBox("extends/implements ");
        optionPanel.addComponent(this.cbxShowGeneralizations);
        this.cbxShowGeneralizations.addActionListener(this);
        this.cbxShowThrows = new JextCheckBox("Method throws type(s) ");
        optionPanel.addComponent(this.cbxShowThrows);
        this.cbxShowThrows.addActionListener(this);
        JLabel jLabel2 = new JLabel("Lowest Visibility Level to Show");
        optionPanel.addComponent(jLabel2);
        String[] stringArray = new String[]{"package", "public"};
        this.cmbTopLevelVis = new JComboBox<String>(stringArray);
        this.cmbTopLevelVis.setRenderer(new ModifiedCellRenderer());
        optionPanel.addComponent("Top-Level:", this.cmbTopLevelVis);
        this.cmbTopLevelVis.addActionListener(this);
        String[] stringArray2 = new String[]{"private", "package", "protected", "public"};
        this.cmbMemberVis = new JComboBox<String>(stringArray2);
        this.cmbMemberVis.setRenderer(new ModifiedCellRenderer());
        optionPanel.addComponent("Member:", this.cmbMemberVis);
        this.cmbMemberVis.addActionListener(this);
        this.addComponent(optionPanel);
        OptionPanel optionPanel2 = new OptionPanel();
        TitledBorder titledBorder2 = new TitledBorder(new BevelBorder(1), " How to display ", 2, 2);
        optionPanel2.setBorder(new CompoundBorder(titledBorder2, new EmptyBorder(0, 3, 0, 1)));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        this.cbxShowArguments = new JextCheckBox("Arguments ");
        jPanel3.add(this.cbxShowArguments);
        this.cbxShowArguments.addActionListener(this);
        this.cbxShowArgumentNames = new JextCheckBox("formal names");
        jPanel3.add(this.cbxShowArgumentNames);
        optionPanel2.addComponent(jPanel3);
        this.cbxShowArgumentNames.addActionListener(this);
        this.cbxShowNestedName = new JextCheckBox("Qualify nested");
        optionPanel2.addComponent(this.cbxShowNestedName);
        this.cbxShowNestedName.addActionListener(this);
        this.cbxShowIconKeywords = new JextCheckBox("Keywords specified by icons");
        optionPanel2.addComponent(this.cbxShowIconKeywords);
        this.cbxShowIconKeywords.addActionListener(this);
        this.cbxShowMiscMod = new JextCheckBox("Implementation detail modifiers");
        optionPanel2.addComponent(this.cbxShowMiscMod);
        this.cbxShowMiscMod.addActionListener(this);
        this.cbxAlphaSort = new JextCheckBox("Alpha Method Sort");
        optionPanel2.addComponent(this.cbxAlphaSort);
        this.cbxAlphaSort.addActionListener(this);
        this.cbxShowLineNum = new JextCheckBox("Line Numbers");
        optionPanel2.addComponent(this.cbxShowLineNum);
        this.cbxShowLineNum.addActionListener(this);
        String[] stringArray3 = new String[]{"UML", "Java", "Custom"};
        this.cmbStyle = new JComboBox<String>(stringArray3);
        this.cmbStyle.setRenderer(new ModifiedCellRenderer());
        this.cmbStyle.addActionListener(this);
        optionPanel2.addComponent("Display style:", this.cmbStyle);
        JLabel jLabel3 = new JLabel("Custom Display");
        optionPanel2.addComponent(jLabel3);
        this.cbxVisSymbols = new JextCheckBox("Use Visibility");
        this.cbxAbstractItalic = new JextCheckBox("Abstract in italics");
        this.cbxStaticUlined = new JextCheckBox("Static as underlined");
        this.cbxTypeIsSuffixed = new JextCheckBox("Type identifier as a suffix");
        this.cbxVisSymbols.addActionListener(this);
        this.cbxAbstractItalic.addActionListener(this);
        this.cbxStaticUlined.addActionListener(this);
        this.cbxTypeIsSuffixed.addActionListener(this);
        optionPanel2.addComponent(this.cbxVisSymbols);
        optionPanel2.addComponent(this.cbxAbstractItalic);
        optionPanel2.addComponent(this.cbxStaticUlined);
        optionPanel2.addComponent(this.cbxTypeIsSuffixed);
        this.addComponent(optionPanel2);
        this.isInitGui = true;
    }

    public void initModel() {
        this.batchUpdate = true;
        this.cbxStatusBar.getModel().setSelected(this.options.getShowStatusBar());
        this.cbxShowAttributes.getModel().setSelected(this.filterOpt.getShowAttributes());
        this.cbxShowPrimitives.getModel().setSelected(this.filterOpt.getShowPrimitives());
        this.cbxShowGeneralizations.getModel().setSelected(this.filterOpt.getShowGeneralizations());
        this.cbxShowThrows.getModel().setSelected(this.filterOpt.getShowThrows());
        this.cmbTopLevelVis.setSelectedIndex(this.filterOpt.getTopLevelVisIndex());
        this.cmbMemberVis.setSelectedIndex(this.filterOpt.getMemberVisIndex());
        this.cbxShowArguments.getModel().setSelected(this.displayOpt.getShowArguments());
        this.cbxShowArgumentNames.getModel().setSelected(this.displayOpt.getShowArgumentNames());
        this.cbxShowNestedName.getModel().setSelected(this.displayOpt.getShowNestedName());
        this.cbxShowIconKeywords.getModel().setSelected(this.displayOpt.getShowIconKeywords());
        this.cbxShowMiscMod.getModel().setSelected(this.displayOpt.getShowMiscMod());
        this.cbxAlphaSort.getModel().setSelected(this.displayOpt.getAlphaSort());
        this.cbxShowLineNum.getModel().setSelected(this.displayOpt.getShowLineNum());
        this.cmbStyle.setSelectedIndex(this.displayOpt.getStyleIndex());
        this.cbxVisSymbols.getModel().setSelected(this.displayOpt.getVisSymbols());
        this.cbxAbstractItalic.getModel().setSelected(this.displayOpt.getAbstractItalic());
        this.cbxStaticUlined.getModel().setSelected(this.displayOpt.getStaticUlined());
        this.cbxTypeIsSuffixed.getModel().setSelected(this.displayOpt.getTypeIsSuffixed());
        if (this.cbxShowArguments.getModel().isSelected()) {
            this.cbxShowArgumentNames.getModel().setEnabled(true);
        } else {
            this.cbxShowArgumentNames.getModel().setSelected(false);
            this.cbxShowArgumentNames.getModel().setEnabled(false);
        }
        if (this.cbxShowAttributes.getModel().isSelected()) {
            this.cbxShowPrimitives.getModel().setEnabled(true);
        } else {
            this.cbxShowPrimitives.getModel().setSelected(false);
            this.cbxShowPrimitives.getModel().setEnabled(false);
        }
        this.refreshDisplayOptions(this.styleIndex);
        this.isInitModel = true;
        this.batchUpdate = false;
    }

    public void save() {
        this.options.save(this.props);
    }

    private void refreshDisplayOptions(int n) {
        if (n == 0) {
            this.cbxVisSymbols.getModel().setSelected(true);
            this.cbxAbstractItalic.getModel().setSelected(true);
            this.cbxStaticUlined.getModel().setSelected(true);
            this.cbxTypeIsSuffixed.getModel().setSelected(true);
            this.cbxVisSymbols.getModel().setEnabled(false);
            this.cbxAbstractItalic.getModel().setEnabled(false);
            this.cbxStaticUlined.getModel().setEnabled(false);
            this.cbxTypeIsSuffixed.getModel().setEnabled(false);
        } else if (n == 1) {
            this.cbxVisSymbols.getModel().setSelected(false);
            this.cbxAbstractItalic.getModel().setSelected(false);
            this.cbxStaticUlined.getModel().setSelected(false);
            this.cbxTypeIsSuffixed.getModel().setSelected(false);
            this.cbxVisSymbols.getModel().setEnabled(false);
            this.cbxAbstractItalic.getModel().setEnabled(false);
            this.cbxStaticUlined.getModel().setEnabled(false);
            this.cbxTypeIsSuffixed.getModel().setEnabled(false);
        } else if (n == 2) {
            this.cbxVisSymbols.getModel().setEnabled(true);
            this.cbxAbstractItalic.getModel().setEnabled(true);
            this.cbxStaticUlined.getModel().setEnabled(true);
            this.cbxTypeIsSuffixed.getModel().setEnabled(true);
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions() {
        this.options.setShowStatusBar(this.cbxStatusBar.getModel().isSelected());
        this.filterOpt.setShowAttributes(this.cbxShowAttributes.getModel().isSelected());
        this.filterOpt.setShowPrimitives(this.cbxShowPrimitives.getModel().isSelected());
        this.filterOpt.setShowGeneralizations(this.cbxShowGeneralizations.getModel().isSelected());
        this.filterOpt.setShowThrows(this.cbxShowThrows.getModel().isSelected());
        this.filterOpt.setTopLevelVisIndex(this.topLevelVisIndex);
        this.filterOpt.setMemberVisIndex(this.memberVisIndex);
        this.displayOpt.setShowArguments(this.cbxShowArguments.getModel().isSelected());
        this.displayOpt.setShowArgumentNames(this.cbxShowArgumentNames.getModel().isSelected());
        this.displayOpt.setShowNestedName(this.cbxShowNestedName.getModel().isSelected());
        this.displayOpt.setShowIconKeywords(this.cbxShowIconKeywords.getModel().isSelected());
        this.displayOpt.setShowMiscMod(this.cbxShowMiscMod.getModel().isSelected());
        this.displayOpt.setAlphaSort(this.cbxAlphaSort.getModel().isSelected());
        this.displayOpt.setShowLineNum(this.cbxShowLineNum.getModel().isSelected());
        this.displayOpt.setStyleIndex(this.styleIndex);
        this.displayOpt.setVisSymbols(this.cbxVisSymbols.getModel().isSelected());
        this.displayOpt.setAbstractItalic(this.cbxAbstractItalic.getModel().isSelected());
        this.displayOpt.setStaticUlined(this.cbxStaticUlined.getModel().isSelected());
        this.displayOpt.setTypeIsSuffixed(this.cbxTypeIsSuffixed.getModel().isSelected());
    }

    protected void addComponent(Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        this.gridBag.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    static class OptionPanel
    extends JPanel {
        protected GridBagLayout gridBag = new GridBagLayout();
        protected int y;

        public OptionPanel() {
            this.setLayout(this.gridBag);
        }

        protected void addComponent(String string, Component component) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel = new JLabel(string, 4);
            this.gridBag.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridwidth = 1;
            this.gridBag.setConstraints(component, gridBagConstraints);
            this.add(component);
        }

        protected void addComponent(Component component) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.gridBag.setConstraints(component, gridBagConstraints);
            this.add(component);
        }
    }
}

