/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import warbot.kernel.Brain;
import warbot.kernel.Food;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class NotreHomeKiller
extends Brain {
    String groupName = "warbot-";
    String roleName = "launcher";
    int waitingForRocket = 0;
    int waitingMax = 3;

    public void activate() {
        this.groupName = String.valueOf(this.groupName) + this.getTeam();
        this.randomHeading();
        this.println("I am a home killer robot");
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.requestRole(this.groupName, "mobile", null);
    }

    void decrWaitingForRocket() {
        --this.waitingForRocket;
        if (this.waitingForRocket < 0) {
            this.waitingForRocket = 0;
        }
    }

    public void doIt() {
        Percept[] detectedEntities;
        this.decrWaitingForRocket();
        if (!this.isMoving()) {
            this.randomHeading();
        }
        if ((detectedEntities = this.getPercepts()).length > 0) {
            int i = 0;
            while (i < detectedEntities.length) {
                Percept e = detectedEntities[i];
                if (e.getPerceptType().equals("Home") && !e.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(e.getX(), e.getY()));
                    this.setHeading(this.towards(e.getX(), e.getY()));
                    this.waitingForRocket = this.waitingMax;
                    return;
                }
                if ((e.getPerceptType().equals("RocketLauncher") || e.getPerceptType().equals("Explorer")) && this.waitingForRocket <= 0 && !e.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(e.getX(), e.getY()));
                    this.waitingForRocket = this.waitingMax;
                    return;
                }
                ++i;
            }
        }
        int min = 0;
        int i = 0;
        while (i < detectedEntities.length) {
            Percept e = detectedEntities[i];
            if (this.distanceTo(e) < this.distanceTo(detectedEntities[min]) && e.getPerceptType().equals("Food")) {
                min = i;
            }
            ++i;
        }
        if (detectedEntities.length > 0 && detectedEntities[min].getPerceptType().equals("Food")) {
            if (this.distanceTo(detectedEntities[min]) < 2.0) {
                this.eat((Food)detectedEntities[min]);
                return;
            }
            this.setHeading(this.towards(detectedEntities[min].getX(), detectedEntities[min].getY()));
            this.move();
            return;
        }
        WarbotMessage m = null;
        WarbotMessage lastMessage = null;
        while ((m = this.readMessage()) != null) {
            lastMessage = m;
        }
        if (lastMessage != null) {
            String act = lastMessage.getAct();
            if (act.equals("homeposition")) {
                double xpos = lastMessage.getFromX();
                double ypos = lastMessage.getFromY();
                this.setHeading(this.towards(xpos, ypos));
            } else if (act.equals("help")) {
                double xpos = lastMessage.getFromX();
                double ypos = lastMessage.getFromY();
                this.setHeading(this.towards(xpos, ypos));
            }
        }
        this.move();
    }
}

