/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import madkit.kernel.Kernel;

class SocketKernel
implements Serializable {
    final String host;
    int port;

    public SocketKernel(String string, int n) {
        this.host = string.toString();
        this.port = n;
    }

    public SocketKernel(int n) {
        this.host = Kernel.getAddress().getHost();
        this.port = n;
    }

    public SocketKernel(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        if (stringTokenizer.countTokens() != 2) {
            throw new NoSuchElementException("Invalid count on SocketKernel");
        }
        this.host = stringTokenizer.nextToken();
        this.port = Integer.parseInt(stringTokenizer.nextToken());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean equals(SocketKernel socketKernel) {
        return this.host.equals(socketKernel.host) && socketKernel.port == this.port;
    }

    public String toString() {
        return new String(this.host + ":" + this.port);
    }
}

