/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.NetworkRequest;
import madkit.netcomm.DistantKernelInformation;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetConfigAgent;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.RouterGUI;
import madkit.netcomm.SocketKernel;
import madkit.netcomm.UDPMessage;

class RouterAgent
extends MadkitNetworkAgent {
    public static final String CONFIG = "configuring";
    Hashtable routeTable = new Hashtable();
    private SocketKernel myInfo = null;
    private boolean alive = true;
    private RouterGUI gui;

    public RouterAgent(SocketKernel socketKernel) {
        this.myInfo = socketKernel;
    }

    public void live() {
        while (this.alive) {
            Message message = this.waitNextMessage();
            this.exitImmediatlyOnKill();
            if (!this.alive) break;
            if (message instanceof NetworkMessage) {
                this.handleNetworkMessage((NetworkMessage)message);
                continue;
            }
            if (message instanceof NetConfigMessage) {
                this.handleConfigMessage((NetConfigMessage)message);
                continue;
            }
            this.debug(message.toString());
        }
    }

    public void activate() {
        super.activate();
        this.setDebug(false);
        if (!this.isRole("public", "networking", "router")) {
            this.requestRole("public", "networking", "router", memberCard);
        }
        this.debug("Activated");
    }

    public void end() {
        this.debug("Router killed");
        super.end();
    }

    private void sendDistantMessage(KernelMessage kernelMessage) {
        KernelMessage kernelMessage2;
        Object object;
        if (kernelMessage instanceof KernelMessage) {
            object = kernelMessage;
            kernelMessage2 = (Message)object.getArgument();
        } else {
            kernelMessage2 = kernelMessage;
        }
        if (this.shouldUseUDP((Message)kernelMessage2)) {
            this.println("WARN:  No udp message routing yet!!!");
        } else {
            object = this.getP2PAddress((Message)kernelMessage2);
            if (object != null) {
                AgentAddress agentAddress = ((DistantKernelInformation)object).getP2PAgent();
                this.sendMessage(agentAddress, new NetworkMessage(6, kernelMessage2));
            } else {
                this.println("WARN : unknown destination kernel" + kernelMessage2.getReceiver().getKernel());
            }
        }
    }

    private DistantKernelInformation getP2PAddress(Message message) {
        DistantKernelInformation distantKernelInformation = (DistantKernelInformation)this.routeTable.get(message.getReceiver().getKernel().getID());
        return distantKernelInformation;
    }

    private AgentAddress getP2PAddress(KernelAddress kernelAddress) {
        DistantKernelInformation distantKernelInformation = (DistantKernelInformation)this.routeTable.get(kernelAddress.getID());
        return distantKernelInformation.getP2PAgent();
    }

    private boolean shouldUseUDP(Message message) {
        return message instanceof UDPMessage;
    }

    private boolean addRoute(KernelAddress kernelAddress, AgentAddress agentAddress, SocketKernel socketKernel, String string) {
        DistantKernelInformation distantKernelInformation = (DistantKernelInformation)this.routeTable.get(kernelAddress.getID());
        if (distantKernelInformation != null) {
            if (distantKernelInformation.getProtocol().equals(CONFIG)) {
                if (string.equals(CONFIG)) {
                    KernelAddress kernelAddress2 = distantKernelInformation.getDistantKernelAddress();
                    if (!kernelAddress2.getKernelName().equals(kernelAddress.getKernelName()) || kernelAddress2.supportMobility() != kernelAddress.supportMobility()) {
                        kernelAddress2.setKernelName(kernelAddress.getKernelName());
                        if (kernelAddress.supportMobility()) {
                            kernelAddress2.enableMobility();
                        } else {
                            kernelAddress2.disableMobility();
                        }
                        return true;
                    }
                    return false;
                }
                this.routeTable.remove(kernelAddress.getID());
                this.updateDistantAgencies();
            } else {
                this.debug("Kernel " + kernelAddress + " already added");
                return false;
            }
        }
        this.debug("adding new kernel " + kernelAddress.getID());
        this.routeTable.put(kernelAddress.getID(), new DistantKernelInformation(kernelAddress, agentAddress, socketKernel, string));
        this.updateDistantAgencies();
        if (!string.equals(CONFIG)) {
            this.sendConnectedKernelInformation(socketKernel, kernelAddress, agentAddress, string);
        }
        return true;
    }

    private void updateDistantAgencies() {
        Vector<KernelAddress> vector = new Vector<KernelAddress>(1, 1);
        for (DistantKernelInformation distantKernelInformation : this.routeTable.values()) {
            vector.addElement(distantKernelInformation.getDistantKernelAddress());
        }
        this.sendMessage(this.getAgentWithRole("system", "AgencyKeeper"), (Message)new NetworkRequest(13, vector));
    }

    private void replyConnect(AgentAddress agentAddress) {
        this.sendMessage(agentAddress, new NetworkMessage(1, new HashSet(this.routeTable.values())));
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
        switch (networkMessage.getType()) {
            case 0: {
                this.debug("handling NetworkMessage.SYNCH_REQUEST");
                Vector vector = (Vector)networkMessage.getArgument();
                this.handleSynchRequest(networkMessage.getSender(), vector);
                break;
            }
            case 7: {
                this.debug("Routing message");
                this.sendDistantMessage((KernelMessage)networkMessage.getArgument());
                break;
            }
            case 8: {
                this.debug("CONNECT_KERNEL received");
                Vector vector = (Vector)networkMessage.getArgument();
                Socket socket = (Socket)vector.get(0);
                KernelAddress kernelAddress = (KernelAddress)vector.get(1);
                SocketKernel socketKernel = (SocketKernel)vector.get(2);
                if (kernelAddress != null && this.routeTable.containsKey(kernelAddress)) {
                    this.debug("broadcast from known kernel");
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        this.debug(iOException.toString());
                    }
                    break;
                }
                this.launchNetConfigConnection(socketKernel, socket, kernelAddress);
                break;
            }
            case 3: {
                this.routeTable.remove(((KernelAddress)networkMessage.getArgument()).getID());
                break;
            }
            case 11: {
                this.debug("UPDATE_ROUTE");
                Vector vector = (Vector)networkMessage.getArgument();
                KernelAddress kernelAddress = (KernelAddress)vector.get(0);
                AgentAddress agentAddress = (AgentAddress)vector.get(1);
                DistantKernelInformation distantKernelInformation = (DistantKernelInformation)this.routeTable.remove(kernelAddress.getID());
                distantKernelInformation.setP2PAgent(agentAddress);
                distantKernelInformation.setProtocol((String)vector.get(2));
                this.routeTable.put(kernelAddress.getID(), distantKernelInformation);
                this.sendMessage(this.getAgentWithRole("public", "networking", "netagent"), new NetworkMessage(11, vector));
                this.sendMessage(networkMessage.getSender(), new NetworkMessage(12, kernelAddress));
                break;
            }
            default: {
                this.debug("unknown NetworkMessage Received");
                this.debug(networkMessage.toString());
            }
        }
    }

    private void handleSynchRequest(AgentAddress agentAddress, Vector vector) {
        Enumeration enumeration = vector.elements();
        KernelAddress kernelAddress = (KernelAddress)enumeration.nextElement();
        SocketKernel socketKernel = (SocketKernel)enumeration.nextElement();
        AgentAddress agentAddress2 = (AgentAddress)enumeration.nextElement();
        String string = (String)enumeration.nextElement();
        Collection collection = (Collection)enumeration.nextElement();
        if (this.addRoute(kernelAddress, agentAddress, socketKernel, string)) {
            this.replyConnect(agentAddress);
            for (Object e : collection) {
                Serializable serializable;
                if (e instanceof DistantKernelInformation) {
                    serializable = (DistantKernelInformation)e;
                    if (this.myKernel.getKernel().getID().equals(((DistantKernelInformation)serializable).getDistantKernelAddress().getID()) || this.isConfiguring(((DistantKernelInformation)serializable).getDistantKernelAddress()) || this.isKnownKernelSocket(((DistantKernelInformation)serializable).getSocketKernel())) continue;
                    this.launchNetConfigConnection(((DistantKernelInformation)serializable).getSocketKernel(), null, ((DistantKernelInformation)serializable).getDistantKernelAddress());
                    continue;
                }
                if (!(e instanceof SocketKernel) || this.myInfo.equals((SocketKernel)(serializable = (SocketKernel)e)) || this.isKnownKernelSocket((SocketKernel)serializable)) continue;
                this.launchNetConfigConnection((SocketKernel)serializable, null, null);
            }
        } else {
            this.debug("Adding Route failed");
            if (!agentAddress.equals((Object)this.getP2PAddress(kernelAddress))) {
                this.sendMessage(agentAddress, new NetworkMessage(9, null));
            }
        }
    }

    private boolean isConfiguring(KernelAddress kernelAddress) {
        return this.routeTable.containsKey(kernelAddress.getID());
    }

    private void launchNetConfigConnection(SocketKernel socketKernel, Socket socket, KernelAddress kernelAddress) {
        try {
            if (socket == null) {
                socket = new Socket(socketKernel.getHost(), socketKernel.getPort());
            }
            NetConfigAgent netConfigAgent = new NetConfigAgent(socket, this.myInfo, socketKernel, new HashSet(this.routeTable.values()));
            String string = "netconfigAgent@";
            if (socketKernel != null) {
                string = string + socketKernel.getHost() + socketKernel.getPort();
            }
            this.launchAgent((AbstractAgent)netConfigAgent, string, false);
            if (kernelAddress != null) {
                System.err.println("This agent will be connected to me ! " + kernelAddress.getInformation());
            }
            this.pause(500);
        }
        catch (UnknownHostException unknownHostException) {
            this.debug("UnknownHostException caught " + unknownHostException);
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException);
        }
        catch (Exception exception) {
            System.err.println("Connexion failed for this reason : " + exception.getMessage());
        }
    }

    private boolean isKnownKernelSocket(SocketKernel socketKernel) {
        for (DistantKernelInformation distantKernelInformation : this.routeTable.values()) {
            if (!distantKernelInformation.getSocketKernel().equals(socketKernel)) continue;
            return true;
        }
        return false;
    }

    protected void sendConnectedKernelInformation(SocketKernel socketKernel, KernelAddress kernelAddress, AgentAddress agentAddress, String string) {
        AgentAddress agentAddress2 = this.getAgentWithRole("public", "networking", "netagent");
        Vector<String> vector = new Vector<String>();
        vector.add(socketKernel.getHost() + ":" + socketKernel.getPort());
        vector.add((String)kernelAddress);
        vector.add((String)agentAddress);
        vector.add(string);
        this.sendMessage(agentAddress2, new NetworkMessage(2, vector));
    }
}

