/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import madkit.kernel.AgentAddress;
import madkit.kernel.InvalidAddressException;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;
import madkit.kernel.NetworkRequest;
import madkit.netcomm.Codec;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.UDPServerAgent;

abstract class P2PAgent
extends MadkitNetworkAgent {
    protected KernelAddress distantKernel;
    protected DataOutputStream out = null;
    protected DataInputStream in = null;

    P2PAgent() {
    }

    public void activate() {
        super.activate();
        this.requestRole("public", "networking", "p2pagent", memberCard);
    }

    protected final void injectMessage(Message message) {
        this.sendMessage(this.myKernel, (Message)new NetworkRequest(7, (Object)message));
    }

    protected boolean canStandBy() {
        return false;
    }

    protected void sendDisconnectedKernelInformation(KernelAddress kernelAddress) {
        AgentAddress agentAddress = this.getAgentWithRole("public", "networking", "netagent");
        this.sendMessage(agentAddress, new NetworkMessage(3, kernelAddress));
        agentAddress = this.getAgentWithRole("public", "networking", "router");
        this.sendMessage(agentAddress, new NetworkMessage(3, kernelAddress));
    }

    protected void openInputOutputStreams(Socket socket) {
        try {
            this.out = new DataOutputStream(socket.getOutputStream());
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (IOException iOException) {
            this.debug("IOException caught : " + iOException.getMessage());
        }
    }

    protected void sendObject(Object object) {
        try {
            byte[] byArray = Codec.encode(object);
            this.out.writeInt(byArray.length);
            this.out.flush();
            this.out.write(byArray);
            this.out.flush();
            this.bytesSent(byArray.length);
        }
        catch (IOException iOException) {
            this.println("Unable to send TCP message to " + this.distantKernel.getID() + " = " + iOException);
            this.closeSocket();
        }
    }

    protected KernelAddress exchangeKernelInformation(Socket socket) throws IOException, InvalidAddressException {
        int n;
        if (this.myKernel == null) {
            this.myKernel = this.getAgentWithRole("public", "communications", "site");
        }
        String string = this.myKernel.getKernel().getID();
        this.out.writeInt(string.length());
        this.out.writeChars(string);
        this.out.flush();
        this.out.writeInt(UDPServerAgent.getPort());
        this.out.flush();
        int n2 = this.in.readInt();
        string = "";
        for (n = 0; n < n2; ++n) {
            string = string + this.in.readChar();
        }
        n = this.in.readInt();
        KernelAddress kernelAddress = new KernelAddress(socket.getInetAddress().getHostName() + ":" + string.toString());
        this.debug("requesting kernel: " + kernelAddress);
        if (string.equals(this.myKernel.getLocalID())) {
            this.debug("trying to add my own kernel");
            return null;
        }
        return kernelAddress;
    }

    protected abstract void closeSocket();

    protected abstract String getProtocol();

    void receiveIncomming() {
    }

    protected Object receiveObject() throws IOException, ClassNotFoundException {
        this.debug("Waiting incomming data");
        int n = this.in.readInt();
        this.debug("R:done " + n + " preparing array");
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.in.readFully(byArray);
        Object object = Codec.decode(byArray);
        this.bytesReceived(n);
        return object;
    }

    protected final void fowardToKernel(Message message) {
        AgentAddress agentAddress = this.getAgentWithRole("public", "networking", "netagent");
        this.sendMessage(agentAddress, new NetworkMessage(5, message));
    }
}

