/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.InvalidAddressException;
import madkit.kernel.KernelAddress;
import madkit.netcomm.Codec;
import madkit.netcomm.CommunicatorAgent;
import madkit.netcomm.MadkitNetworkAgent;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.Protocollnformation;
import madkit.netcomm.SimpleSSLAgent;
import madkit.netcomm.SocketDynamicConnection;
import madkit.netcomm.SocketKernel;
import madkit.netcomm.UDPServerAgent;
import madkit.netcomm.rules.ConnectionRules;
import madkit.netcomm.rules.Rule;

class NetConfigAgent
extends MadkitNetworkAgent {
    public static final int MADKIT_BROADCAST = -31337;
    public static final int MADKIT_CONFIG = -99;
    private static final String REFUSE_STRING = "REFUSE:";
    private static final int CHECK_PROTO = 0;
    private static final int OLD_PROTO = 1;
    private static final int GET_BEST_PROTO = 2;
    private static final int CONFIG_PROTO = 3;
    private static Hashtable _configuring = new Hashtable();
    private int size;
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private boolean passive;
    private boolean alive = true;
    private Rule rule;
    private SocketKernel myInfo;
    private HashSet dKernels = null;
    private String protocolToUse = null;
    private int stage = 0;

    public NetConfigAgent(Socket socket, SocketKernel socketKernel, SocketKernel socketKernel2) {
        this(socket, socketKernel, socketKernel2, null);
        this.passive = true;
    }

    public NetConfigAgent(Socket socket, SocketKernel socketKernel, SocketKernel socketKernel2, HashSet hashSet) {
        this.socket = socket;
        this.passive = false;
        this.myInfo = socketKernel;
        if (hashSet != null) {
            this.dKernels = (HashSet)hashSet.clone();
        }
        this.openInputOutputStreams(this.socket);
        this.loadRule();
    }

    private void openInputOutputStreams(Socket socket) {
        try {
            this.out = new DataOutputStream(socket.getOutputStream());
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
            this.alive = false;
        }
    }

    private void loadRule() {
        ConnectionRules connectionRules = ConnectionRules.getInstance();
        this.rule = connectionRules.getRule(this.socket.getInetAddress().getHostName());
        if (this.rule.getAction() == 1) {
            this.closeSocket();
        }
    }

    public void live() {
        while (this.alive) {
            try {
                switch (this.stage) {
                    case 0: {
                        this.debug("CHECK_PROTO");
                        this.tryNewProtocols();
                        break;
                    }
                    case 1: {
                        this.oldProtocolConfig(this.size);
                        break;
                    }
                    case 2: {
                        this.debug("GET_BEST_PROTO");
                        this.negociateProtocol();
                        break;
                    }
                    case 3: {
                        this.debug("CONFIG_PROTO");
                        this.configProtocol();
                        break;
                    }
                    default: {
                        this.debug("Unknown stage");
                        this.alive = false;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                this.println("Configuration Error: Exception caught . No P2PAgent launched");
                this.alive = false;
            }
            catch (InvalidAddressException invalidAddressException) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    private void configProtocol() {
        if (this.protocolToUse != null) {
            if (this.protocolToUse.equals("communicatorprotocol")) {
                this.stage = 1;
            } else if (this.protocolToUse.equals("simplesslprotocol")) {
                try {
                    this.startSimpleSSL();
                }
                catch (IOException iOException) {
                    this.debug("IOException caught " + iOException.getMessage());
                }
                catch (InvalidAddressException invalidAddressException) {
                    this.debug("InvalidAddressException caught " + invalidAddressException.getMessage());
                }
            } else if (this.protocolToUse.equals("multipleSocketv1")) {
                Vector<Object> vector = new Vector<Object>();
                vector.add(this.socket);
                vector.add(this.dKernels);
                this.debug("Finding agent for multipleSocketv1");
                AgentAddress agentAddress = this.getAgentWithRole("public", "networking", "multipleSocketv1");
                if (agentAddress != null) {
                    this.debug("Requesting to add Handler");
                    this.closeInputOuput();
                    this.sendMessage(agentAddress, new NetworkMessage(10, vector));
                } else {
                    this.debug("No agent handle multipleSocketv1");
                    SocketDynamicConnection socketDynamicConnection = new SocketDynamicConnection(this.myInfo);
                    this.launchAgent((AbstractAgent)socketDynamicConnection, "multipleSocketv1", false);
                    this.pause(600);
                    agentAddress = this.getAgentWithRole("public", "networking", "multipleSocketv1");
                    this.sendMessage(agentAddress, new NetworkMessage(10, vector));
                }
                this.alive = false;
            }
        } else {
            this.debug("Unable to connect - No protocolToUse");
            this.closeSocket();
        }
    }

    private void closeInputOuput() {
        this.in = null;
        this.out = null;
    }

    private void startSimpleSSL() throws IOException, InvalidAddressException {
        KernelAddress kernelAddress = this.exchangeKernelInformation();
        if (kernelAddress == null) {
            this.closeSocket();
            return;
        }
        if (this.dKernels == null) {
            this.debug("launching in passive mode!");
            this.launchAgent((AbstractAgent)new SimpleSSLAgent(kernelAddress, this.socket, this.myInfo), "SimpleSSLAgent", false);
        } else {
            this.launchAgent((AbstractAgent)new SimpleSSLAgent(kernelAddress, this.socket, this.myInfo, this.dKernels), "SimpleSSLAgent", false);
        }
        this.alive = false;
    }

    private KernelAddress exchangeKernelInformation() throws IOException, InvalidAddressException {
        int n;
        String string = this.myKernel.getKernel().getID();
        this.out.writeInt(string.length());
        this.out.writeChars(string);
        this.out.writeInt(UDPServerAgent.getPort());
        this.out.flush();
        this.debug("Local information sent. ID: " + string);
        int n2 = this.in.readInt();
        string = "";
        for (n = 0; n < n2; ++n) {
            string = string + this.in.readChar();
        }
        n = this.in.readInt();
        KernelAddress kernelAddress = new KernelAddress(this.socket.getInetAddress().getHostName() + ":" + string.toString());
        if (string.equals(this.myKernel.getLocalID())) {
            this.debug("trying to add my own kernel");
            return null;
        }
        return kernelAddress;
    }

    private void negociateProtocol() {
        if (this.dKernels == null) {
            Protocollnformation protocollnformation = this.receiveProtocols();
            if (protocollnformation.refused()) {
                this.informRemoteRefuse(protocollnformation);
            }
            if (this.rule.getAction() == 2) {
                String string = REFUSE_STRING + (String)this.rule.getArgument();
                this.sendObject(string);
                this.closeSocket();
                return;
            }
            if (protocollnformation == null) {
                this.closeSocket();
                return;
            }
            this.protocolToUse = this.rule.getProtocolInformation().getBestProtocol(protocollnformation);
            if (this.protocolToUse == null) {
                this.println("Negotiation failed!!");
                this.closeSocket();
            } else {
                this.sendObject(this.protocolToUse);
            }
        } else {
            this.sendObject(this.rule.getProtocolInformation());
            this.protocolToUse = this.receiveProtocolToUse();
            if (this.protocolToUse != null && this.protocolToUse.startsWith(REFUSE_STRING)) {
                this.informRemoteRefuse(this.protocolToUse.substring(REFUSE_STRING.length()));
            }
        }
        this.stage = 3;
    }

    private void informRemoteRefuse(Protocollnformation protocollnformation) {
        String string = protocollnformation.refuseReason();
        this.informRemoteRefuse(string);
    }

    private void informRemoteRefuse(String string) {
        this.println("Connection with " + this.socket.getInetAddress().getHostName() + " was refused by remote host");
        this.println("Reason: " + string);
        this.closeSocket();
    }

    private String receiveProtocolToUse() {
        try {
            Object object = this.receiveObject();
            if (object instanceof String) {
                return (String)object;
            }
            this.println("Negotiation failed!!");
            this.closeSocket();
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("ClassNotFoundException caught " + classNotFoundException.getMessage());
        }
        return null;
    }

    private Protocollnformation receiveProtocols() {
        try {
            Object object = this.receiveObject();
            if (object instanceof Protocollnformation) {
                return (Protocollnformation)object;
            }
            this.debug("Unknown object type received in negotiation");
            this.closeSocket();
        }
        catch (IOException iOException) {
            this.debug("IOException -  unable to read input " + iOException.getMessage());
            this.closeSocket();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("ClassNotFoundException caught " + classNotFoundException.getMessage());
        }
        return null;
    }

    private Object receiveObject() throws IOException, ClassNotFoundException {
        this.debug("Reading incomming size");
        int n = this.in.readInt();
        this.debug("R:done " + n + " preparing array");
        byte[] byArray = new byte[n];
        this.in.readFully(byArray);
        return Codec.decode(byArray);
    }

    private void sendObject(Object object) {
        try {
            byte[] byArray = Codec.encode(object);
            this.out.writeInt(byArray.length);
            this.out.flush();
            this.out.write(byArray);
            this.out.flush();
        }
        catch (IOException iOException) {
            this.println("Error in configuration");
            this.closeSocket();
        }
    }

    private void closeSocket() {
        this.debug("Closing Socket");
        this.alive = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean tryNewProtocols() {
        this.debug("role in connection: " + (this.passive ? "passive" : "active"));
        try {
            if (this.dKernels != null) {
                this.out.writeInt(-99);
                this.out.flush();
                this.debug("new proto id sent, waiting response");
            }
            this.size = this.in.readInt();
            if (this.size < 0) {
                if (this.passive) {
                    this.out.writeInt(-99);
                    this.out.flush();
                }
                this.stage = 2;
                return true;
            }
            if (!this.passive) {
                this.socket.close();
                this.socket = new Socket(this.socket.getInetAddress(), this.socket.getPort());
                this.openInputOutputStreams(this.socket);
                this.size = this.in.readInt();
            }
            this.stage = 1;
            return false;
        }
        catch (IOException iOException) {
            this.closeSocket();
            return false;
        }
    }

    private void oldProtocolConfig(int n) throws IOException, InvalidAddressException {
        int n2;
        if (!this.rule.contains("communicatorprotocol")) {
            this.closeSocket();
            return;
        }
        this.debug("Old Communicator's protocol initiated");
        String string = this.myKernel.getKernel().getID();
        this.out.writeInt(string.length());
        this.out.writeChars(string);
        this.out.writeInt(UDPServerAgent.getPort());
        this.out.flush();
        this.debug("Local information sent. ID: " + string);
        if (n < 0) {
            n = this.in.readInt();
        }
        string = "";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + this.in.readChar();
        }
        n2 = this.in.readInt();
        KernelAddress kernelAddress = new KernelAddress(this.socket.getInetAddress().getHostName() + ":" + string.toString());
        if (string.equals(this.myKernel.getLocalID())) {
            this.debug("trying to add my own kernel");
            return;
        }
        if (this.passive) {
            this.launchAgent((AbstractAgent)new CommunicatorAgent(kernelAddress, this.socket, this.myInfo), "CommunicatorAgent", false);
        } else {
            this.launchAgent((AbstractAgent)new CommunicatorAgent(kernelAddress, this.socket, this.myInfo, this.dKernels), "CommunicatorAgent", false);
        }
        this.alive = false;
    }

    public void activate() {
        super.activate();
    }

    public void end() {
        super.end();
        System.gc();
    }

    protected void handleNetworkMessage(NetworkMessage networkMessage) {
    }
}

