/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import madkit.kernel.AbstractAgent;
import madkit.netcomm.NetAgent;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.RouterAgent;
import madkit.netcomm.RouterGUI;
import madkit.netcomm.StatsAgent;

final class NetAgentGUI
extends JTabbedPane {
    private NetAgent _agent;
    private JLabel _state;
    private RouterAgent _router;
    private RouterGUI _routergui;
    private JPanel mainPanel;

    public NetAgentGUI(NetAgent netAgent, RouterAgent routerAgent) {
        this._agent = netAgent;
        this._router = routerAgent;
        this.mainPanel = new JPanel(new BorderLayout());
        this._state = new JLabel("State: ");
        JPanel jPanel = new JPanel();
        final JTextField jTextField = new JTextField(20);
        final JSpinner jSpinner = new JSpinner();
        jSpinner.setValue(new Integer(4444));
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                int n = (Integer)jSpinner.getValue();
                NetAgentGUI.this._agent.connectKernel(string, n);
            }
        });
        jPanel.add(jTextField);
        jPanel.add(jSpinner);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(this._state);
        jPanel2.add(jPanel);
        this.mainPanel.setPreferredSize(new Dimension(300, 250));
        this.mainPanel.add((Component)jPanel2, "North");
        this._routergui = new RouterGUI(this._router);
        this.mainPanel.add((Component)this._routergui, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder("Control"));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JButton jButton2 = new JButton("Refresh");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetAgentGUI.this._routergui.updateRoutes();
            }
        });
        jPanel3.add(jButton2);
        final JButton jButton3 = new JButton("Verbose");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NetAgentGUI.this._agent.getDebug()) {
                    NetAgentGUI.this._agent.sendDebug(false);
                    jButton3.setText("Verbose");
                    System.out.println("NetAgent: quiet mode");
                } else {
                    NetAgentGUI.this._agent.sendDebug(true);
                    jButton3.setText("Quiet");
                    System.out.println("NetAgent: verbose mode");
                }
            }
        });
        jPanel3.add(jButton3);
        JSeparator jSeparator = new JSeparator();
        jPanel3.add(jSeparator);
        JButton jButton4 = new JButton("BroadCast");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetAgentGUI.this._agent.madkitBroadcast();
            }
        });
        jPanel3.add(jButton4);
        this.mainPanel.add((Component)jPanel3, "East");
        this.add("Connections", this.mainPanel);
        StatsAgent statsAgent = new StatsAgent(NetConfigMessage.isEnableStat());
        this._agent.setStats(statsAgent);
        statsAgent.initGUI();
        this._agent.launchAgent((AbstractAgent)statsAgent, "StatsAgent", false);
        if (statsAgent.getGUIObject() != null) {
            this.add("Monitor", (JPanel)statsAgent.getGUIObject());
        }
    }

    public void kernelConnected(NetworkMessage networkMessage) {
        this._routergui.updateRoutes();
    }

    public void kernelDisconnected(NetworkMessage networkMessage) {
        this._routergui.updateRoutes();
    }

    public void updateKernel(NetworkMessage networkMessage) {
        this._routergui.updateRoutes();
    }

    public void setStatus(String string) {
        this._state.setText("State: " + string);
    }
}

