/*
 * Decompiled with CFR 0.152.
 */
package madkit.netcomm;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;
import madkit.kernel.NetworkRequest;
import madkit.netcomm.DistantKernelInformation;
import madkit.netcomm.InputProcessor;
import madkit.netcomm.NetConfigMessage;
import madkit.netcomm.NetworkMessage;
import madkit.netcomm.P2PAgent;
import madkit.netcomm.SocketKernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommunicatorAgent
extends P2PAgent {
    protected Socket socket;
    private boolean alive = true;
    protected InputProcessor input;
    protected SocketKernel myInfo;
    protected HashSet dKernels = null;

    public CommunicatorAgent(KernelAddress kernelAddress, Socket socket, SocketKernel socketKernel) {
        this.socket = socket;
        this.myInfo = socketKernel;
        if (this.socket.isClosed()) {
            throw new IllegalArgumentException("Can not work with a closed socket");
        }
        this.distantKernel = kernelAddress;
    }

    public CommunicatorAgent(KernelAddress kernelAddress, Socket socket, SocketKernel socketKernel, HashSet hashSet) {
        this(kernelAddress, socket, socketKernel);
        this.dKernels = hashSet;
    }

    @Override
    public void activate() {
        super.activate();
        this.openInputOutputStreams(this.socket);
        this.myKernel = this.getAgentWithRole("communications", "site");
        this.debug(" Activated - connecting to " + this.distantKernel);
        this.input = new InputProcessor(this);
        this.input.start();
    }

    public void live() {
        if (this.dKernels != null) {
            this.sendObject(this.buildSynch('c', this.dKernels));
        }
        while (this.alive) {
            this.exitImmediatlyOnKill();
            Message message = this.waitNextMessage();
            if (!this.alive) continue;
            if (message instanceof NetworkMessage) {
                this.handleNetworkMessage((NetworkMessage)message);
                continue;
            }
            if (message instanceof NetConfigMessage) {
                this.handleConfigMessage((NetConfigMessage)message);
                continue;
            }
            this.sendObject(message);
        }
        this.println("Connexion lost with " + this.distantKernel + ".");
    }

    @Override
    protected void closeSocket() {
        this.debug("Closing Socket");
        this.sendDisconnectedKernelInformation(this.distantKernel);
        try {
            this.alive = false;
            if (!this.input.isStopped()) {
                this.input.stop();
            }
            this.pause(10);
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void end() {
        this.debug("Communicator agent finished");
        this.closeSocket();
    }

    @Override
    protected void handleNetworkMessage(NetworkMessage networkMessage) {
        switch (networkMessage.getType()) {
            case 1: {
                this.debug("SYNCH_REQUEST_REPLY received");
                this.sendObject(this.buildSynch('r', (HashSet)networkMessage.getArgument()));
                break;
            }
            case 4: {
                this.debug("Request to Disconnect received");
                this.closeSocket();
                break;
            }
            case 6: {
                this.sendObject(networkMessage.getArgument());
                break;
            }
            case 9: {
                this.debug("DIE received");
                this.closeSocket();
                break;
            }
            default: {
                this.debug("UnKnown Message Type");
                this.debug(networkMessage.toString());
            }
        }
    }

    @Override
    void receiveIncomming() {
        try {
            Object object = null;
            object = this.receiveObject();
            if (object instanceof Message) {
                Message message = (Message)object;
                this.injectMessage(message);
            } else if (object instanceof Vector) {
                this.requestSynch((Vector)object);
            }
        }
        catch (IOException iOException) {
            this.closeSocket();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("ClassNotFoundException : " + classNotFoundException.getMessage());
        }
    }

    private void requestSynch(Vector vector) {
        Object var2_2 = null;
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        String string = (String)enumeration.nextElement();
        AgentAddress agentAddress = (AgentAddress)vector.get(3);
        if (string.equals("ACK_SOCKET_INFO")) {
            this.debug("  ---------SocketCom--------- ACK_SOCKET_INFO ---- ");
        }
        if (string.equals("TRANSMIT_SOCKET_INFO")) {
            this.debug("  ---------SocketCom------- TRANSMIT_SOCKET_INFO ---- ");
        }
        vector2.add(vector.get(1));
        madkit.communicator.SocketKernel socketKernel = (madkit.communicator.SocketKernel)vector.get(2);
        vector2.add(new SocketKernel(socketKernel.getHost(), socketKernel.getPort()));
        vector2.add(vector.get(3));
        vector2.add(this.getProtocol());
        vector2.add(this.formatOtherKernels((Collection)vector.get(4)));
        this.sendMessage("public", "networking", "router", new NetworkMessage(0, vector2));
        if (string.equals("TRANSMIT_SOCKET_INFO")) {
            this.fowardToKernel((Message)new NetworkRequest(3, (Object)agentAddress));
        }
    }

    private Collection<SocketKernel> formatOtherKernels(Collection collection) {
        Vector<SocketKernel> vector = new Vector<SocketKernel>();
        for (madkit.communicator.SocketKernel socketKernel : collection) {
            vector.add(new SocketKernel(socketKernel.getHost(), socketKernel.getPort()));
        }
        return vector;
    }

    private Vector<Serializable> buildSynch(char c, HashSet hashSet) {
        Vector<Serializable> vector = new Vector<Serializable>();
        if (c == 'c') {
            vector.addElement((Serializable)((Object)"TRANSMIT_SOCKET_INFO"));
        } else if (c == 'r') {
            vector.addElement((Serializable)((Object)"ACK_SOCKET_INFO"));
        }
        vector.addElement((Serializable)this.getAddress().getKernel());
        madkit.communicator.SocketKernel socketKernel = new madkit.communicator.SocketKernel(this.myInfo.getHost(), this.myInfo.getPort());
        vector.addElement((Serializable)socketKernel);
        vector.addElement((Serializable)this.myKernel);
        Vector<madkit.communicator.SocketKernel> vector2 = new Vector<madkit.communicator.SocketKernel>();
        for (DistantKernelInformation distantKernelInformation : hashSet) {
            madkit.communicator.SocketKernel socketKernel2 = new madkit.communicator.SocketKernel(distantKernelInformation.getSocketKernel().getHost(), distantKernelInformation.getSocketKernel().getPort());
            vector2.add(socketKernel2);
        }
        vector.addElement(new HashSet(vector2));
        return vector;
    }

    @Override
    protected String getProtocol() {
        return "communicatorprotocol";
    }
}

