/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.pluginmanager.Action;
import madkit.pluginmanager.Utils;
import madkit.pluginmanager.Version;
import madkit.pluginmanager.XMLWriter;
import madkit.pluginmanager.actions.AbstractAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AddDocumentationReference
extends AbstractAction
implements Action {
    private String _section;
    private String _url;
    private String _name;
    private boolean _absoluteLink = false;
    private String _reason = "ok";
    private File _docsFile;
    private Document _docs;
    private static final String html_start = "<html><head><title>Madkit Documentation</title></head><body><h1>Madkit Documentation<h1>";

    public AddDocumentationReference(File file, String string, Version version) {
        super("adddocumentationreference", file, string, version);
        this._docsFile = new File(file.getAbsolutePath() + File.separatorChar + "cache" + File.separatorChar + "docs.xml");
    }

    public Collection requiredPlugins() {
        return new Vector();
    }

    public Collection getMandatoryParameters() {
        Vector<String> vector = new Vector<String>();
        vector.add("section");
        vector.add("url");
        vector.add("name");
        return vector;
    }

    public Collection getOptionalParameters() {
        Vector<String> vector = new Vector<String>();
        vector.add("absolute");
        return vector;
    }

    public void setParamenters(Properties properties) {
        this._section = properties.getProperty("section");
        this._url = properties.getProperty("url");
        this._name = properties.getProperty("name");
        this._absoluteLink = Boolean.valueOf(properties.getProperty("absolute"));
    }

    public boolean execute() {
        if (this._section == null || this._url == null || this._name == null) {
            this._reason = "Insufficient Parameters";
            return false;
        }
        if (!this._docsFile.exists()) {
            this.createDocumentationRef();
        }
        try {
            this._docs = this.openXMLDocument(this._docsFile);
            String string = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this._section, "::");
            this._section = stringTokenizer.nextToken();
            string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : this._section;
            NodeList nodeList = this._docs.getElementsByTagName("section");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (!element.getAttribute("name").equals(this._section)) continue;
                Element element2 = this._docs.createElement("docref");
                element2.setAttribute("plugin", this.getOwnerPlugin());
                element2.setAttribute("version", this.getOwnerPluginVersion().toString());
                element2.setAttribute("url", this._url);
                element2.setAttribute("name", this._name);
                element2.setAttribute("absolute", String.valueOf(this._absoluteLink));
                element.appendChild(element2);
            }
            return XMLWriter.saveDocument(this._docsFile, this._docs);
        }
        catch (SAXException sAXException) {
            this.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
        return false;
    }

    public String getFailureReason() {
        return this._reason;
    }

    private void createDocumentationRef() {
        String string = "<?xml version=\"1.0\"?><madkitdocs><section name=\"manual\" display=\"Manuals\"><docref absolute=\"false\" name=\"Content\" url=\"docs/index.html\"/><docref absolute=\"false\" name=\"User's guide\" url=\"docs/userguide/userguide.html\" /><docref absolute=\"false\" name=\"Developper's guide\" url=\"docs/devguide/devguide.html\" /></section><section name=\"api\" display=\"API\"></section></madkitdocs>";
        try {
            Utils.writeToFile(string, new FileOutputStream(this._docsFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
        }
    }

    private void generateHtmlIndex() throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        if (!this._docsFile.exists()) {
            this.createDocumentationRef();
        }
        if (this._docs == null) {
            this._docs = this.openXMLDocument(this._docsFile);
        }
        File file = new File(this._madkitDir.getAbsolutePath() + File.separatorChar + "docs" + File.separatorChar + "plugins.html");
        file.getParentFile().mkdirs();
        String string = html_start.toString();
        NodeList nodeList = this._docs.getElementsByTagName("section");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            string = string + "<h2>" + element.getAttribute("display") + "</h2><ul>";
            NodeList nodeList2 = element.getElementsByTagName("docref");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                string = string + this.getHtmlDocLink(element2);
            }
            string = string + "</ul><br>";
        }
        string = string + "</body><html>";
        Utils.writeToFile(string, new FileOutputStream(file));
    }

    private String getHtmlDocLink(Element element) {
        String string = "<li><a href=\"";
        string = Boolean.valueOf(element.getAttribute("absolute")) != false ? string + element.getAttribute("url") : string + "file://" + this._madkitDir.getAbsolutePath() + "/" + element.getAttribute("url");
        string = string + "\">" + element.getAttribute("name") + "</a></li>";
        return string;
    }

    private void removePlugin() throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        if (!this._docsFile.exists()) {
            return;
        }
        if (this._docs == null) {
            this._docs = this.openXMLDocument(this._docsFile);
        }
        NodeList nodeList = this._docs.getElementsByTagName("section");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName("docref");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                if (!element2.getAttribute("plugin").equals(this.getOwnerPlugin()) || !element2.getAttribute("version").equals(this.getOwnerPluginVersion().toString())) continue;
                element.removeChild(element2);
            }
        }
        XMLWriter.saveDocument(this._docsFile, this._docs);
    }

    public static final void generateHtmlDocumentation(File file) throws IOException {
        AddDocumentationReference addDocumentationReference = new AddDocumentationReference(file, null, null);
        try {
            addDocumentationReference.generateHtmlIndex();
        }
        catch (SAXException sAXException) {
            addDocumentationReference.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            addDocumentationReference.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            addDocumentationReference.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            addDocumentationReference.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
    }

    public static final void removePlugin(File file, String string, Version version) throws IOException {
        AddDocumentationReference addDocumentationReference = new AddDocumentationReference(file, string, version);
        try {
            addDocumentationReference.removePlugin();
        }
        catch (SAXException sAXException) {
            addDocumentationReference.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            addDocumentationReference.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            addDocumentationReference.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
    }

    public boolean shouldAskUser() {
        return false;
    }

    public String getQuestionToUser() {
        return " ";
    }
}

