/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import HTTPClient.AuthorizationPrompter;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.pluginmanager.DownloadFinished;
import madkit.pluginmanager.DownloadStatus;
import madkit.pluginmanager.MyAuthPrompter;
import madkit.pluginmanager.PluginInformation;
import madkit.pluginmanager.UpdateRoles;

class DownloadAgent
extends Agent
implements UpdateRoles {
    private static final String MADKTI_REALM = "Madkit-Plugin-Download";
    private PluginInformation _info = null;
    private boolean _done;
    private AgentAddress progress;
    private File _tmpDir;
    private String _fileName;
    private String _downloadURL;
    private String _server;

    public DownloadAgent(String string, String string2, File file) {
        this._server = string.toString();
        this._downloadURL = this._server + "/download.php?file=" + string2.toString();
        this._tmpDir = new File(file.getAbsolutePath() + File.separatorChar + "files");
        this._tmpDir.mkdirs();
        this._tmpDir.deleteOnExit();
    }

    public DownloadAgent(PluginInformation pluginInformation, File file) {
        this._info = pluginInformation;
        this._tmpDir = new File(file.getAbsolutePath() + File.separatorChar + "files");
        this._tmpDir.mkdirs();
        this._tmpDir.deleteOnExit();
    }

    public void activate() {
        this.requestRole("MadkitUpdate", "updater", "downloader", null);
    }

    static synchronized HTTPResponse getResponse(String string, URL uRL) {
        try {
            HTTPConnection hTTPConnection = new HTTPConnection(uRL);
            HTTPResponse hTTPResponse = hTTPConnection.Get(uRL.getFile());
            return hTTPResponse;
        }
        catch (IOException iOException) {
            System.err.println("Error: Failed to download file " + string + " due to " + iOException.getMessage());
        }
        catch (ModuleException moduleException) {
            System.err.println("ModuleException caught " + moduleException.getMessage());
        }
        return null;
    }

    public void live() {
        Object object;
        this.progress = this.getAgentWithRole("MadkitUpdate", "updater", "progress");
        int n = 0;
        if (this._info == null) {
            this._fileName = "cache" + File.separatorChar + "plugins.zip";
        } else {
            this._downloadURL = this._info.getDownloadURL();
            this._fileName = this._info.getFileName();
            if (this._fileName == null) {
                this.informDone(null);
                return;
            }
        }
        HTTPResponse hTTPResponse = null;
        int n2 = 300;
        for (int i = 0; n2 >= 300 && i < 3; ++i) {
            try {
                object = new URL(this._downloadURL);
                this.println("Starting download process with file : " + ((URL)object).getFile());
                DefaultAuthHandler.setAuthorizationPrompter((AuthorizationPrompter)new MyAuthPrompter());
                hTTPResponse = DownloadAgent.getResponse(this._fileName, (URL)object);
                n2 = hTTPResponse.getStatusCode();
                this.pause(50);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(new JFrame(), "Bad Server URL: " + this._downloadURL);
                return;
            }
            catch (IOException iOException) {
                if (iOException instanceof MalformedURLException) {
                    // empty if block
                }
                this.println("Error: Failed to download file due to " + iOException.getMessage());
                continue;
            }
            catch (ModuleException moduleException) {
                System.err.println("ModuleException caught " + moduleException.getMessage());
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error: Problem downloading " + this._fileName + "due to " + exception.getMessage());
            }
        }
        File file = null;
        if (n2 < 300 && hTTPResponse != null) {
            file = new File(this._tmpDir.getAbsolutePath() + File.separatorChar + this._fileName);
            if (file.exists()) {
                file.delete();
            } else {
                file.getParentFile().mkdirs();
            }
            try {
                int n3;
                object = new FileOutputStream(file);
                InputStream inputStream = hTTPResponse.getInputStream();
                byte[] byArray = new byte[1024];
                while ((n3 = inputStream.read(byArray)) > 0) {
                    ((FileOutputStream)object).write(byArray, 0, n3);
                    this.informStatus(n += n3);
                }
                inputStream.close();
                ((FileOutputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("??? File not found " + this._fileName);
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                System.err.println("IOException caught ");
            }
            catch (ModuleException moduleException) {
                System.err.println("ModuleException caught " + moduleException.getMessage());
                this.debug("ModuleException caught " + moduleException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("Error: Problem downloading " + this._fileName + "due to " + exception.getMessage());
            }
        } else {
            try {
                object = "???";
                if (hTTPResponse != null) {
                    object = hTTPResponse.getReasonLine();
                }
                this.println("Status code " + n2 + " because " + (String)object);
            }
            catch (IOException iOException) {
                this.debug("IOException caught " + iOException.getMessage());
            }
            catch (ModuleException moduleException) {
                this.debug("ModuleException caught " + moduleException.getMessage());
            }
        }
        this.informDone(file);
    }

    private void informDone(File file) {
        AgentAddress agentAddress = this.getAgentWithRole("MadkitUpdate", "updater", "pluginManagerAgent");
        if (this._info == null) {
            this.sendMessage(agentAddress, new DownloadFinished("plugins.zip", file, this._server));
        } else {
            this.sendMessage(agentAddress, new DownloadFinished(this._info.getName(), file, this._server));
            this.informStatus(this._info.getSize());
        }
    }

    private void informStatus(int n) {
        if (this.progress == null) {
            this.progress = this.getAgentWithRole("MadkitUpdate", "updater", "progress");
        }
        if (this.progress != null && this._info != null) {
            this.sendMessage(this.progress, new DownloadStatus(this._info.getName(), this._info.getSize(), n));
        }
    }
}

