/*
 * Decompiled with CFR 0.152.
 */
package madkit.linechart;

import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.linechart.LineChartMessage;
import madkit.linechart.linechartgui.LineChartGUI;

public class LineChartAgent
extends Agent {
    public LineChartGUI myGUI;
    public int width = 400;
    public int height = 300;

    public void initGUI() {
        this.myGUI = new LineChartGUI(this.width, this.height);
        this.setGUIObject(this.myGUI);
    }

    public void activate() {
        this.createGroup(true, "analyse", null, null);
        this.requestRole("analyse", "linechart agent", null);
        this.myGUI.init();
    }

    public void live() {
        while (true) {
            Message message;
            if ((message = this.waitNextMessage()) instanceof LineChartMessage) {
                this.handleMessage((LineChartMessage)message);
                continue;
            }
            System.err.println((Object)((Object)this) + " : I receive a message that I do not understand (not a LineChartMessage) :" + message);
        }
    }

    void handleMessage(LineChartMessage lineChartMessage) {
        switch (lineChartMessage.command) {
            case 0: {
                this.myGUI.addNewGraph(lineChartMessage.linechartName);
                this.myGUI.setGraphColor(lineChartMessage.linechartName, lineChartMessage.color);
            }
            case 1: {
                this.myGUI.drawPoint(lineChartMessage.linechartName, lineChartMessage.x, lineChartMessage.y);
            }
        }
    }

    public void setScaleX(int n) {
        this.myGUI.setScaleX(n);
    }

    public void setScaleY(int n) {
        this.myGUI.setScaleY(n);
    }

    public void setLineChartTitle(String string) {
        this.myGUI.setTitleGraph(string);
    }

    public void setXAxisName(String string) {
        this.myGUI.setTitleAxeX(string);
    }

    public void setYAxisName(String string) {
        this.myGUI.setTitleAxeY(string);
    }
}

