/*
 * Decompiled with CFR 0.152.
 */
package madkit.scheme;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import madkit.kernel.Agent;
import madkit.kernel.JTextAreaWriter;
import madkit.utils.graphics.GraphicUtils;
import madkit.utils.graphics.LoadDialog;

public abstract class SchemeAbstractEditorPanel
extends JRootPane
implements ActionListener {
    protected JTextArea inputArea;
    protected JTextArea outputArea;
    protected PrintWriter out;
    protected Agent ag;
    protected JToolBar toolBar;
    protected JMenuBar menubar;
    protected JPanel commandPanel;
    String dirName;
    String fileName;
    public static final boolean LOAD = true;
    public static final boolean SAVE = false;

    public PrintWriter stdout() {
        return this.out;
    }

    public PrintWriter stderr() {
        return this.out;
    }

    public InputStream stdin() {
        return System.in;
    }

    public JTextArea getInputArea() {
        return this.inputArea;
    }

    public JTextArea getOutputArea() {
        return this.outputArea;
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public JMenuBar getMenubar() {
        return this.menubar;
    }

    public SchemeAbstractEditorPanel(Agent agent) {
        this.ag = agent;
        this.menubar = new JMenuBar();
        this.setJMenuBar(this.menubar);
        JMenu jMenu = new JMenu("File");
        this.menubar.add(jMenu);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu, (String)"Open", (String)"openfile", (int)-1);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu, (String)"Save", (String)"save", (int)83, (int)83);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu, (String)"Save as", (String)"saveAs", (int)-1);
        JMenu jMenu2 = new JMenu("Edit");
        this.menubar.add(jMenu2);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu2, (String)"Cut", (String)"cut", (int)88, (int)88);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu2, (String)"Copy", (String)"copy", (int)67, (int)67);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu2, (String)"Paste", (String)"paste", (int)86, (int)86);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu2, (String)"Delete", (String)"delete", (int)127, (int)127);
        GraphicUtils.addMenuItem((ActionListener)this, (JMenu)jMenu2, (String)"Clear output", (String)"clear", (int)0, (int)0);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.commandPanel = new JPanel();
        this.commandPanel.setAlignmentX(0.0f);
        this.commandPanel.setAlignmentY(0.0f);
        this.commandPanel.setLayout(new FlowLayout(0));
        this.toolBar = new JToolBar();
        GraphicUtils.addTool((ActionListener)this, (JToolBar)this.toolBar, (String)"openfile", (String)"Open file", (String)"/toolbarButtonGraphics/general/Open24.gif");
        GraphicUtils.addTool((ActionListener)this, (JToolBar)this.toolBar, (String)"save", (String)"Save file", (String)"/toolbarButtonGraphics/general/Save24.gif");
        this.toolBar.addSeparator();
        GraphicUtils.addTool((ActionListener)this, (JToolBar)this.toolBar, (String)"cut", (String)"Cut", (String)"/toolbarButtonGraphics/general/Cut24.gif");
        GraphicUtils.addTool((ActionListener)this, (JToolBar)this.toolBar, (String)"copy", (String)"Copy", (String)"/toolbarButtonGraphics/general/Copy24.gif");
        GraphicUtils.addTool((ActionListener)this, (JToolBar)this.toolBar, (String)"paste", (String)"Paste", (String)"/toolbarButtonGraphics/general/Paste24.gif");
        this.commandPanel.add(this.toolBar);
        this.getContentPane().add("North", this.commandPanel);
        this.inputArea = new JTextArea(10, 40);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setSize(300, 200);
        jScrollPane.getViewport().add(this.inputArea);
        this.outputArea = new JTextArea(";; EditorAgent 1.1 (c) Madkit team\n", 10, 40);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setSize(300, 200);
        jScrollPane2.getViewport().add(this.outputArea);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(150);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.out = new PrintWriter((Writer)new JTextAreaWriter(this.outputArea), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.command(string);
    }

    public void command(String string) {
        if (string.equals("openfile")) {
            this.openFile();
        } else if (string.equals("save")) {
            this.save();
        } else if (string.equals("copy")) {
            this.inputArea.copy();
        } else if (string.equals("cut")) {
            this.inputArea.cut();
        } else if (string.equals("paste")) {
            this.inputArea.paste();
        } else if (string.equals("saveAs")) {
            this.saveAs();
        } else if (string.equals("clear")) {
            this.clear();
        }
    }

    public void clearOutputArea() {
        this.outputArea.setText("");
    }

    public Frame getFrameParent() {
        Container container = this;
        while (!(container instanceof Frame)) {
            if (container == null) {
                return null;
            }
            container = container.getParent();
        }
        return (Frame)container;
    }

    public boolean getFileDialog(boolean bl, String string, String string2) {
        LoadDialog loadDialog = new LoadDialog((Component)this, bl, string, string2);
        if (loadDialog.isFileChoosed()) {
            this.dirName = loadDialog.getDirName();
            this.fileName = loadDialog.getFileName();
            return true;
        }
        return false;
    }

    public void openFile() {
        if (this.getFileDialog(true, "Open file", "scm") && this.fileName != null) {
            try {
                String string = new String();
                String string2 = new String();
                FileInputStream fileInputStream = new FileInputStream(this.dirName + this.fileName);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while (string2 != null) {
                    string2 = bufferedReader.readLine();
                    if (string2 == null) continue;
                    string = string + string2 + "\n";
                }
                this.inputArea.setText(string);
            }
            catch (Exception exception) {
                System.out.println("Cannot open file " + this.fileName);
            }
        }
    }

    public void saveAs() {
        if (this.getFileDialog(false, "Save file", "scm")) {
            this.save1(true);
        }
    }

    public void save() {
        if (this.fileName == null) {
            this.saveAs();
        } else {
            this.save1(true);
        }
    }

    void save1(boolean bl) {
        if (bl) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.dirName + this.fileName));
                String string = this.inputArea.getText();
                printWriter.print(string);
                printWriter.flush();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("saveContent: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println("saveContent: " + iOException);
            }
            System.out.println(":: file " + this.fileName + " saved");
        }
    }

    public void clear() {
        this.clearOutputArea();
    }

    public void print(String string) {
        this.stdout().print(string);
    }

    public void println(String string) {
        this.stdout().println(string);
    }
}

