/*
 * Decompiled with CFR 0.152.
 */
package madkit.jess;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import madkit.jess.EditorSetTargetDialog;
import madkit.jess.JessMonitor;
import madkit.kernel.AbstractAgent;
import madkit.utils.agents.AbstractEditorPanel;

class JessMonitorPanel
extends AbstractEditorPanel {
    boolean[] watchItems = new boolean[]{false, false, false, false};
    protected JPanel commandPanel;
    JLabel currentTargetLabel;

    JessMonitorPanel(JessMonitor jessMonitor) {
        super((AbstractAgent)jessMonitor);
        JMenuBar jMenuBar = this.getMenubar();
        JMenu jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Launch", (String)"launch", (int)74, (int)76);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Select", (String)"select", (int)74, (int)-1);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Run", (String)"run", (int)74, (int)74);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Halt", (String)"halt", (int)84, (int)84);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Facts", (String)"facts", (int)70, (int)70);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Rules", (String)"rules", (int)82, (int)82);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Reset", (String)"reset", (int)68, (int)68);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Reset", (String)"reset", (int)68, (int)68);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Re-init", (String)"reinit", (int)89, (int)89);
        JessMonitorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Eval buffer", (String)"evalBuffer", (int)66, (int)66);
        JToolBar jToolBar = this.getToolbar();
        jToolBar.addSeparator();
        this.addTool(jToolBar, "launch", "Launch", "/images/toolbars/launch.gif");
        this.addTool(jToolBar, "select", "Select", "/images/toolbars/settarget.gif");
        jToolBar.addSeparator();
        this.addTool(jToolBar, "run", "Run", "/images/toolbars/run.gif");
        this.addTool(jToolBar, "halt", "Halt", "/images/toolbars/halt.gif");
        this.addTool(jToolBar, "facts", "Facts", "/images/toolbars/facts.gif");
        this.addTool(jToolBar, "rules", "Rules", "/images/toolbars/rules.gif");
        this.addTool(jToolBar, "reset", "Reset", "/images/toolbars/reset.gif");
        this.addTool(jToolBar, "reinit", "Re-init", "/images/toolbars/reinit.gif");
        this.addTool(jToolBar, "watch", "Watch all", "/images/toolbars/watch.gif");
        this.addTool(jToolBar, "unwatch", "Unwatch all", "/images/toolbars/unwatch.gif");
        jToolBar.addSeparator();
        this.addTool(jToolBar, "evalBuffer", "Send buffer", "/images/toolbars/sendbuf.gif");
        this.addTool(jToolBar, "evalSelection", "Send selection", "/images/toolbars/sendsel.gif");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "South");
        this.currentTargetLabel = new JLabel("Target : none");
        jPanel.add((Component)this.currentTargetLabel, "West");
    }

    public void println(String string) {
        this.stdout().println(string);
    }

    void setRecipientLabel(String string) {
        this.currentTargetLabel.setText("Target : " + string);
    }

    public void command(String string) {
        if (string.equals("evalBuffer")) {
            this.evalBuffer();
        } else if (string.equals("evalSelection")) {
            this.evalSelection();
        } else if (string.equals("run")) {
            ((JessMonitor)this.ag).sendControlMessage("run");
        } else if (string.equals("halt")) {
            ((JessMonitor)this.ag).sendControlMessage("halt");
        } else if (string.equals("reset")) {
            ((JessMonitor)this.ag).sendControlMessage("reset");
        } else if (string.equals("facts")) {
            ((JessMonitor)this.ag).sendControlMessage("facts");
        } else if (string.equals("rules")) {
            ((JessMonitor)this.ag).sendControlMessage("rules");
        } else if (string.equals("reinit")) {
            ((JessMonitor)this.ag).sendControlMessage("reinit");
        } else if (string.equals("watch")) {
            ((JessMonitor)this.ag).sendControlMessage("watch", "all");
        } else if (string.equals("unwatch")) {
            ((JessMonitor)this.ag).sendControlMessage("unwatch", "all");
        } else if (string.equals("load")) {
            this.loadFile();
        } else if (string.equals("launch")) {
            this.launchJessFromFile();
        } else if (string.equals("select")) {
            this.selectTarget();
        } else {
            super.command(string);
        }
    }

    void selectTarget() {
        new EditorSetTargetDialog((JessMonitor)this.ag);
    }

    void evalBuffer() {
        String string = this.inputArea.getText();
        ((JessMonitor)this.ag).sendControlMessage("eval", string);
    }

    void evalSelection() {
        String string = this.inputArea.getSelectedText();
        ((JessMonitor)this.ag).sendControlMessage("eval", string);
    }

    void loadFile() {
        if (this.getFileDialog(true, "Load file", "clp") && this.getCurrentFile() != null) {
            ((JessMonitor)this.ag).sendControlMessage("load", this.getCurrentFile());
        }
    }

    void launchJessFromFile() {
        if (this.getFileDialog(true, "Launch File", "clp") && this.getCurrentFile() != null) {
            ((JessMonitor)this.ag).launch(this.getCurrentFile());
        }
    }
}

