/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import turtlekit.kernel.Turtle;
import turtlekit.kernel.TurtleEnvironment;

public final class Patch {
    TurtleEnvironment world;
    double diffusion;
    double[] variableValue;
    Hashtable marks = null;
    transient Patch[] neighbors;
    Collection turtlesHere = new HashSet();
    Color color;
    boolean change = true;

    public Patch(TurtleEnvironment turtleEnvironment) {
        this.world = turtleEnvironment;
        this.color = Color.black;
    }

    final void setNeighborhood(Patch[] patchArray) {
        this.neighbors = patchArray;
    }

    final void update(int n) {
        for (int i = 0; i < this.neighbors.length; ++i) {
            int n2 = n;
            this.variableValue[n2] = this.variableValue[n2] + this.neighbors[i].diffusion;
        }
    }

    final void removeAgent(Turtle turtle) {
        this.change = true;
        this.turtlesHere.remove((Object)turtle);
    }

    final void addAgent(Turtle turtle) {
        this.turtlesHere.add(turtle);
        turtle.position = this;
    }

    final int getVariableIndex(String string) {
        return (Integer)this.world.variables.get(string);
    }

    public final void setPatchVariable(String string, double d) {
        this.change = true;
        this.variableValue[this.getVariableIndex((String)string)] = d;
    }

    public final void incrementPatchVariable(String string, double d) {
        this.change = true;
        int n = this.getVariableIndex(string);
        this.variableValue[n] = this.variableValue[n] + d;
    }

    public final double getVariableValue(String string) {
        return this.variableValue[this.getVariableIndex(string)];
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
        this.change = true;
    }

    final synchronized Turtle[] getOtherTurtles(Turtle turtle) {
        HashSet hashSet = new HashSet(this.turtlesHere);
        hashSet.remove((Object)turtle);
        return hashSet.toArray(new Turtle[0]);
    }

    final synchronized int size() {
        return this.turtlesHere.size();
    }

    public final void dropMark(String string, Object object) {
        this.change = true;
        if (this.marks == null) {
            this.marks = new Hashtable(1);
        }
        this.marks.put(string, object);
    }

    public final Object getMark(String string) {
        if (this.marks == null) {
            return null;
        }
        Object v = this.marks.get(string);
        if (v != null) {
            this.change = true;
            this.marks.remove(string);
            return v;
        }
        return null;
    }

    public final boolean isMarkPresent(String string) {
        if (this.marks != null) {
            return this.marks.containsKey(string);
        }
        return false;
    }

    public final Turtle[] getTurtles() {
        return this.turtlesHere.toArray(new Turtle[0]);
    }

    public final Patch[] getNeighbors() {
        return this.neighbors;
    }

    public final String toString() {
        String string = "";
        for (String string2 : this.world.variables.keySet()) {
            double d = this.getVariableValue(string2);
            string = string + "" + string2 + "=" + d + ",";
        }
        return string + "; ";
    }
}

